<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RESERVATION-PREVIEW StructType
 * @subpackage Structs
 */
class RESERVATION_PREVIEW extends AbstractStructBase
{
    /**
     * The RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $RESERVATION_OBJID;
    /**
     * The forecastrategross
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastrategross;
    /**
     * The forecastratenet
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecastratenet;
    /**
     * The SERVICE_POSTINGS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SERVICE_POSTINGS
     */
    public $SERVICE_POSTINGS;
    /**
     * Constructor method for RESERVATION-PREVIEW
     * @uses RESERVATION_PREVIEW::setRESERVATION_OBJID()
     * @uses RESERVATION_PREVIEW::setForecastrategross()
     * @uses RESERVATION_PREVIEW::setForecastratenet()
     * @uses RESERVATION_PREVIEW::setSERVICE_POSTINGS()
     * @param string $rESERVATION_OBJID
     * @param string $forecastrategross
     * @param string $forecastratenet
     * @param \StructType\SERVICE_POSTINGS $sERVICE_POSTINGS
     */
    public function __construct($rESERVATION_OBJID = null, $forecastrategross = null, $forecastratenet = null, \StructType\SERVICE_POSTINGS $sERVICE_POSTINGS = null)
    {
        $this
            ->setRESERVATION_OBJID($rESERVATION_OBJID)
            ->setForecastrategross($forecastrategross)
            ->setForecastratenet($forecastratenet)
            ->setSERVICE_POSTINGS($sERVICE_POSTINGS);
    }
    /**
     * Get RESERVATION_OBJID value
     * @return string
     */
    public function getRESERVATION_OBJID()
    {
        return $this->{'RESERVATION-OBJID'};
    }
    /**
     * Set RESERVATION_OBJID value
     * @param string $rESERVATION_OBJID
     * @return \StructType\RESERVATION_PREVIEW
     */
    public function setRESERVATION_OBJID($rESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rESERVATION_OBJID) && !is_string($rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rESERVATION_OBJID, true), gettype($rESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rESERVATION_OBJID) && !preg_match('/([0-9])*/', $rESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rESERVATION_OBJID, true)), __LINE__);
        }
        $this->RESERVATION_OBJID = $this->{'RESERVATION-OBJID'} = $rESERVATION_OBJID;
        return $this;
    }
    /**
     * Get forecastrategross value
     * @return string
     */
    public function getForecastrategross()
    {
        return $this->forecastrategross;
    }
    /**
     * Set forecastrategross value
     * @param string $forecastrategross
     * @return \StructType\RESERVATION_PREVIEW
     */
    public function setForecastrategross($forecastrategross = null)
    {
        // validation for constraint: string
        if (!is_null($forecastrategross) && !is_string($forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastrategross, true), gettype($forecastrategross)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastrategross) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastrategross)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastrategross, true)), __LINE__);
        }
        $this->forecastrategross = $forecastrategross;
        return $this;
    }
    /**
     * Get forecastratenet value
     * @return string
     */
    public function getForecastratenet()
    {
        return $this->forecastratenet;
    }
    /**
     * Set forecastratenet value
     * @param string $forecastratenet
     * @return \StructType\RESERVATION_PREVIEW
     */
    public function setForecastratenet($forecastratenet = null)
    {
        // validation for constraint: string
        if (!is_null($forecastratenet) && !is_string($forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecastratenet, true), gettype($forecastratenet)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecastratenet) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecastratenet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecastratenet, true)), __LINE__);
        }
        $this->forecastratenet = $forecastratenet;
        return $this;
    }
    /**
     * Get SERVICE_POSTINGS value
     * @return \StructType\SERVICE_POSTINGS
     */
    public function getSERVICE_POSTINGS()
    {
        return $this->{'SERVICE-POSTINGS'};
    }
    /**
     * Set SERVICE_POSTINGS value
     * @param \StructType\SERVICE_POSTINGS $sERVICE_POSTINGS
     * @return \StructType\RESERVATION_PREVIEW
     */
    public function setSERVICE_POSTINGS(\StructType\SERVICE_POSTINGS $sERVICE_POSTINGS = null)
    {
        $this->SERVICE_POSTINGS = $this->{'SERVICE-POSTINGS'} = $sERVICE_POSTINGS;
        return $this;
    }
}
