<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RATESEGMENTRESTRICTION-SEARCH StructType
 * @subpackage Structs
 */
class RATESEGMENTRESTRICTION_SEARCH extends AbstractStructBase
{
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The tobesoldfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldfrom;
    /**
     * The tobesoldto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $tobesoldto;
    /**
     * Constructor method for RATESEGMENTRESTRICTION-SEARCH
     * @uses RATESEGMENTRESTRICTION_SEARCH::setRatesegment()
     * @uses RATESEGMENTRESTRICTION_SEARCH::setDatefrom()
     * @uses RATESEGMENTRESTRICTION_SEARCH::setDateto()
     * @uses RATESEGMENTRESTRICTION_SEARCH::setTobesoldfrom()
     * @uses RATESEGMENTRESTRICTION_SEARCH::setTobesoldto()
     * @param string $ratesegment
     * @param string $datefrom
     * @param string $dateto
     * @param string $tobesoldfrom
     * @param string $tobesoldto
     */
    public function __construct($ratesegment = null, $datefrom = null, $dateto = null, $tobesoldfrom = null, $tobesoldto = null)
    {
        $this
            ->setRatesegment($ratesegment)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setTobesoldfrom($tobesoldfrom)
            ->setTobesoldto($tobesoldto);
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\RATESEGMENTRESTRICTION_SEARCH
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string|null
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\RATESEGMENTRESTRICTION_SEARCH
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string|null
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\RATESEGMENTRESTRICTION_SEARCH
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get tobesoldfrom value
     * @return string|null
     */
    public function getTobesoldfrom()
    {
        return $this->tobesoldfrom;
    }
    /**
     * Set tobesoldfrom value
     * @param string $tobesoldfrom
     * @return \StructType\RATESEGMENTRESTRICTION_SEARCH
     */
    public function setTobesoldfrom($tobesoldfrom = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldfrom) && !is_string($tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldfrom, true), gettype($tobesoldfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldfrom, true)), __LINE__);
        }
        $this->tobesoldfrom = $tobesoldfrom;
        return $this;
    }
    /**
     * Get tobesoldto value
     * @return string|null
     */
    public function getTobesoldto()
    {
        return $this->tobesoldto;
    }
    /**
     * Set tobesoldto value
     * @param string $tobesoldto
     * @return \StructType\RATESEGMENTRESTRICTION_SEARCH
     */
    public function setTobesoldto($tobesoldto = null)
    {
        // validation for constraint: string
        if (!is_null($tobesoldto) && !is_string($tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tobesoldto, true), gettype($tobesoldto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($tobesoldto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $tobesoldto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($tobesoldto, true)), __LINE__);
        }
        $this->tobesoldto = $tobesoldto;
        return $this;
    }
}
