<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RATEREQUESTSEARCH StructType
 * @subpackage Structs
 */
class RATEREQUESTSEARCH extends AbstractStructBase
{
    /**
     * The from
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $from;
    /**
     * The to
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $to;
    /**
     * The servicecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicecode;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ratesegment;
    /**
     * The scope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scope;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $discountgroup;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The ALLOTMENT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $ALLOTMENT_OBJID;
    /**
     * The PERSONTYPE
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PERSONTYPE[]
     */
    public $PERSONTYPE;
    /**
     * Constructor method for RATEREQUESTSEARCH
     * @uses RATEREQUESTSEARCH::setFrom()
     * @uses RATEREQUESTSEARCH::setTo()
     * @uses RATEREQUESTSEARCH::setServicecode()
     * @uses RATEREQUESTSEARCH::setRatecategory()
     * @uses RATEREQUESTSEARCH::setRatesegment()
     * @uses RATEREQUESTSEARCH::setScope()
     * @uses RATEREQUESTSEARCH::setDiscountgroup()
     * @uses RATEREQUESTSEARCH::setCurrency()
     * @uses RATEREQUESTSEARCH::setGUEST_OBJID()
     * @uses RATEREQUESTSEARCH::setALLOTMENT_OBJID()
     * @uses RATEREQUESTSEARCH::setPERSONTYPE()
     * @param string $from
     * @param string $to
     * @param string $servicecode
     * @param string $ratecategory
     * @param string $ratesegment
     * @param string $scope
     * @param string $discountgroup
     * @param string $currency
     * @param string $gUEST_OBJID
     * @param string $aLLOTMENT_OBJID
     * @param \StructType\PERSONTYPE[] $pERSONTYPE
     */
    public function __construct($from = null, $to = null, $servicecode = null, $ratecategory = null, $ratesegment = null, $scope = null, $discountgroup = null, $currency = null, $gUEST_OBJID = null, $aLLOTMENT_OBJID = null, array $pERSONTYPE = array())
    {
        $this
            ->setFrom($from)
            ->setTo($to)
            ->setServicecode($servicecode)
            ->setRatecategory($ratecategory)
            ->setRatesegment($ratesegment)
            ->setScope($scope)
            ->setDiscountgroup($discountgroup)
            ->setCurrency($currency)
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setALLOTMENT_OBJID($aLLOTMENT_OBJID)
            ->setPERSONTYPE($pERSONTYPE);
    }
    /**
     * Get from value
     * @return string
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param string $from
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setFrom($from = null)
    {
        // validation for constraint: string
        if (!is_null($from) && !is_string($from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from, true), gettype($from)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($from) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($from, true)), __LINE__);
        }
        $this->from = $from;
        return $this;
    }
    /**
     * Get to value
     * @return string
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param string $to
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setTo($to = null)
    {
        // validation for constraint: string
        if (!is_null($to) && !is_string($to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($to, true), gettype($to)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($to) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $to)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($to, true)), __LINE__);
        }
        $this->to = $to;
        return $this;
    }
    /**
     * Get servicecode value
     * @return string
     */
    public function getServicecode()
    {
        return $this->servicecode;
    }
    /**
     * Set servicecode value
     * @param string $servicecode
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setServicecode($servicecode = null)
    {
        // validation for constraint: string
        if (!is_null($servicecode) && !is_string($servicecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicecode, true), gettype($servicecode)), __LINE__);
        }
        $this->servicecode = $servicecode;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string|null
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string|null
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get GUEST_OBJID value
     * @return string|null
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get ALLOTMENT_OBJID value
     * @return string|null
     */
    public function getALLOTMENT_OBJID()
    {
        return $this->{'ALLOTMENT-OBJID'};
    }
    /**
     * Set ALLOTMENT_OBJID value
     * @param string $aLLOTMENT_OBJID
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setALLOTMENT_OBJID($aLLOTMENT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($aLLOTMENT_OBJID) && !is_string($aLLOTMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLLOTMENT_OBJID, true), gettype($aLLOTMENT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($aLLOTMENT_OBJID) && !preg_match('/([0-9])*/', $aLLOTMENT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($aLLOTMENT_OBJID, true)), __LINE__);
        }
        $this->ALLOTMENT_OBJID = $this->{'ALLOTMENT-OBJID'} = $aLLOTMENT_OBJID;
        return $this;
    }
    /**
     * Get PERSONTYPE value
     * @return \StructType\PERSONTYPE[]|null
     */
    public function getPERSONTYPE()
    {
        return $this->PERSONTYPE;
    }
    /**
     * This method is responsible for validating the values passed to the setPERSONTYPE method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPERSONTYPE method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePERSONTYPEForArrayConstraintsFromSetPERSONTYPE(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rATEREQUESTSEARCHPERSONTYPEItem) {
            // validation for constraint: itemType
            if (!$rATEREQUESTSEARCHPERSONTYPEItem instanceof \StructType\PERSONTYPE) {
                $invalidValues[] = is_object($rATEREQUESTSEARCHPERSONTYPEItem) ? get_class($rATEREQUESTSEARCHPERSONTYPEItem) : sprintf('%s(%s)', gettype($rATEREQUESTSEARCHPERSONTYPEItem), var_export($rATEREQUESTSEARCHPERSONTYPEItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PERSONTYPE property can only contain items of type \StructType\PERSONTYPE, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PERSONTYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\PERSONTYPE[] $pERSONTYPE
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function setPERSONTYPE(array $pERSONTYPE = array())
    {
        // validation for constraint: array
        if ('' !== ($pERSONTYPEArrayErrorMessage = self::validatePERSONTYPEForArrayConstraintsFromSetPERSONTYPE($pERSONTYPE))) {
            throw new \InvalidArgumentException($pERSONTYPEArrayErrorMessage, __LINE__);
        }
        $this->PERSONTYPE = $pERSONTYPE;
        return $this;
    }
    /**
     * Add item to PERSONTYPE value
     * @throws \InvalidArgumentException
     * @param \StructType\PERSONTYPE $item
     * @return \StructType\RATEREQUESTSEARCH
     */
    public function addToPERSONTYPE(\StructType\PERSONTYPE $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PERSONTYPE) {
            throw new \InvalidArgumentException(sprintf('The PERSONTYPE property can only contain items of type \StructType\PERSONTYPE, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PERSONTYPE[] = $item;
        return $this;
    }
}
