<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostedServicesForOutput StructType
 * @subpackage Structs
 */
class PostedServicesForOutput extends AbstractStructBase
{
    /**
     * The POSTING_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $POSTING_OBJID;
    /**
     * Constructor method for PostedServicesForOutput
     * @uses PostedServicesForOutput::setPOSTING_OBJID()
     * @param string $pOSTING_OBJID
     */
    public function __construct($pOSTING_OBJID = null)
    {
        $this
            ->setPOSTING_OBJID($pOSTING_OBJID);
    }
    /**
     * Get POSTING_OBJID value
     * @return string
     */
    public function getPOSTING_OBJID()
    {
        return $this->{'POSTING-OBJID'};
    }
    /**
     * Set POSTING_OBJID value
     * @param string $pOSTING_OBJID
     * @return \StructType\PostedServicesForOutput
     */
    public function setPOSTING_OBJID($pOSTING_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pOSTING_OBJID) && !is_string($pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSTING_OBJID, true), gettype($pOSTING_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pOSTING_OBJID) && !preg_match('/([0-9])*/', $pOSTING_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pOSTING_OBJID, true)), __LINE__);
        }
        $this->POSTING_OBJID = $this->{'POSTING-OBJID'} = $pOSTING_OBJID;
        return $this;
    }
}
