<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostPrePayment StructType
 * @subpackage Structs
 */
class PostPrePayment extends AbstractStructBase
{
    /**
     * The outstandingamountguestaccountwithoutdeposit
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $outstandingamountguestaccountwithoutdeposit;
    /**
     * The prepaymentguestaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $prepaymentguestaccount;
    /**
     * The outstandingamountguestaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $outstandingamountguestaccount;
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Account_1[]
     */
    public $Account;
    /**
     * Constructor method for PostPrePayment
     * @uses PostPrePayment::setOutstandingamountguestaccountwithoutdeposit()
     * @uses PostPrePayment::setPrepaymentguestaccount()
     * @uses PostPrePayment::setOutstandingamountguestaccount()
     * @uses PostPrePayment::setAccount()
     * @param string $outstandingamountguestaccountwithoutdeposit
     * @param string $prepaymentguestaccount
     * @param string $outstandingamountguestaccount
     * @param \StructType\Account_1[] $account
     */
    public function __construct($outstandingamountguestaccountwithoutdeposit = null, $prepaymentguestaccount = null, $outstandingamountguestaccount = null, array $account = array())
    {
        $this
            ->setOutstandingamountguestaccountwithoutdeposit($outstandingamountguestaccountwithoutdeposit)
            ->setPrepaymentguestaccount($prepaymentguestaccount)
            ->setOutstandingamountguestaccount($outstandingamountguestaccount)
            ->setAccount($account);
    }
    /**
     * Get outstandingamountguestaccountwithoutdeposit value
     * @return string
     */
    public function getOutstandingamountguestaccountwithoutdeposit()
    {
        return $this->outstandingamountguestaccountwithoutdeposit;
    }
    /**
     * Set outstandingamountguestaccountwithoutdeposit value
     * @param string $outstandingamountguestaccountwithoutdeposit
     * @return \StructType\PostPrePayment
     */
    public function setOutstandingamountguestaccountwithoutdeposit($outstandingamountguestaccountwithoutdeposit = null)
    {
        // validation for constraint: string
        if (!is_null($outstandingamountguestaccountwithoutdeposit) && !is_string($outstandingamountguestaccountwithoutdeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outstandingamountguestaccountwithoutdeposit, true), gettype($outstandingamountguestaccountwithoutdeposit)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($outstandingamountguestaccountwithoutdeposit) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $outstandingamountguestaccountwithoutdeposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($outstandingamountguestaccountwithoutdeposit, true)), __LINE__);
        }
        $this->outstandingamountguestaccountwithoutdeposit = $outstandingamountguestaccountwithoutdeposit;
        return $this;
    }
    /**
     * Get prepaymentguestaccount value
     * @return string
     */
    public function getPrepaymentguestaccount()
    {
        return $this->prepaymentguestaccount;
    }
    /**
     * Set prepaymentguestaccount value
     * @param string $prepaymentguestaccount
     * @return \StructType\PostPrePayment
     */
    public function setPrepaymentguestaccount($prepaymentguestaccount = null)
    {
        // validation for constraint: string
        if (!is_null($prepaymentguestaccount) && !is_string($prepaymentguestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaymentguestaccount, true), gettype($prepaymentguestaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($prepaymentguestaccount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $prepaymentguestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($prepaymentguestaccount, true)), __LINE__);
        }
        $this->prepaymentguestaccount = $prepaymentguestaccount;
        return $this;
    }
    /**
     * Get outstandingamountguestaccount value
     * @return string
     */
    public function getOutstandingamountguestaccount()
    {
        return $this->outstandingamountguestaccount;
    }
    /**
     * Set outstandingamountguestaccount value
     * @param string $outstandingamountguestaccount
     * @return \StructType\PostPrePayment
     */
    public function setOutstandingamountguestaccount($outstandingamountguestaccount = null)
    {
        // validation for constraint: string
        if (!is_null($outstandingamountguestaccount) && !is_string($outstandingamountguestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outstandingamountguestaccount, true), gettype($outstandingamountguestaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($outstandingamountguestaccount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $outstandingamountguestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($outstandingamountguestaccount, true)), __LINE__);
        }
        $this->outstandingamountguestaccount = $outstandingamountguestaccount;
        return $this;
    }
    /**
     * Get Account value
     * @return \StructType\Account_1[]|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * This method is responsible for validating the values passed to the setAccount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountForArrayConstraintsFromSetAccount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $postPrePaymentAccountItem) {
            // validation for constraint: itemType
            if (!$postPrePaymentAccountItem instanceof \StructType\Account_1) {
                $invalidValues[] = is_object($postPrePaymentAccountItem) ? get_class($postPrePaymentAccountItem) : sprintf('%s(%s)', gettype($postPrePaymentAccountItem), var_export($postPrePaymentAccountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Account property can only contain items of type \StructType\Account_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account_1[] $account
     * @return \StructType\PostPrePayment
     */
    public function setAccount(array $account = array())
    {
        // validation for constraint: array
        if ('' !== ($accountArrayErrorMessage = self::validateAccountForArrayConstraintsFromSetAccount($account))) {
            throw new \InvalidArgumentException($accountArrayErrorMessage, __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Add item to Account value
     * @throws \InvalidArgumentException
     * @param \StructType\Account_1 $item
     * @return \StructType\PostPrePayment
     */
    public function addToAccount(\StructType\Account_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Account_1) {
            throw new \InvalidArgumentException(sprintf('The Account property can only contain items of type \StructType\Account_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Account[] = $item;
        return $this;
    }
}
