<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoliceListSearch StructType
 * @subpackage Structs
 */
class PoliceListSearch extends AbstractStructBase
{
    /**
     * The POLICELIST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $POLICELIST_OBJID;
    /**
     * The PoliceList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PoliceList
     */
    public $PoliceList;
    /**
     * Constructor method for PoliceListSearch
     * @uses PoliceListSearch::setPOLICELIST_OBJID()
     * @uses PoliceListSearch::setPoliceList()
     * @param string $pOLICELIST_OBJID
     * @param \StructType\PoliceList $policeList
     */
    public function __construct($pOLICELIST_OBJID = null, \StructType\PoliceList $policeList = null)
    {
        $this
            ->setPOLICELIST_OBJID($pOLICELIST_OBJID)
            ->setPoliceList($policeList);
    }
    /**
     * Get POLICELIST_OBJID value
     * @return string
     */
    public function getPOLICELIST_OBJID()
    {
        return $this->{'POLICELIST-OBJID'};
    }
    /**
     * Set POLICELIST_OBJID value
     * @param string $pOLICELIST_OBJID
     * @return \StructType\PoliceListSearch
     */
    public function setPOLICELIST_OBJID($pOLICELIST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pOLICELIST_OBJID) && !is_string($pOLICELIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOLICELIST_OBJID, true), gettype($pOLICELIST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pOLICELIST_OBJID) && !preg_match('/([0-9])*/', $pOLICELIST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pOLICELIST_OBJID, true)), __LINE__);
        }
        $this->POLICELIST_OBJID = $this->{'POLICELIST-OBJID'} = $pOLICELIST_OBJID;
        return $this;
    }
    /**
     * Get PoliceList value
     * @return \StructType\PoliceList
     */
    public function getPoliceList()
    {
        return $this->PoliceList;
    }
    /**
     * Set PoliceList value
     * @param \StructType\PoliceList $policeList
     * @return \StructType\PoliceListSearch
     */
    public function setPoliceList(\StructType\PoliceList $policeList = null)
    {
        $this->PoliceList = $policeList;
        return $this;
    }
}
