<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonList StructType
 * @subpackage Structs
 */
class PersonList extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * Constructor method for PersonList
     * @uses PersonList::setPERSON_OBJID()
     * @uses PersonList::setName1()
     * @uses PersonList::setName2()
     * @uses PersonList::setBirthdate()
     * @param string $pERSON_OBJID
     * @param string $name1
     * @param string $name2
     * @param string $birthdate
     */
    public function __construct($pERSON_OBJID = null, $name1 = null, $name2 = null, $birthdate = null)
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setName1($name1)
            ->setName2($name2)
            ->setBirthdate($birthdate);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\PersonList
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\PersonList
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\PersonList
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name2) && mb_strlen($name2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\PersonList
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
}
