<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAbort StructType
 * @subpackage Structs
 */
class PaymentAbort extends AbstractStructBase
{
    /**
     * The cardInfoRefID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $cardInfoRefID;
    /**
     * The returnCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $returnCode;
    /**
     * The returnText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $returnText;
    /**
     * The serviceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceProvider;
    /**
     * The returnCodeServiceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnCodeServiceProvider;
    /**
     * The returnTextServiceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnTextServiceProvider;
    /**
     * Constructor method for PaymentAbort
     * @uses PaymentAbort::setCardInfoRefID()
     * @uses PaymentAbort::setReturnCode()
     * @uses PaymentAbort::setReturnText()
     * @uses PaymentAbort::setServiceProvider()
     * @uses PaymentAbort::setReturnCodeServiceProvider()
     * @uses PaymentAbort::setReturnTextServiceProvider()
     * @param string $cardInfoRefID
     * @param string $returnCode
     * @param string $returnText
     * @param string $serviceProvider
     * @param string $returnCodeServiceProvider
     * @param string $returnTextServiceProvider
     */
    public function __construct($cardInfoRefID = null, $returnCode = null, $returnText = null, $serviceProvider = null, $returnCodeServiceProvider = null, $returnTextServiceProvider = null)
    {
        $this
            ->setCardInfoRefID($cardInfoRefID)
            ->setReturnCode($returnCode)
            ->setReturnText($returnText)
            ->setServiceProvider($serviceProvider)
            ->setReturnCodeServiceProvider($returnCodeServiceProvider)
            ->setReturnTextServiceProvider($returnTextServiceProvider);
    }
    /**
     * Get cardInfoRefID value
     * @return string
     */
    public function getCardInfoRefID()
    {
        return $this->cardInfoRefID;
    }
    /**
     * Set cardInfoRefID value
     * @param string $cardInfoRefID
     * @return \StructType\PaymentAbort
     */
    public function setCardInfoRefID($cardInfoRefID = null)
    {
        // validation for constraint: string
        if (!is_null($cardInfoRefID) && !is_string($cardInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardInfoRefID, true), gettype($cardInfoRefID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($cardInfoRefID) && !preg_match('/([0-9])*/', $cardInfoRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($cardInfoRefID, true)), __LINE__);
        }
        $this->cardInfoRefID = $cardInfoRefID;
        return $this;
    }
    /**
     * Get returnCode value
     * @return string
     */
    public function getReturnCode()
    {
        return $this->returnCode;
    }
    /**
     * Set returnCode value
     * @param string $returnCode
     * @return \StructType\PaymentAbort
     */
    public function setReturnCode($returnCode = null)
    {
        // validation for constraint: string
        if (!is_null($returnCode) && !is_string($returnCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnCode, true), gettype($returnCode)), __LINE__);
        }
        $this->returnCode = $returnCode;
        return $this;
    }
    /**
     * Get returnText value
     * @return string
     */
    public function getReturnText()
    {
        return $this->returnText;
    }
    /**
     * Set returnText value
     * @param string $returnText
     * @return \StructType\PaymentAbort
     */
    public function setReturnText($returnText = null)
    {
        // validation for constraint: string
        if (!is_null($returnText) && !is_string($returnText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnText, true), gettype($returnText)), __LINE__);
        }
        $this->returnText = $returnText;
        return $this;
    }
    /**
     * Get serviceProvider value
     * @return string|null
     */
    public function getServiceProvider()
    {
        return $this->serviceProvider;
    }
    /**
     * Set serviceProvider value
     * @param string $serviceProvider
     * @return \StructType\PaymentAbort
     */
    public function setServiceProvider($serviceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProvider) && !is_string($serviceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProvider, true), gettype($serviceProvider)), __LINE__);
        }
        $this->serviceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get returnCodeServiceProvider value
     * @return string|null
     */
    public function getReturnCodeServiceProvider()
    {
        return $this->returnCodeServiceProvider;
    }
    /**
     * Set returnCodeServiceProvider value
     * @param string $returnCodeServiceProvider
     * @return \StructType\PaymentAbort
     */
    public function setReturnCodeServiceProvider($returnCodeServiceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($returnCodeServiceProvider) && !is_string($returnCodeServiceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnCodeServiceProvider, true), gettype($returnCodeServiceProvider)), __LINE__);
        }
        $this->returnCodeServiceProvider = $returnCodeServiceProvider;
        return $this;
    }
    /**
     * Get returnTextServiceProvider value
     * @return string|null
     */
    public function getReturnTextServiceProvider()
    {
        return $this->returnTextServiceProvider;
    }
    /**
     * Set returnTextServiceProvider value
     * @param string $returnTextServiceProvider
     * @return \StructType\PaymentAbort
     */
    public function setReturnTextServiceProvider($returnTextServiceProvider = null)
    {
        // validation for constraint: string
        if (!is_null($returnTextServiceProvider) && !is_string($returnTextServiceProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnTextServiceProvider, true), gettype($returnTextServiceProvider)), __LINE__);
        }
        $this->returnTextServiceProvider = $returnTextServiceProvider;
        return $this;
    }
}
