<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PERSON StructType
 * @subpackage Structs
 */
class PERSON_2 extends AbstractStructBase
{
    /**
     * The PERSON_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $PERSON_OBJID;
    /**
     * The CARD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CARD
     */
    public $CARD;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The guesttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $guesttype;
    /**
     * The sex
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sex;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $title;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutation;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The ratecategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratecategory;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The arrivaltime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $arrivaltime;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The departuretime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $departuretime;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip;
    /**
     * The vip2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip2;
    /**
     * The GUEST_IDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUEST_IDS
     */
    public $GUEST_IDS;
    /**
     * The LOYALTY_CARDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LOYALTY_CARDS
     */
    public $LOYALTY_CARDS;
    /**
     * The PERSONPACKAGES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PERSONPACKAGES
     */
    public $PERSONPACKAGES;
    /**
     * The personStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $personStatus;
    /**
     * The persontype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $persontype;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $nationality;
    /**
     * The GUESTACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUESTACCOUNT[]
     */
    public $GUESTACCOUNT;
    /**
     * The GUEST
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST[]
     */
    public $GUEST;
    /**
     * The REGISTRATIONCARD
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\REGISTRATIONCARD_1[]
     */
    public $REGISTRATIONCARD;
    /**
     * Constructor method for PERSON
     * @uses PERSON_2::setPERSON_OBJID()
     * @uses PERSON_2::setCARD()
     * @uses PERSON_2::setName1()
     * @uses PERSON_2::setName2()
     * @uses PERSON_2::setGuesttype()
     * @uses PERSON_2::setSex()
     * @uses PERSON_2::setTitle()
     * @uses PERSON_2::setBirthdate()
     * @uses PERSON_2::setAddress()
     * @uses PERSON_2::setCountry()
     * @uses PERSON_2::setCity()
     * @uses PERSON_2::setStreet()
     * @uses PERSON_2::setPostcode()
     * @uses PERSON_2::setSubcountry()
     * @uses PERSON_2::setMarketsegment()
     * @uses PERSON_2::setSalutation()
     * @uses PERSON_2::setEmail1()
     * @uses PERSON_2::setMobile1()
     * @uses PERSON_2::setRatecategory()
     * @uses PERSON_2::setDatefrom()
     * @uses PERSON_2::setArrivaltime()
     * @uses PERSON_2::setDateto()
     * @uses PERSON_2::setDeparturetime()
     * @uses PERSON_2::setVip()
     * @uses PERSON_2::setVip2()
     * @uses PERSON_2::setGUEST_IDS()
     * @uses PERSON_2::setLOYALTY_CARDS()
     * @uses PERSON_2::setPERSONPACKAGES()
     * @uses PERSON_2::setPersonStatus()
     * @uses PERSON_2::setPersontype()
     * @uses PERSON_2::setNationality()
     * @uses PERSON_2::setGUESTACCOUNT()
     * @uses PERSON_2::setGUEST()
     * @uses PERSON_2::setREGISTRATIONCARD()
     * @param string $pERSON_OBJID
     * @param \StructType\CARD $cARD
     * @param string $name1
     * @param string $name2
     * @param string $guesttype
     * @param string $sex
     * @param string $title
     * @param string $birthdate
     * @param string $address
     * @param string $country
     * @param string $city
     * @param string $street
     * @param string $postcode
     * @param string $subcountry
     * @param string $marketsegment
     * @param string $salutation
     * @param string $email1
     * @param string $mobile1
     * @param string $ratecategory
     * @param string $datefrom
     * @param string $arrivaltime
     * @param string $dateto
     * @param string $departuretime
     * @param string $vip
     * @param string $vip2
     * @param \StructType\GUEST_IDS $gUEST_IDS
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     * @param \StructType\PERSONPACKAGES $pERSONPACKAGES
     * @param string $personStatus
     * @param string $persontype
     * @param string $nationality
     * @param \StructType\GUESTACCOUNT[] $gUESTACCOUNT
     * @param \StructType\GUEST[] $gUEST
     * @param \StructType\REGISTRATIONCARD_1[] $rEGISTRATIONCARD
     */
    public function __construct($pERSON_OBJID = null, \StructType\CARD $cARD = null, $name1 = null, $name2 = null, $guesttype = null, $sex = null, $title = null, $birthdate = null, $address = null, $country = null, $city = null, $street = null, $postcode = null, $subcountry = null, $marketsegment = null, $salutation = null, $email1 = null, $mobile1 = null, $ratecategory = null, $datefrom = null, $arrivaltime = null, $dateto = null, $departuretime = null, $vip = null, $vip2 = null, \StructType\GUEST_IDS $gUEST_IDS = null, \StructType\LOYALTY_CARDS $lOYALTY_CARDS = null, \StructType\PERSONPACKAGES $pERSONPACKAGES = null, $personStatus = null, $persontype = null, $nationality = null, array $gUESTACCOUNT = array(), array $gUEST = array(), array $rEGISTRATIONCARD = array())
    {
        $this
            ->setPERSON_OBJID($pERSON_OBJID)
            ->setCARD($cARD)
            ->setName1($name1)
            ->setName2($name2)
            ->setGuesttype($guesttype)
            ->setSex($sex)
            ->setTitle($title)
            ->setBirthdate($birthdate)
            ->setAddress($address)
            ->setCountry($country)
            ->setCity($city)
            ->setStreet($street)
            ->setPostcode($postcode)
            ->setSubcountry($subcountry)
            ->setMarketsegment($marketsegment)
            ->setSalutation($salutation)
            ->setEmail1($email1)
            ->setMobile1($mobile1)
            ->setRatecategory($ratecategory)
            ->setDatefrom($datefrom)
            ->setArrivaltime($arrivaltime)
            ->setDateto($dateto)
            ->setDeparturetime($departuretime)
            ->setVip($vip)
            ->setVip2($vip2)
            ->setGUEST_IDS($gUEST_IDS)
            ->setLOYALTY_CARDS($lOYALTY_CARDS)
            ->setPERSONPACKAGES($pERSONPACKAGES)
            ->setPersonStatus($personStatus)
            ->setPersontype($persontype)
            ->setNationality($nationality)
            ->setGUESTACCOUNT($gUESTACCOUNT)
            ->setGUEST($gUEST)
            ->setREGISTRATIONCARD($rEGISTRATIONCARD);
    }
    /**
     * Get PERSON_OBJID value
     * @return string
     */
    public function getPERSON_OBJID()
    {
        return $this->{'PERSON-OBJID'};
    }
    /**
     * Set PERSON_OBJID value
     * @param string $pERSON_OBJID
     * @return \StructType\PERSON_2
     */
    public function setPERSON_OBJID($pERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($pERSON_OBJID) && !is_string($pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pERSON_OBJID, true), gettype($pERSON_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($pERSON_OBJID) && !preg_match('/([0-9])*/', $pERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($pERSON_OBJID, true)), __LINE__);
        }
        $this->PERSON_OBJID = $this->{'PERSON-OBJID'} = $pERSON_OBJID;
        return $this;
    }
    /**
     * Get CARD value
     * @return \StructType\CARD
     */
    public function getCARD()
    {
        return $this->CARD;
    }
    /**
     * Set CARD value
     * @param \StructType\CARD $cARD
     * @return \StructType\PERSON_2
     */
    public function setCARD(\StructType\CARD $cARD = null)
    {
        $this->CARD = $cARD;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\PERSON_2
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\PERSON_2
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($name2) && mb_strlen($name2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get guesttype value
     * @return string
     */
    public function getGuesttype()
    {
        return $this->guesttype;
    }
    /**
     * Set guesttype value
     * @param string $guesttype
     * @return \StructType\PERSON_2
     */
    public function setGuesttype($guesttype = null)
    {
        // validation for constraint: string
        if (!is_null($guesttype) && !is_string($guesttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guesttype, true), gettype($guesttype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($guesttype) && mb_strlen($guesttype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($guesttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($guesttype) && mb_strlen($guesttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($guesttype)), __LINE__);
        }
        $this->guesttype = $guesttype;
        return $this;
    }
    /**
     * Get sex value
     * @return string
     */
    public function getSex()
    {
        return $this->sex;
    }
    /**
     * Set sex value
     * @param string $sex
     * @return \StructType\PERSON_2
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sex, true), gettype($sex)), __LINE__);
        }
        $this->sex = $sex;
        return $this;
    }
    /**
     * Get title value
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\PERSON_2
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\PERSON_2
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\PERSON_2
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\PERSON_2
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\PERSON_2
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\PERSON_2
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\PERSON_2
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\PERSON_2
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\PERSON_2
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get salutation value
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\PERSON_2
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\PERSON_2
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\PERSON_2
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get ratecategory value
     * @return string
     */
    public function getRatecategory()
    {
        return $this->ratecategory;
    }
    /**
     * Set ratecategory value
     * @param string $ratecategory
     * @return \StructType\PERSON_2
     */
    public function setRatecategory($ratecategory = null)
    {
        // validation for constraint: string
        if (!is_null($ratecategory) && !is_string($ratecategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratecategory, true), gettype($ratecategory)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($ratecategory) && mb_strlen($ratecategory) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($ratecategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratecategory) && mb_strlen($ratecategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratecategory)), __LINE__);
        }
        $this->ratecategory = $ratecategory;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\PERSON_2
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get arrivaltime value
     * @return string
     */
    public function getArrivaltime()
    {
        return $this->arrivaltime;
    }
    /**
     * Set arrivaltime value
     * @param string $arrivaltime
     * @return \StructType\PERSON_2
     */
    public function setArrivaltime($arrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivaltime) && !is_string($arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivaltime, true), gettype($arrivaltime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($arrivaltime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $arrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($arrivaltime, true)), __LINE__);
        }
        $this->arrivaltime = $arrivaltime;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\PERSON_2
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get departuretime value
     * @return string
     */
    public function getDeparturetime()
    {
        return $this->departuretime;
    }
    /**
     * Set departuretime value
     * @param string $departuretime
     * @return \StructType\PERSON_2
     */
    public function setDeparturetime($departuretime = null)
    {
        // validation for constraint: string
        if (!is_null($departuretime) && !is_string($departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departuretime, true), gettype($departuretime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($departuretime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $departuretime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($departuretime, true)), __LINE__);
        }
        $this->departuretime = $departuretime;
        return $this;
    }
    /**
     * Get vip value
     * @return string
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\PERSON_2
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip) && mb_strlen($vip) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip) && mb_strlen($vip) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get vip2 value
     * @return string
     */
    public function getVip2()
    {
        return $this->vip2;
    }
    /**
     * Set vip2 value
     * @param string $vip2
     * @return \StructType\PERSON_2
     */
    public function setVip2($vip2 = null)
    {
        // validation for constraint: string
        if (!is_null($vip2) && !is_string($vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip2, true), gettype($vip2)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip2) && mb_strlen($vip2) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip2) && mb_strlen($vip2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip2)), __LINE__);
        }
        $this->vip2 = $vip2;
        return $this;
    }
    /**
     * Get GUEST_IDS value
     * @return \StructType\GUEST_IDS
     */
    public function getGUEST_IDS()
    {
        return $this->{'GUEST-IDS'};
    }
    /**
     * Set GUEST_IDS value
     * @param \StructType\GUEST_IDS $gUEST_IDS
     * @return \StructType\PERSON_2
     */
    public function setGUEST_IDS(\StructType\GUEST_IDS $gUEST_IDS = null)
    {
        $this->GUEST_IDS = $this->{'GUEST-IDS'} = $gUEST_IDS;
        return $this;
    }
    /**
     * Get LOYALTY_CARDS value
     * @return \StructType\LOYALTY_CARDS
     */
    public function getLOYALTY_CARDS()
    {
        return $this->{'LOYALTY-CARDS'};
    }
    /**
     * Set LOYALTY_CARDS value
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     * @return \StructType\PERSON_2
     */
    public function setLOYALTY_CARDS(\StructType\LOYALTY_CARDS $lOYALTY_CARDS = null)
    {
        $this->LOYALTY_CARDS = $this->{'LOYALTY-CARDS'} = $lOYALTY_CARDS;
        return $this;
    }
    /**
     * Get PERSONPACKAGES value
     * @return \StructType\PERSONPACKAGES
     */
    public function getPERSONPACKAGES()
    {
        return $this->PERSONPACKAGES;
    }
    /**
     * Set PERSONPACKAGES value
     * @param \StructType\PERSONPACKAGES $pERSONPACKAGES
     * @return \StructType\PERSON_2
     */
    public function setPERSONPACKAGES(\StructType\PERSONPACKAGES $pERSONPACKAGES = null)
    {
        $this->PERSONPACKAGES = $pERSONPACKAGES;
        return $this;
    }
    /**
     * Get personStatus value
     * @return string
     */
    public function getPersonStatus()
    {
        return $this->personStatus;
    }
    /**
     * Set personStatus value
     * @param string $personStatus
     * @return \StructType\PERSON_2
     */
    public function setPersonStatus($personStatus = null)
    {
        // validation for constraint: string
        if (!is_null($personStatus) && !is_string($personStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personStatus, true), gettype($personStatus)), __LINE__);
        }
        $this->personStatus = $personStatus;
        return $this;
    }
    /**
     * Get persontype value
     * @return string
     */
    public function getPersontype()
    {
        return $this->persontype;
    }
    /**
     * Set persontype value
     * @param string $persontype
     * @return \StructType\PERSON_2
     */
    public function setPersontype($persontype = null)
    {
        // validation for constraint: string
        if (!is_null($persontype) && !is_string($persontype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($persontype, true), gettype($persontype)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($persontype) && mb_strlen($persontype) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($persontype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($persontype) && mb_strlen($persontype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($persontype)), __LINE__);
        }
        $this->persontype = $persontype;
        return $this;
    }
    /**
     * Get nationality value
     * @return string
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\PERSON_2
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get GUESTACCOUNT value
     * @return \StructType\GUESTACCOUNT[]|null
     */
    public function getGUESTACCOUNT()
    {
        return $this->GUESTACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setGUESTACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUESTACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTACCOUNTForArrayConstraintsFromSetGUESTACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pERSONGUESTACCOUNTItem) {
            // validation for constraint: itemType
            if (!$pERSONGUESTACCOUNTItem instanceof \StructType\GUESTACCOUNT) {
                $invalidValues[] = is_object($pERSONGUESTACCOUNTItem) ? get_class($pERSONGUESTACCOUNTItem) : sprintf('%s(%s)', gettype($pERSONGUESTACCOUNTItem), var_export($pERSONGUESTACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUESTACCOUNT property can only contain items of type \StructType\GUESTACCOUNT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUESTACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTACCOUNT[] $gUESTACCOUNT
     * @return \StructType\PERSON_2
     */
    public function setGUESTACCOUNT(array $gUESTACCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTACCOUNTArrayErrorMessage = self::validateGUESTACCOUNTForArrayConstraintsFromSetGUESTACCOUNT($gUESTACCOUNT))) {
            throw new \InvalidArgumentException($gUESTACCOUNTArrayErrorMessage, __LINE__);
        }
        $this->GUESTACCOUNT = $gUESTACCOUNT;
        return $this;
    }
    /**
     * Add item to GUESTACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\GUESTACCOUNT $item
     * @return \StructType\PERSON_2
     */
    public function addToGUESTACCOUNT(\StructType\GUESTACCOUNT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUESTACCOUNT) {
            throw new \InvalidArgumentException(sprintf('The GUESTACCOUNT property can only contain items of type \StructType\GUESTACCOUNT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUESTACCOUNT[] = $item;
        return $this;
    }
    /**
     * Get GUEST value
     * @return \StructType\GUEST[]|null
     */
    public function getGUEST()
    {
        return $this->GUEST;
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUESTForArrayConstraintsFromSetGUEST(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pERSONGUESTItem) {
            // validation for constraint: itemType
            if (!$pERSONGUESTItem instanceof \StructType\GUEST) {
                $invalidValues[] = is_object($pERSONGUESTItem) ? get_class($pERSONGUESTItem) : sprintf('%s(%s)', gettype($pERSONGUESTItem), var_export($pERSONGUESTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST[] $gUEST
     * @return \StructType\PERSON_2
     */
    public function setGUEST(array $gUEST = array())
    {
        // validation for constraint: array
        if ('' !== ($gUESTArrayErrorMessage = self::validateGUESTForArrayConstraintsFromSetGUEST($gUEST))) {
            throw new \InvalidArgumentException($gUESTArrayErrorMessage, __LINE__);
        }
        $this->GUEST = $gUEST;
        return $this;
    }
    /**
     * Add item to GUEST value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST $item
     * @return \StructType\PERSON_2
     */
    public function addToGUEST(\StructType\GUEST $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST) {
            throw new \InvalidArgumentException(sprintf('The GUEST property can only contain items of type \StructType\GUEST, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST[] = $item;
        return $this;
    }
    /**
     * Get REGISTRATIONCARD value
     * @return \StructType\REGISTRATIONCARD_1[]|null
     */
    public function getREGISTRATIONCARD()
    {
        return $this->REGISTRATIONCARD;
    }
    /**
     * This method is responsible for validating the values passed to the setREGISTRATIONCARD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setREGISTRATIONCARD method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateREGISTRATIONCARDForArrayConstraintsFromSetREGISTRATIONCARD(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pERSONREGISTRATIONCARDItem) {
            // validation for constraint: itemType
            if (!$pERSONREGISTRATIONCARDItem instanceof \StructType\REGISTRATIONCARD_1) {
                $invalidValues[] = is_object($pERSONREGISTRATIONCARDItem) ? get_class($pERSONREGISTRATIONCARDItem) : sprintf('%s(%s)', gettype($pERSONREGISTRATIONCARDItem), var_export($pERSONREGISTRATIONCARDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The REGISTRATIONCARD property can only contain items of type \StructType\REGISTRATIONCARD_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set REGISTRATIONCARD value
     * @throws \InvalidArgumentException
     * @param \StructType\REGISTRATIONCARD_1[] $rEGISTRATIONCARD
     * @return \StructType\PERSON_2
     */
    public function setREGISTRATIONCARD(array $rEGISTRATIONCARD = array())
    {
        // validation for constraint: array
        if ('' !== ($rEGISTRATIONCARDArrayErrorMessage = self::validateREGISTRATIONCARDForArrayConstraintsFromSetREGISTRATIONCARD($rEGISTRATIONCARD))) {
            throw new \InvalidArgumentException($rEGISTRATIONCARDArrayErrorMessage, __LINE__);
        }
        $this->REGISTRATIONCARD = $rEGISTRATIONCARD;
        return $this;
    }
    /**
     * Add item to REGISTRATIONCARD value
     * @throws \InvalidArgumentException
     * @param \StructType\REGISTRATIONCARD_1 $item
     * @return \StructType\PERSON_2
     */
    public function addToREGISTRATIONCARD(\StructType\REGISTRATIONCARD_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\REGISTRATIONCARD_1) {
            throw new \InvalidArgumentException(sprintf('The REGISTRATIONCARD property can only contain items of type \StructType\REGISTRATIONCARD_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->REGISTRATIONCARD[] = $item;
        return $this;
    }
}
