<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAYMENT-POSTING-SEARCH StructType
 * @subpackage Structs
 */
class PAYMENT_POSTING_SEARCH extends AbstractStructBase
{
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateTo;
    /**
     * The showonlyinvoiced
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $showonlyinvoiced;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $typeofpayment;
    /**
     * The bookingarea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bookingarea;
    /**
     * Constructor method for PAYMENT-POSTING-SEARCH
     * @uses PAYMENT_POSTING_SEARCH::setDateFrom()
     * @uses PAYMENT_POSTING_SEARCH::setDateTo()
     * @uses PAYMENT_POSTING_SEARCH::setShowonlyinvoiced()
     * @uses PAYMENT_POSTING_SEARCH::setTypeofpayment()
     * @uses PAYMENT_POSTING_SEARCH::setBookingarea()
     * @param string $dateFrom
     * @param string $dateTo
     * @param string $showonlyinvoiced
     * @param string $typeofpayment
     * @param string $bookingarea
     */
    public function __construct($dateFrom = null, $dateTo = null, $showonlyinvoiced = null, $typeofpayment = null, $bookingarea = null)
    {
        $this
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setShowonlyinvoiced($showonlyinvoiced)
            ->setTypeofpayment($typeofpayment)
            ->setBookingarea($bookingarea);
    }
    /**
     * Get dateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateFrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateFrom, true)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param string $dateTo
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateTo) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateTo, true)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Get showonlyinvoiced value
     * @return string|null
     */
    public function getShowonlyinvoiced()
    {
        return $this->showonlyinvoiced;
    }
    /**
     * Set showonlyinvoiced value
     * @param string $showonlyinvoiced
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function setShowonlyinvoiced($showonlyinvoiced = null)
    {
        // validation for constraint: string
        if (!is_null($showonlyinvoiced) && !is_string($showonlyinvoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showonlyinvoiced, true), gettype($showonlyinvoiced)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($showonlyinvoiced) && !preg_match('/([-+]){0,1}([0-9])*/', $showonlyinvoiced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($showonlyinvoiced, true)), __LINE__);
        }
        $this->showonlyinvoiced = $showonlyinvoiced;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string|null
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get bookingarea value
     * @return string|null
     */
    public function getBookingarea()
    {
        return $this->bookingarea;
    }
    /**
     * Set bookingarea value
     * @param string $bookingarea
     * @return \StructType\PAYMENT_POSTING_SEARCH
     */
    public function setBookingarea($bookingarea = null)
    {
        // validation for constraint: string
        if (!is_null($bookingarea) && !is_string($bookingarea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingarea, true), gettype($bookingarea)), __LINE__);
        }
        $this->bookingarea = $bookingarea;
        return $this;
    }
}
