<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PAYMENT-INSTRUCTION StructType
 * @subpackage Structs
 */
class PAYMENT_INSTRUCTION extends AbstractStructBase
{
    /**
     * The allaccounts
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $allaccounts;
    /**
     * The ordereraccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ordereraccount;
    /**
     * The guestaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestaccount;
    /**
     * The groupaccount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $groupaccount;
    /**
     * Constructor method for PAYMENT-INSTRUCTION
     * @uses PAYMENT_INSTRUCTION::setAllaccounts()
     * @uses PAYMENT_INSTRUCTION::setOrdereraccount()
     * @uses PAYMENT_INSTRUCTION::setGuestaccount()
     * @uses PAYMENT_INSTRUCTION::setGroupaccount()
     * @param string $allaccounts
     * @param string $ordereraccount
     * @param string $guestaccount
     * @param string $groupaccount
     */
    public function __construct($allaccounts = null, $ordereraccount = null, $guestaccount = null, $groupaccount = null)
    {
        $this
            ->setAllaccounts($allaccounts)
            ->setOrdereraccount($ordereraccount)
            ->setGuestaccount($guestaccount)
            ->setGroupaccount($groupaccount);
    }
    /**
     * Get allaccounts value
     * @return string|null
     */
    public function getAllaccounts()
    {
        return $this->allaccounts;
    }
    /**
     * Set allaccounts value
     * @param string $allaccounts
     * @return \StructType\PAYMENT_INSTRUCTION
     */
    public function setAllaccounts($allaccounts = null)
    {
        // validation for constraint: string
        if (!is_null($allaccounts) && !is_string($allaccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allaccounts, true), gettype($allaccounts)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($allaccounts) && !preg_match('/([-+]){0,1}([0-9])*/', $allaccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($allaccounts, true)), __LINE__);
        }
        $this->allaccounts = $allaccounts;
        return $this;
    }
    /**
     * Get ordereraccount value
     * @return string|null
     */
    public function getOrdereraccount()
    {
        return $this->ordereraccount;
    }
    /**
     * Set ordereraccount value
     * @param string $ordereraccount
     * @return \StructType\PAYMENT_INSTRUCTION
     */
    public function setOrdereraccount($ordereraccount = null)
    {
        // validation for constraint: string
        if (!is_null($ordereraccount) && !is_string($ordereraccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordereraccount, true), gettype($ordereraccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ordereraccount) && !preg_match('/([-+]){0,1}([0-9])*/', $ordereraccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ordereraccount, true)), __LINE__);
        }
        $this->ordereraccount = $ordereraccount;
        return $this;
    }
    /**
     * Get guestaccount value
     * @return string|null
     */
    public function getGuestaccount()
    {
        return $this->guestaccount;
    }
    /**
     * Set guestaccount value
     * @param string $guestaccount
     * @return \StructType\PAYMENT_INSTRUCTION
     */
    public function setGuestaccount($guestaccount = null)
    {
        // validation for constraint: string
        if (!is_null($guestaccount) && !is_string($guestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestaccount, true), gettype($guestaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestaccount) && !preg_match('/([-+]){0,1}([0-9])*/', $guestaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestaccount, true)), __LINE__);
        }
        $this->guestaccount = $guestaccount;
        return $this;
    }
    /**
     * Get groupaccount value
     * @return string|null
     */
    public function getGroupaccount()
    {
        return $this->groupaccount;
    }
    /**
     * Set groupaccount value
     * @param string $groupaccount
     * @return \StructType\PAYMENT_INSTRUCTION
     */
    public function setGroupaccount($groupaccount = null)
    {
        // validation for constraint: string
        if (!is_null($groupaccount) && !is_string($groupaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupaccount, true), gettype($groupaccount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($groupaccount) && !preg_match('/([-+]){0,1}([0-9])*/', $groupaccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($groupaccount, true)), __LINE__);
        }
        $this->groupaccount = $groupaccount;
        return $this;
    }
}
