<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PARTLIST StructType
 * @subpackage Structs
 */
class PARTLIST extends AbstractStructBase
{
    /**
     * The VATS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VATS
     */
    public $VATS;
    /**
     * The TAXS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAXS
     */
    public $TAXS;
    /**
     * The COMPONENT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\COMPONENT[]
     */
    public $COMPONENT;
    /**
     * Constructor method for PARTLIST
     * @uses PARTLIST::setVATS()
     * @uses PARTLIST::setTAXS()
     * @uses PARTLIST::setCOMPONENT()
     * @param \StructType\VATS $vATS
     * @param \StructType\TAXS $tAXS
     * @param \StructType\COMPONENT[] $cOMPONENT
     */
    public function __construct(\StructType\VATS $vATS = null, \StructType\TAXS $tAXS = null, array $cOMPONENT = array())
    {
        $this
            ->setVATS($vATS)
            ->setTAXS($tAXS)
            ->setCOMPONENT($cOMPONENT);
    }
    /**
     * Get VATS value
     * @return \StructType\VATS
     */
    public function getVATS()
    {
        return $this->VATS;
    }
    /**
     * Set VATS value
     * @param \StructType\VATS $vATS
     * @return \StructType\PARTLIST
     */
    public function setVATS(\StructType\VATS $vATS = null)
    {
        $this->VATS = $vATS;
        return $this;
    }
    /**
     * Get TAXS value
     * @return \StructType\TAXS
     */
    public function getTAXS()
    {
        return $this->TAXS;
    }
    /**
     * Set TAXS value
     * @param \StructType\TAXS $tAXS
     * @return \StructType\PARTLIST
     */
    public function setTAXS(\StructType\TAXS $tAXS = null)
    {
        $this->TAXS = $tAXS;
        return $this;
    }
    /**
     * Get COMPONENT value
     * @return \StructType\COMPONENT[]|null
     */
    public function getCOMPONENT()
    {
        return $this->COMPONENT;
    }
    /**
     * This method is responsible for validating the values passed to the setCOMPONENT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCOMPONENT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCOMPONENTForArrayConstraintsFromSetCOMPONENT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pARTLISTCOMPONENTItem) {
            // validation for constraint: itemType
            if (!$pARTLISTCOMPONENTItem instanceof \StructType\COMPONENT) {
                $invalidValues[] = is_object($pARTLISTCOMPONENTItem) ? get_class($pARTLISTCOMPONENTItem) : sprintf('%s(%s)', gettype($pARTLISTCOMPONENTItem), var_export($pARTLISTCOMPONENTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The COMPONENT property can only contain items of type \StructType\COMPONENT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set COMPONENT value
     * @throws \InvalidArgumentException
     * @param \StructType\COMPONENT[] $cOMPONENT
     * @return \StructType\PARTLIST
     */
    public function setCOMPONENT(array $cOMPONENT = array())
    {
        // validation for constraint: array
        if ('' !== ($cOMPONENTArrayErrorMessage = self::validateCOMPONENTForArrayConstraintsFromSetCOMPONENT($cOMPONENT))) {
            throw new \InvalidArgumentException($cOMPONENTArrayErrorMessage, __LINE__);
        }
        $this->COMPONENT = $cOMPONENT;
        return $this;
    }
    /**
     * Add item to COMPONENT value
     * @throws \InvalidArgumentException
     * @param \StructType\COMPONENT $item
     * @return \StructType\PARTLIST
     */
    public function addToCOMPONENT(\StructType\COMPONENT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\COMPONENT) {
            throw new \InvalidArgumentException(sprintf('The COMPONENT property can only contain items of type \StructType\COMPONENT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->COMPONENT[] = $item;
        return $this;
    }
}
