<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Owner StructType
 * @subpackage Structs
 */
class Owner extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The accountHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $accountHolder;
    /**
     * Constructor method for Owner
     * @uses Owner::setGUEST_OBJID()
     * @uses Owner::setAccountHolder()
     * @param string $gUEST_OBJID
     * @param string $accountHolder
     */
    public function __construct($gUEST_OBJID = null, $accountHolder = null)
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setAccountHolder($accountHolder);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\Owner
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get accountHolder value
     * @return string
     */
    public function getAccountHolder()
    {
        return $this->accountHolder;
    }
    /**
     * Set accountHolder value
     * @param string $accountHolder
     * @return \StructType\Owner
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolder, true), gettype($accountHolder)), __LINE__);
        }
        $this->accountHolder = $accountHolder;
        return $this;
    }
}
