<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ORDERER-CONTACT StructType
 * @subpackage Structs
 */
class ORDERER_CONTACT extends AbstractStructBase
{
    /**
     * The objid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $objid;
    /**
     * The ORDERER_CONTACT_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ORDERER_CONTACT_OBJID;
    /**
     * The ORDERER_CONTACT_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ORDERER_CONTACT_CENTRALID;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * Constructor method for ORDERER-CONTACT
     * @uses ORDERER_CONTACT::setObjid()
     * @uses ORDERER_CONTACT::setORDERER_CONTACT_OBJID()
     * @uses ORDERER_CONTACT::setORDERER_CONTACT_CENTRALID()
     * @uses ORDERER_CONTACT::setAddress()
     * @uses ORDERER_CONTACT::setLastName()
     * @uses ORDERER_CONTACT::setFirstName()
     * @param string $objid
     * @param string $oRDERER_CONTACT_OBJID
     * @param string $oRDERER_CONTACT_CENTRALID
     * @param string $address
     * @param string $lastName
     * @param string $firstName
     */
    public function __construct($objid = null, $oRDERER_CONTACT_OBJID = null, $oRDERER_CONTACT_CENTRALID = null, $address = null, $lastName = null, $firstName = null)
    {
        $this
            ->setObjid($objid)
            ->setORDERER_CONTACT_OBJID($oRDERER_CONTACT_OBJID)
            ->setORDERER_CONTACT_CENTRALID($oRDERER_CONTACT_CENTRALID)
            ->setAddress($address)
            ->setLastName($lastName)
            ->setFirstName($firstName);
    }
    /**
     * Get objid value
     * @return string
     */
    public function getObjid()
    {
        return $this->objid;
    }
    /**
     * Set objid value
     * @param string $objid
     * @return \StructType\ORDERER_CONTACT
     */
    public function setObjid($objid = null)
    {
        // validation for constraint: string
        if (!is_null($objid) && !is_string($objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objid, true), gettype($objid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($objid) && !preg_match('/([0-9])*/', $objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($objid, true)), __LINE__);
        }
        $this->objid = $objid;
        return $this;
    }
    /**
     * Get ORDERER_CONTACT_OBJID value
     * @return string
     */
    public function getORDERER_CONTACT_OBJID()
    {
        return $this->{'ORDERER-CONTACT-OBJID'};
    }
    /**
     * Set ORDERER_CONTACT_OBJID value
     * @param string $oRDERER_CONTACT_OBJID
     * @return \StructType\ORDERER_CONTACT
     */
    public function setORDERER_CONTACT_OBJID($oRDERER_CONTACT_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($oRDERER_CONTACT_OBJID) && !is_string($oRDERER_CONTACT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDERER_CONTACT_OBJID, true), gettype($oRDERER_CONTACT_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($oRDERER_CONTACT_OBJID) && !preg_match('/([0-9])*/', $oRDERER_CONTACT_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($oRDERER_CONTACT_OBJID, true)), __LINE__);
        }
        $this->ORDERER_CONTACT_OBJID = $this->{'ORDERER-CONTACT-OBJID'} = $oRDERER_CONTACT_OBJID;
        return $this;
    }
    /**
     * Get ORDERER_CONTACT_CENTRALID value
     * @return string
     */
    public function getORDERER_CONTACT_CENTRALID()
    {
        return $this->{'ORDERER-CONTACT-CENTRALID'};
    }
    /**
     * Set ORDERER_CONTACT_CENTRALID value
     * @param string $oRDERER_CONTACT_CENTRALID
     * @return \StructType\ORDERER_CONTACT
     */
    public function setORDERER_CONTACT_CENTRALID($oRDERER_CONTACT_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($oRDERER_CONTACT_CENTRALID) && !is_string($oRDERER_CONTACT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oRDERER_CONTACT_CENTRALID, true), gettype($oRDERER_CONTACT_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($oRDERER_CONTACT_CENTRALID) && !preg_match('/([0-9])*/', $oRDERER_CONTACT_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($oRDERER_CONTACT_CENTRALID, true)), __LINE__);
        }
        $this->ORDERER_CONTACT_CENTRALID = $this->{'ORDERER-CONTACT-CENTRALID'} = $oRDERER_CONTACT_CENTRALID;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\ORDERER_CONTACT
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\ORDERER_CONTACT
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\ORDERER_CONTACT
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
}
