<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTIFICATION-ERROR StructType
 * @subpackage Structs
 */
class NOTIFICATION_ERROR extends AbstractStructBase
{
    /**
     * The TASK_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $TASK_OBJID;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorMsg;
    /**
     * The SysMessage
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $SysMessage;
    /**
     * Constructor method for NOTIFICATION-ERROR
     * @uses NOTIFICATION_ERROR::setTASK_OBJID()
     * @uses NOTIFICATION_ERROR::setErrorMsg()
     * @uses NOTIFICATION_ERROR::setSysMessage()
     * @param string $tASK_OBJID
     * @param string $errorMsg
     * @param string $sysMessage
     */
    public function __construct($tASK_OBJID = null, $errorMsg = null, $sysMessage = null)
    {
        $this
            ->setTASK_OBJID($tASK_OBJID)
            ->setErrorMsg($errorMsg)
            ->setSysMessage($sysMessage);
    }
    /**
     * Get TASK_OBJID value
     * @return string
     */
    public function getTASK_OBJID()
    {
        return $this->{'TASK-OBJID'};
    }
    /**
     * Set TASK_OBJID value
     * @param string $tASK_OBJID
     * @return \StructType\NOTIFICATION_ERROR
     */
    public function setTASK_OBJID($tASK_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($tASK_OBJID) && !is_string($tASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tASK_OBJID, true), gettype($tASK_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($tASK_OBJID) && !preg_match('/([0-9])*/', $tASK_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($tASK_OBJID, true)), __LINE__);
        }
        $this->TASK_OBJID = $this->{'TASK-OBJID'} = $tASK_OBJID;
        return $this;
    }
    /**
     * Get ErrorMsg value
     * @return string
     */
    public function getErrorMsg()
    {
        return $this->ErrorMsg;
    }
    /**
     * Set ErrorMsg value
     * @param string $errorMsg
     * @return \StructType\NOTIFICATION_ERROR
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->ErrorMsg = $errorMsg;
        return $this;
    }
    /**
     * Get SysMessage value
     * @return string|null
     */
    public function getSysMessage()
    {
        return $this->SysMessage;
    }
    /**
     * Set SysMessage value
     * @param string $sysMessage
     * @return \StructType\NOTIFICATION_ERROR
     */
    public function setSysMessage($sysMessage = null)
    {
        // validation for constraint: string
        if (!is_null($sysMessage) && !is_string($sysMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sysMessage, true), gettype($sysMessage)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($sysMessage) && !preg_match('/([-+]){0,1}([0-9])*/', $sysMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($sysMessage, true)), __LINE__);
        }
        $this->SysMessage = $sysMessage;
        return $this;
    }
}
