<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NOTIFICATION StructType
 * @subpackage Structs
 */
class NOTIFICATION extends AbstractStructBase
{
    /**
     * The NOTIFICATION_ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NOTIFICATION_ID;
    /**
     * The TRIGGER_OPTIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TRIGGER_OPTIONS
     */
    public $TRIGGER_OPTIONS;
    /**
     * The CONSTRAINT_OPTIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CONSTRAINT_OPTIONS
     */
    public $CONSTRAINT_OPTIONS;
    /**
     * Constructor method for NOTIFICATION
     * @uses NOTIFICATION::setNOTIFICATION_ID()
     * @uses NOTIFICATION::setTRIGGER_OPTIONS()
     * @uses NOTIFICATION::setCONSTRAINT_OPTIONS()
     * @param string $nOTIFICATION_ID
     * @param \StructType\TRIGGER_OPTIONS $tRIGGER_OPTIONS
     * @param \StructType\CONSTRAINT_OPTIONS $cONSTRAINT_OPTIONS
     */
    public function __construct($nOTIFICATION_ID = null, \StructType\TRIGGER_OPTIONS $tRIGGER_OPTIONS = null, \StructType\CONSTRAINT_OPTIONS $cONSTRAINT_OPTIONS = null)
    {
        $this
            ->setNOTIFICATION_ID($nOTIFICATION_ID)
            ->setTRIGGER_OPTIONS($tRIGGER_OPTIONS)
            ->setCONSTRAINT_OPTIONS($cONSTRAINT_OPTIONS);
    }
    /**
     * Get NOTIFICATION_ID value
     * @return string
     */
    public function getNOTIFICATION_ID()
    {
        return $this->{'NOTIFICATION-ID'};
    }
    /**
     * Set NOTIFICATION_ID value
     * @param string $nOTIFICATION_ID
     * @return \StructType\NOTIFICATION
     */
    public function setNOTIFICATION_ID($nOTIFICATION_ID = null)
    {
        // validation for constraint: string
        if (!is_null($nOTIFICATION_ID) && !is_string($nOTIFICATION_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nOTIFICATION_ID, true), gettype($nOTIFICATION_ID)), __LINE__);
        }
        $this->NOTIFICATION_ID = $this->{'NOTIFICATION-ID'} = $nOTIFICATION_ID;
        return $this;
    }
    /**
     * Get TRIGGER_OPTIONS value
     * @return \StructType\TRIGGER_OPTIONS
     */
    public function getTRIGGER_OPTIONS()
    {
        return $this->{'TRIGGER-OPTIONS'};
    }
    /**
     * Set TRIGGER_OPTIONS value
     * @param \StructType\TRIGGER_OPTIONS $tRIGGER_OPTIONS
     * @return \StructType\NOTIFICATION
     */
    public function setTRIGGER_OPTIONS(\StructType\TRIGGER_OPTIONS $tRIGGER_OPTIONS = null)
    {
        $this->TRIGGER_OPTIONS = $this->{'TRIGGER-OPTIONS'} = $tRIGGER_OPTIONS;
        return $this;
    }
    /**
     * Get CONSTRAINT_OPTIONS value
     * @return \StructType\CONSTRAINT_OPTIONS
     */
    public function getCONSTRAINT_OPTIONS()
    {
        return $this->{'CONSTRAINT-OPTIONS'};
    }
    /**
     * Set CONSTRAINT_OPTIONS value
     * @param \StructType\CONSTRAINT_OPTIONS $cONSTRAINT_OPTIONS
     * @return \StructType\NOTIFICATION
     */
    public function setCONSTRAINT_OPTIONS(\StructType\CONSTRAINT_OPTIONS $cONSTRAINT_OPTIONS = null)
    {
        $this->CONSTRAINT_OPTIONS = $this->{'CONSTRAINT-OPTIONS'} = $cONSTRAINT_OPTIONS;
        return $this;
    }
}
