<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiLangDescription StructType
 * @subpackage Structs
 */
class MultiLangDescription extends AbstractStructBase
{
    /**
     * The languagecode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $languagecode;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * Constructor method for MultiLangDescription
     * @uses MultiLangDescription::setLanguagecode()
     * @uses MultiLangDescription::setDescription()
     * @param string $languagecode
     * @param string $description
     */
    public function __construct($languagecode = null, $description = null)
    {
        $this
            ->setLanguagecode($languagecode)
            ->setDescription($description);
    }
    /**
     * Get languagecode value
     * @return string
     */
    public function getLanguagecode()
    {
        return $this->languagecode;
    }
    /**
     * Set languagecode value
     * @param string $languagecode
     * @return \StructType\MultiLangDescription
     */
    public function setLanguagecode($languagecode = null)
    {
        // validation for constraint: string
        if (!is_null($languagecode) && !is_string($languagecode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languagecode, true), gettype($languagecode)), __LINE__);
        }
        $this->languagecode = $languagecode;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MultiLangDescription
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
}
