<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MappingEntry StructType
 * @subpackage Structs
 */
class MappingEntry extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The System
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $System;
    /**
     * Constructor method for MappingEntry
     * @uses MappingEntry::setCode()
     * @uses MappingEntry::setSystem()
     * @param string $code
     * @param string $system
     */
    public function __construct($code = null, $system = null)
    {
        $this
            ->setCode($code)
            ->setSystem($system);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\MappingEntry
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get System value
     * @return string
     */
    public function getSystem()
    {
        return $this->System;
    }
    /**
     * Set System value
     * @param string $system
     * @return \StructType\MappingEntry
     */
    public function setSystem($system = null)
    {
        // validation for constraint: string
        if (!is_null($system) && !is_string($system)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system, true), gettype($system)), __LINE__);
        }
        $this->System = $system;
        return $this;
    }
}
