<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mapping StructType
 * @subpackage Structs
 */
class Mapping extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The System
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $System;
    /**
     * The Master
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $Master;
    /**
     * The MappingEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MappingEntry[]
     */
    public $MappingEntry;
    /**
     * Constructor method for Mapping
     * @uses Mapping::setCode()
     * @uses Mapping::setSystem()
     * @uses Mapping::setMaster()
     * @uses Mapping::setMappingEntry()
     * @param string $code
     * @param string $system
     * @param string $master
     * @param \StructType\MappingEntry[] $mappingEntry
     */
    public function __construct($code = null, $system = null, $master = null, array $mappingEntry = array())
    {
        $this
            ->setCode($code)
            ->setSystem($system)
            ->setMaster($master)
            ->setMappingEntry($mappingEntry);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Mapping
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get System value
     * @return string
     */
    public function getSystem()
    {
        return $this->System;
    }
    /**
     * Set System value
     * @param string $system
     * @return \StructType\Mapping
     */
    public function setSystem($system = null)
    {
        // validation for constraint: string
        if (!is_null($system) && !is_string($system)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($system, true), gettype($system)), __LINE__);
        }
        $this->System = $system;
        return $this;
    }
    /**
     * Get Master value
     * @return string
     */
    public function getMaster()
    {
        return $this->Master;
    }
    /**
     * Set Master value
     * @param string $master
     * @return \StructType\Mapping
     */
    public function setMaster($master = null)
    {
        // validation for constraint: string
        if (!is_null($master) && !is_string($master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($master) && !preg_match('/([-+]){0,1}([0-9])*/', $master)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($master, true)), __LINE__);
        }
        $this->Master = $master;
        return $this;
    }
    /**
     * Get MappingEntry value
     * @return \StructType\MappingEntry[]|null
     */
    public function getMappingEntry()
    {
        return $this->MappingEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setMappingEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMappingEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMappingEntryForArrayConstraintsFromSetMappingEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mappingMappingEntryItem) {
            // validation for constraint: itemType
            if (!$mappingMappingEntryItem instanceof \StructType\MappingEntry) {
                $invalidValues[] = is_object($mappingMappingEntryItem) ? get_class($mappingMappingEntryItem) : sprintf('%s(%s)', gettype($mappingMappingEntryItem), var_export($mappingMappingEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MappingEntry property can only contain items of type \StructType\MappingEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MappingEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\MappingEntry[] $mappingEntry
     * @return \StructType\Mapping
     */
    public function setMappingEntry(array $mappingEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($mappingEntryArrayErrorMessage = self::validateMappingEntryForArrayConstraintsFromSetMappingEntry($mappingEntry))) {
            throw new \InvalidArgumentException($mappingEntryArrayErrorMessage, __LINE__);
        }
        $this->MappingEntry = $mappingEntry;
        return $this;
    }
    /**
     * Add item to MappingEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\MappingEntry $item
     * @return \StructType\Mapping
     */
    public function addToMappingEntry(\StructType\MappingEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MappingEntry) {
            throw new \InvalidArgumentException(sprintf('The MappingEntry property can only contain items of type \StructType\MappingEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MappingEntry[] = $item;
        return $this;
    }
}
