<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaintenanceRequestSearch StructType
 * @subpackage Structs
 */
class MaintenanceRequestSearch extends AbstractStructBase
{
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $room;
    /**
     * The maintenancestatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maintenancestatus;
    /**
     * The roomtype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomtype;
    /**
     * Constructor method for MaintenanceRequestSearch
     * @uses MaintenanceRequestSearch::setRoom()
     * @uses MaintenanceRequestSearch::setMaintenancestatus()
     * @uses MaintenanceRequestSearch::setRoomtype()
     * @param string $room
     * @param string $maintenancestatus
     * @param string $roomtype
     */
    public function __construct($room = null, $maintenancestatus = null, $roomtype = null)
    {
        $this
            ->setRoom($room)
            ->setMaintenancestatus($maintenancestatus)
            ->setRoomtype($roomtype);
    }
    /**
     * Get room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\MaintenanceRequestSearch
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get maintenancestatus value
     * @return string|null
     */
    public function getMaintenancestatus()
    {
        return $this->maintenancestatus;
    }
    /**
     * Set maintenancestatus value
     * @param string $maintenancestatus
     * @return \StructType\MaintenanceRequestSearch
     */
    public function setMaintenancestatus($maintenancestatus = null)
    {
        // validation for constraint: string
        if (!is_null($maintenancestatus) && !is_string($maintenancestatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenancestatus, true), gettype($maintenancestatus)), __LINE__);
        }
        $this->maintenancestatus = $maintenancestatus;
        return $this;
    }
    /**
     * Get roomtype value
     * @return string|null
     */
    public function getRoomtype()
    {
        return $this->roomtype;
    }
    /**
     * Set roomtype value
     * @param string $roomtype
     * @return \StructType\MaintenanceRequestSearch
     */
    public function setRoomtype($roomtype = null)
    {
        // validation for constraint: string
        if (!is_null($roomtype) && !is_string($roomtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomtype, true), gettype($roomtype)), __LINE__);
        }
        $this->roomtype = $roomtype;
        return $this;
    }
}
