<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaintenanceRequest StructType
 * @subpackage Structs
 */
class MaintenanceRequest extends AbstractStructBase
{
    /**
     * The ROOMMAINTENANCESTATUS_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $ROOMMAINTENANCESTATUS_OBJID;
    /**
     * The maintenancestatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $maintenancestatus;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $time;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $priority;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $comment;
    /**
     * The hasimages
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hasimages;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room[]
     */
    public $Room;
    /**
     * The ImageManager
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ImageManager[]
     */
    public $ImageManager;
    /**
     * Constructor method for MaintenanceRequest
     * @uses MaintenanceRequest::setROOMMAINTENANCESTATUS_OBJID()
     * @uses MaintenanceRequest::setMaintenancestatus()
     * @uses MaintenanceRequest::setDate()
     * @uses MaintenanceRequest::setTime()
     * @uses MaintenanceRequest::setPriority()
     * @uses MaintenanceRequest::setComment()
     * @uses MaintenanceRequest::setHasimages()
     * @uses MaintenanceRequest::setRoom()
     * @uses MaintenanceRequest::setImageManager()
     * @param string $rOOMMAINTENANCESTATUS_OBJID
     * @param string $maintenancestatus
     * @param string $date
     * @param string $time
     * @param string $priority
     * @param string $comment
     * @param string $hasimages
     * @param \StructType\Room[] $room
     * @param \StructType\ImageManager[] $imageManager
     */
    public function __construct($rOOMMAINTENANCESTATUS_OBJID = null, $maintenancestatus = null, $date = null, $time = null, $priority = null, $comment = null, $hasimages = null, array $room = array(), array $imageManager = array())
    {
        $this
            ->setROOMMAINTENANCESTATUS_OBJID($rOOMMAINTENANCESTATUS_OBJID)
            ->setMaintenancestatus($maintenancestatus)
            ->setDate($date)
            ->setTime($time)
            ->setPriority($priority)
            ->setComment($comment)
            ->setHasimages($hasimages)
            ->setRoom($room)
            ->setImageManager($imageManager);
    }
    /**
     * Get ROOMMAINTENANCESTATUS_OBJID value
     * @return string
     */
    public function getROOMMAINTENANCESTATUS_OBJID()
    {
        return $this->{'ROOMMAINTENANCESTATUS-OBJID'};
    }
    /**
     * Set ROOMMAINTENANCESTATUS_OBJID value
     * @param string $rOOMMAINTENANCESTATUS_OBJID
     * @return \StructType\MaintenanceRequest
     */
    public function setROOMMAINTENANCESTATUS_OBJID($rOOMMAINTENANCESTATUS_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($rOOMMAINTENANCESTATUS_OBJID) && !is_string($rOOMMAINTENANCESTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOOMMAINTENANCESTATUS_OBJID, true), gettype($rOOMMAINTENANCESTATUS_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($rOOMMAINTENANCESTATUS_OBJID) && !preg_match('/([0-9])*/', $rOOMMAINTENANCESTATUS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($rOOMMAINTENANCESTATUS_OBJID, true)), __LINE__);
        }
        $this->ROOMMAINTENANCESTATUS_OBJID = $this->{'ROOMMAINTENANCESTATUS-OBJID'} = $rOOMMAINTENANCESTATUS_OBJID;
        return $this;
    }
    /**
     * Get maintenancestatus value
     * @return string
     */
    public function getMaintenancestatus()
    {
        return $this->maintenancestatus;
    }
    /**
     * Set maintenancestatus value
     * @param string $maintenancestatus
     * @return \StructType\MaintenanceRequest
     */
    public function setMaintenancestatus($maintenancestatus = null)
    {
        // validation for constraint: string
        if (!is_null($maintenancestatus) && !is_string($maintenancestatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maintenancestatus, true), gettype($maintenancestatus)), __LINE__);
        }
        $this->maintenancestatus = $maintenancestatus;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\MaintenanceRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get time value
     * @return string
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\MaintenanceRequest
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($time) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($time, true)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @param string $priority
     * @return \StructType\MaintenanceRequest
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($priority) && !preg_match('/([-+]){0,1}([0-9])*/', $priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($priority, true)), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get comment value
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\MaintenanceRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get hasimages value
     * @return string
     */
    public function getHasimages()
    {
        return $this->hasimages;
    }
    /**
     * Set hasimages value
     * @param string $hasimages
     * @return \StructType\MaintenanceRequest
     */
    public function setHasimages($hasimages = null)
    {
        // validation for constraint: string
        if (!is_null($hasimages) && !is_string($hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hasimages, true), gettype($hasimages)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hasimages) && !preg_match('/([-+]){0,1}([0-9])*/', $hasimages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hasimages, true)), __LINE__);
        }
        $this->hasimages = $hasimages;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maintenanceRequestRoomItem) {
            // validation for constraint: itemType
            if (!$maintenanceRequestRoomItem instanceof \StructType\Room) {
                $invalidValues[] = is_object($maintenanceRequestRoomItem) ? get_class($maintenanceRequestRoomItem) : sprintf('%s(%s)', gettype($maintenanceRequestRoomItem), var_export($maintenanceRequestRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room[] $room
     * @return \StructType\MaintenanceRequest
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room $item
     * @return \StructType\MaintenanceRequest
     */
    public function addToRoom(\StructType\Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get ImageManager value
     * @return \StructType\ImageManager[]|null
     */
    public function getImageManager()
    {
        return $this->ImageManager;
    }
    /**
     * This method is responsible for validating the values passed to the setImageManager method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageManager method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageManagerForArrayConstraintsFromSetImageManager(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $maintenanceRequestImageManagerItem) {
            // validation for constraint: itemType
            if (!$maintenanceRequestImageManagerItem instanceof \StructType\ImageManager) {
                $invalidValues[] = is_object($maintenanceRequestImageManagerItem) ? get_class($maintenanceRequestImageManagerItem) : sprintf('%s(%s)', gettype($maintenanceRequestImageManagerItem), var_export($maintenanceRequestImageManagerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageManager property can only contain items of type \StructType\ImageManager, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageManager value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageManager[] $imageManager
     * @return \StructType\MaintenanceRequest
     */
    public function setImageManager(array $imageManager = array())
    {
        // validation for constraint: array
        if ('' !== ($imageManagerArrayErrorMessage = self::validateImageManagerForArrayConstraintsFromSetImageManager($imageManager))) {
            throw new \InvalidArgumentException($imageManagerArrayErrorMessage, __LINE__);
        }
        $this->ImageManager = $imageManager;
        return $this;
    }
    /**
     * Add item to ImageManager value
     * @throws \InvalidArgumentException
     * @param \StructType\ImageManager $item
     * @return \StructType\MaintenanceRequest
     */
    public function addToImageManager(\StructType\ImageManager $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ImageManager) {
            throw new \InvalidArgumentException(sprintf('The ImageManager property can only contain items of type \StructType\ImageManager, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageManager[] = $item;
        return $this;
    }
}
