<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MOTHER-COMPANY StructType
 * @subpackage Structs
 */
class MOTHER_COMPANY extends AbstractStructBase
{
    /**
     * The MOTHER_COMPANY_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $MOTHER_COMPANY_OBJID;
    /**
     * The MOTHER_COMPANY_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $MOTHER_COMPANY_CENTRALID;
    /**
     * Constructor method for MOTHER-COMPANY
     * @uses MOTHER_COMPANY::setMOTHER_COMPANY_OBJID()
     * @uses MOTHER_COMPANY::setMOTHER_COMPANY_CENTRALID()
     * @param string $mOTHER_COMPANY_OBJID
     * @param string $mOTHER_COMPANY_CENTRALID
     */
    public function __construct($mOTHER_COMPANY_OBJID = null, $mOTHER_COMPANY_CENTRALID = null)
    {
        $this
            ->setMOTHER_COMPANY_OBJID($mOTHER_COMPANY_OBJID)
            ->setMOTHER_COMPANY_CENTRALID($mOTHER_COMPANY_CENTRALID);
    }
    /**
     * Get MOTHER_COMPANY_OBJID value
     * @return string
     */
    public function getMOTHER_COMPANY_OBJID()
    {
        return $this->{'MOTHER-COMPANY-OBJID'};
    }
    /**
     * Set MOTHER_COMPANY_OBJID value
     * @param string $mOTHER_COMPANY_OBJID
     * @return \StructType\MOTHER_COMPANY
     */
    public function setMOTHER_COMPANY_OBJID($mOTHER_COMPANY_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($mOTHER_COMPANY_OBJID) && !is_string($mOTHER_COMPANY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOTHER_COMPANY_OBJID, true), gettype($mOTHER_COMPANY_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($mOTHER_COMPANY_OBJID) && !preg_match('/([0-9])*/', $mOTHER_COMPANY_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($mOTHER_COMPANY_OBJID, true)), __LINE__);
        }
        $this->MOTHER_COMPANY_OBJID = $this->{'MOTHER-COMPANY-OBJID'} = $mOTHER_COMPANY_OBJID;
        return $this;
    }
    /**
     * Get MOTHER_COMPANY_CENTRALID value
     * @return string
     */
    public function getMOTHER_COMPANY_CENTRALID()
    {
        return $this->{'MOTHER-COMPANY-CENTRALID'};
    }
    /**
     * Set MOTHER_COMPANY_CENTRALID value
     * @param string $mOTHER_COMPANY_CENTRALID
     * @return \StructType\MOTHER_COMPANY
     */
    public function setMOTHER_COMPANY_CENTRALID($mOTHER_COMPANY_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($mOTHER_COMPANY_CENTRALID) && !is_string($mOTHER_COMPANY_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOTHER_COMPANY_CENTRALID, true), gettype($mOTHER_COMPANY_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($mOTHER_COMPANY_CENTRALID) && !preg_match('/([0-9])*/', $mOTHER_COMPANY_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($mOTHER_COMPANY_CENTRALID, true)), __LINE__);
        }
        $this->MOTHER_COMPANY_CENTRALID = $this->{'MOTHER-COMPANY-CENTRALID'} = $mOTHER_COMPANY_CENTRALID;
        return $this;
    }
}
