<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Logo StructType
 * @subpackage Structs
 */
class Logo extends AbstractStructBase
{
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $image;
    /**
     * Constructor method for Logo
     * @uses Logo::setImage()
     * @param string $image
     */
    public function __construct($image = null)
    {
        $this
            ->setImage($image);
    }
    /**
     * Get image value
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \StructType\Logo
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
}
