<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leaf StructType
 * @subpackage Structs
 */
class Leaf extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The classname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $classname;
    /**
     * The entry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $entry;
    /**
     * The valuemultiline
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valuemultiline;
    /**
     * The valueasstring
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueasstring;
    /**
     * The valueasinteger
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $valueasinteger;
    /**
     * The valueasdouble
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $valueasdouble;
    /**
     * The valueaslistbox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueaslistbox;
    /**
     * The valuemultiselect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valuemultiselect;
    /**
     * The valueascolor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueascolor;
    /**
     * The valueasflag
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $valueasflag;
    /**
     * The valueasdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $valueasdate;
    /**
     * The valueastime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $valueastime;
    /**
     * The valueaspassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueaspassword;
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $image;
    /**
     * The valueascolorpicker
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueascolorpicker;
    /**
     * The valueascolorcombobox
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $valueascolorcombobox;
    /**
     * Constructor method for Leaf
     * @uses Leaf::setType()
     * @uses Leaf::setClassname()
     * @uses Leaf::setEntry()
     * @uses Leaf::setValuemultiline()
     * @uses Leaf::setValueasstring()
     * @uses Leaf::setValueasinteger()
     * @uses Leaf::setValueasdouble()
     * @uses Leaf::setValueaslistbox()
     * @uses Leaf::setValuemultiselect()
     * @uses Leaf::setValueascolor()
     * @uses Leaf::setValueasflag()
     * @uses Leaf::setValueasdate()
     * @uses Leaf::setValueastime()
     * @uses Leaf::setValueaspassword()
     * @uses Leaf::setImage()
     * @uses Leaf::setValueascolorpicker()
     * @uses Leaf::setValueascolorcombobox()
     * @param string $type
     * @param string $classname
     * @param string $entry
     * @param string $valuemultiline
     * @param string $valueasstring
     * @param string $valueasinteger
     * @param string $valueasdouble
     * @param string $valueaslistbox
     * @param string $valuemultiselect
     * @param string $valueascolor
     * @param string $valueasflag
     * @param string $valueasdate
     * @param string $valueastime
     * @param string $valueaspassword
     * @param string $image
     * @param string $valueascolorpicker
     * @param string $valueascolorcombobox
     */
    public function __construct($type = null, $classname = null, $entry = null, $valuemultiline = null, $valueasstring = null, $valueasinteger = null, $valueasdouble = null, $valueaslistbox = null, $valuemultiselect = null, $valueascolor = null, $valueasflag = null, $valueasdate = null, $valueastime = null, $valueaspassword = null, $image = null, $valueascolorpicker = null, $valueascolorcombobox = null)
    {
        $this
            ->setType($type)
            ->setClassname($classname)
            ->setEntry($entry)
            ->setValuemultiline($valuemultiline)
            ->setValueasstring($valueasstring)
            ->setValueasinteger($valueasinteger)
            ->setValueasdouble($valueasdouble)
            ->setValueaslistbox($valueaslistbox)
            ->setValuemultiselect($valuemultiselect)
            ->setValueascolor($valueascolor)
            ->setValueasflag($valueasflag)
            ->setValueasdate($valueasdate)
            ->setValueastime($valueastime)
            ->setValueaspassword($valueaspassword)
            ->setImage($image)
            ->setValueascolorpicker($valueascolorpicker)
            ->setValueascolorcombobox($valueascolorcombobox);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Leaf
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get classname value
     * @return string
     */
    public function getClassname()
    {
        return $this->classname;
    }
    /**
     * Set classname value
     * @param string $classname
     * @return \StructType\Leaf
     */
    public function setClassname($classname = null)
    {
        // validation for constraint: string
        if (!is_null($classname) && !is_string($classname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classname, true), gettype($classname)), __LINE__);
        }
        $this->classname = $classname;
        return $this;
    }
    /**
     * Get entry value
     * @return string
     */
    public function getEntry()
    {
        return $this->entry;
    }
    /**
     * Set entry value
     * @param string $entry
     * @return \StructType\Leaf
     */
    public function setEntry($entry = null)
    {
        // validation for constraint: string
        if (!is_null($entry) && !is_string($entry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entry, true), gettype($entry)), __LINE__);
        }
        $this->entry = $entry;
        return $this;
    }
    /**
     * Get valuemultiline value
     * @return string
     */
    public function getValuemultiline()
    {
        return $this->valuemultiline;
    }
    /**
     * Set valuemultiline value
     * @param string $valuemultiline
     * @return \StructType\Leaf
     */
    public function setValuemultiline($valuemultiline = null)
    {
        // validation for constraint: string
        if (!is_null($valuemultiline) && !is_string($valuemultiline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valuemultiline, true), gettype($valuemultiline)), __LINE__);
        }
        $this->valuemultiline = $valuemultiline;
        return $this;
    }
    /**
     * Get valueasstring value
     * @return string
     */
    public function getValueasstring()
    {
        return $this->valueasstring;
    }
    /**
     * Set valueasstring value
     * @param string $valueasstring
     * @return \StructType\Leaf
     */
    public function setValueasstring($valueasstring = null)
    {
        // validation for constraint: string
        if (!is_null($valueasstring) && !is_string($valueasstring)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueasstring, true), gettype($valueasstring)), __LINE__);
        }
        $this->valueasstring = $valueasstring;
        return $this;
    }
    /**
     * Get valueasinteger value
     * @return string
     */
    public function getValueasinteger()
    {
        return $this->valueasinteger;
    }
    /**
     * Set valueasinteger value
     * @param string $valueasinteger
     * @return \StructType\Leaf
     */
    public function setValueasinteger($valueasinteger = null)
    {
        // validation for constraint: string
        if (!is_null($valueasinteger) && !is_string($valueasinteger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueasinteger, true), gettype($valueasinteger)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($valueasinteger) && !preg_match('/([-+]){0,1}([0-9])*/', $valueasinteger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($valueasinteger, true)), __LINE__);
        }
        $this->valueasinteger = $valueasinteger;
        return $this;
    }
    /**
     * Get valueasdouble value
     * @return string
     */
    public function getValueasdouble()
    {
        return $this->valueasdouble;
    }
    /**
     * Set valueasdouble value
     * @param string $valueasdouble
     * @return \StructType\Leaf
     */
    public function setValueasdouble($valueasdouble = null)
    {
        // validation for constraint: string
        if (!is_null($valueasdouble) && !is_string($valueasdouble)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueasdouble, true), gettype($valueasdouble)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($valueasdouble) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $valueasdouble)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($valueasdouble, true)), __LINE__);
        }
        $this->valueasdouble = $valueasdouble;
        return $this;
    }
    /**
     * Get valueaslistbox value
     * @return string
     */
    public function getValueaslistbox()
    {
        return $this->valueaslistbox;
    }
    /**
     * Set valueaslistbox value
     * @param string $valueaslistbox
     * @return \StructType\Leaf
     */
    public function setValueaslistbox($valueaslistbox = null)
    {
        // validation for constraint: string
        if (!is_null($valueaslistbox) && !is_string($valueaslistbox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueaslistbox, true), gettype($valueaslistbox)), __LINE__);
        }
        $this->valueaslistbox = $valueaslistbox;
        return $this;
    }
    /**
     * Get valuemultiselect value
     * @return string
     */
    public function getValuemultiselect()
    {
        return $this->valuemultiselect;
    }
    /**
     * Set valuemultiselect value
     * @param string $valuemultiselect
     * @return \StructType\Leaf
     */
    public function setValuemultiselect($valuemultiselect = null)
    {
        // validation for constraint: string
        if (!is_null($valuemultiselect) && !is_string($valuemultiselect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valuemultiselect, true), gettype($valuemultiselect)), __LINE__);
        }
        $this->valuemultiselect = $valuemultiselect;
        return $this;
    }
    /**
     * Get valueascolor value
     * @return string
     */
    public function getValueascolor()
    {
        return $this->valueascolor;
    }
    /**
     * Set valueascolor value
     * @param string $valueascolor
     * @return \StructType\Leaf
     */
    public function setValueascolor($valueascolor = null)
    {
        // validation for constraint: string
        if (!is_null($valueascolor) && !is_string($valueascolor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueascolor, true), gettype($valueascolor)), __LINE__);
        }
        $this->valueascolor = $valueascolor;
        return $this;
    }
    /**
     * Get valueasflag value
     * @return string
     */
    public function getValueasflag()
    {
        return $this->valueasflag;
    }
    /**
     * Set valueasflag value
     * @param string $valueasflag
     * @return \StructType\Leaf
     */
    public function setValueasflag($valueasflag = null)
    {
        // validation for constraint: string
        if (!is_null($valueasflag) && !is_string($valueasflag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueasflag, true), gettype($valueasflag)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($valueasflag) && !preg_match('/([-+]){0,1}([0-9])*/', $valueasflag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($valueasflag, true)), __LINE__);
        }
        $this->valueasflag = $valueasflag;
        return $this;
    }
    /**
     * Get valueasdate value
     * @return string
     */
    public function getValueasdate()
    {
        return $this->valueasdate;
    }
    /**
     * Set valueasdate value
     * @param string $valueasdate
     * @return \StructType\Leaf
     */
    public function setValueasdate($valueasdate = null)
    {
        // validation for constraint: string
        if (!is_null($valueasdate) && !is_string($valueasdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueasdate, true), gettype($valueasdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($valueasdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $valueasdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($valueasdate, true)), __LINE__);
        }
        $this->valueasdate = $valueasdate;
        return $this;
    }
    /**
     * Get valueastime value
     * @return string
     */
    public function getValueastime()
    {
        return $this->valueastime;
    }
    /**
     * Set valueastime value
     * @param string $valueastime
     * @return \StructType\Leaf
     */
    public function setValueastime($valueastime = null)
    {
        // validation for constraint: string
        if (!is_null($valueastime) && !is_string($valueastime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueastime, true), gettype($valueastime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($valueastime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $valueastime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($valueastime, true)), __LINE__);
        }
        $this->valueastime = $valueastime;
        return $this;
    }
    /**
     * Get valueaspassword value
     * @return string
     */
    public function getValueaspassword()
    {
        return $this->valueaspassword;
    }
    /**
     * Set valueaspassword value
     * @param string $valueaspassword
     * @return \StructType\Leaf
     */
    public function setValueaspassword($valueaspassword = null)
    {
        // validation for constraint: string
        if (!is_null($valueaspassword) && !is_string($valueaspassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueaspassword, true), gettype($valueaspassword)), __LINE__);
        }
        $this->valueaspassword = $valueaspassword;
        return $this;
    }
    /**
     * Get image value
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set image value
     * @param string $image
     * @return \StructType\Leaf
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get valueascolorpicker value
     * @return string
     */
    public function getValueascolorpicker()
    {
        return $this->valueascolorpicker;
    }
    /**
     * Set valueascolorpicker value
     * @param string $valueascolorpicker
     * @return \StructType\Leaf
     */
    public function setValueascolorpicker($valueascolorpicker = null)
    {
        // validation for constraint: string
        if (!is_null($valueascolorpicker) && !is_string($valueascolorpicker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueascolorpicker, true), gettype($valueascolorpicker)), __LINE__);
        }
        $this->valueascolorpicker = $valueascolorpicker;
        return $this;
    }
    /**
     * Get valueascolorcombobox value
     * @return string
     */
    public function getValueascolorcombobox()
    {
        return $this->valueascolorcombobox;
    }
    /**
     * Set valueascolorcombobox value
     * @param string $valueascolorcombobox
     * @return \StructType\Leaf
     */
    public function setValueascolorcombobox($valueascolorcombobox = null)
    {
        // validation for constraint: string
        if (!is_null($valueascolorcombobox) && !is_string($valueascolorcombobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueascolorcombobox, true), gettype($valueascolorcombobox)), __LINE__);
        }
        $this->valueascolorcombobox = $valueascolorcombobox;
        return $this;
    }
}
