<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LOYALTY StructType
 * @subpackage Structs
 */
class LOYALTY extends AbstractStructBase
{
    /**
     * The loyaltydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $loyaltydate;
    /**
     * The loyaltyflag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $loyaltyflag;
    /**
     * The LOYALTY_CARDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LOYALTY_CARDS
     */
    public $LOYALTY_CARDS;
    /**
     * Constructor method for LOYALTY
     * @uses LOYALTY::setLoyaltydate()
     * @uses LOYALTY::setLoyaltyflag()
     * @uses LOYALTY::setLOYALTY_CARDS()
     * @param string $loyaltydate
     * @param string $loyaltyflag
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     */
    public function __construct($loyaltydate = null, $loyaltyflag = null, \StructType\LOYALTY_CARDS $lOYALTY_CARDS = null)
    {
        $this
            ->setLoyaltydate($loyaltydate)
            ->setLoyaltyflag($loyaltyflag)
            ->setLOYALTY_CARDS($lOYALTY_CARDS);
    }
    /**
     * Get loyaltydate value
     * @return string
     */
    public function getLoyaltydate()
    {
        return $this->loyaltydate;
    }
    /**
     * Set loyaltydate value
     * @param string $loyaltydate
     * @return \StructType\LOYALTY
     */
    public function setLoyaltydate($loyaltydate = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltydate) && !is_string($loyaltydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltydate, true), gettype($loyaltydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($loyaltydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $loyaltydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($loyaltydate, true)), __LINE__);
        }
        $this->loyaltydate = $loyaltydate;
        return $this;
    }
    /**
     * Get loyaltyflag value
     * @return string
     */
    public function getLoyaltyflag()
    {
        return $this->loyaltyflag;
    }
    /**
     * Set loyaltyflag value
     * @param string $loyaltyflag
     * @return \StructType\LOYALTY
     */
    public function setLoyaltyflag($loyaltyflag = null)
    {
        // validation for constraint: string
        if (!is_null($loyaltyflag) && !is_string($loyaltyflag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loyaltyflag, true), gettype($loyaltyflag)), __LINE__);
        }
        $this->loyaltyflag = $loyaltyflag;
        return $this;
    }
    /**
     * Get LOYALTY_CARDS value
     * @return \StructType\LOYALTY_CARDS
     */
    public function getLOYALTY_CARDS()
    {
        return $this->{'LOYALTY-CARDS'};
    }
    /**
     * Set LOYALTY_CARDS value
     * @param \StructType\LOYALTY_CARDS $lOYALTY_CARDS
     * @return \StructType\LOYALTY
     */
    public function setLOYALTY_CARDS(\StructType\LOYALTY_CARDS $lOYALTY_CARDS = null)
    {
        $this->LOYALTY_CARDS = $this->{'LOYALTY-CARDS'} = $lOYALTY_CARDS;
        return $this;
    }
}
