<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoicedPayments StructType
 * @subpackage Structs
 */
class InvoicedPayments extends AbstractStructBase
{
    /**
     * The InvoicedPayment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InvoicedPayment[]
     */
    public $InvoicedPayment;
    /**
     * Constructor method for InvoicedPayments
     * @uses InvoicedPayments::setInvoicedPayment()
     * @param \StructType\InvoicedPayment[] $invoicedPayment
     */
    public function __construct(array $invoicedPayment = array())
    {
        $this
            ->setInvoicedPayment($invoicedPayment);
    }
    /**
     * Get InvoicedPayment value
     * @return \StructType\InvoicedPayment[]|null
     */
    public function getInvoicedPayment()
    {
        return $this->InvoicedPayment;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoicedPayment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoicedPayment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoicedPaymentForArrayConstraintsFromSetInvoicedPayment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoicedPaymentsInvoicedPaymentItem) {
            // validation for constraint: itemType
            if (!$invoicedPaymentsInvoicedPaymentItem instanceof \StructType\InvoicedPayment) {
                $invalidValues[] = is_object($invoicedPaymentsInvoicedPaymentItem) ? get_class($invoicedPaymentsInvoicedPaymentItem) : sprintf('%s(%s)', gettype($invoicedPaymentsInvoicedPaymentItem), var_export($invoicedPaymentsInvoicedPaymentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InvoicedPayment property can only contain items of type \StructType\InvoicedPayment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InvoicedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPayment[] $invoicedPayment
     * @return \StructType\InvoicedPayments
     */
    public function setInvoicedPayment(array $invoicedPayment = array())
    {
        // validation for constraint: array
        if ('' !== ($invoicedPaymentArrayErrorMessage = self::validateInvoicedPaymentForArrayConstraintsFromSetInvoicedPayment($invoicedPayment))) {
            throw new \InvalidArgumentException($invoicedPaymentArrayErrorMessage, __LINE__);
        }
        $this->InvoicedPayment = $invoicedPayment;
        return $this;
    }
    /**
     * Add item to InvoicedPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoicedPayment $item
     * @return \StructType\InvoicedPayments
     */
    public function addToInvoicedPayment(\StructType\InvoicedPayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoicedPayment) {
            throw new \InvalidArgumentException(sprintf('The InvoicedPayment property can only contain items of type \StructType\InvoicedPayment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InvoicedPayment[] = $item;
        return $this;
    }
}
