<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceHolder StructType
 * @subpackage Structs
 */
class InvoiceHolder extends AbstractStructBase
{
    /**
     * The INVOICEHOLDER_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICEHOLDER_OBJID;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastnamefirstname;
    /**
     * Constructor method for InvoiceHolder
     * @uses InvoiceHolder::setINVOICEHOLDER_OBJID()
     * @uses InvoiceHolder::setLastnamefirstname()
     * @param string $iNVOICEHOLDER_OBJID
     * @param string $lastnamefirstname
     */
    public function __construct($iNVOICEHOLDER_OBJID = null, $lastnamefirstname = null)
    {
        $this
            ->setINVOICEHOLDER_OBJID($iNVOICEHOLDER_OBJID)
            ->setLastnamefirstname($lastnamefirstname);
    }
    /**
     * Get INVOICEHOLDER_OBJID value
     * @return string
     */
    public function getINVOICEHOLDER_OBJID()
    {
        return $this->{'INVOICEHOLDER-OBJID'};
    }
    /**
     * Set INVOICEHOLDER_OBJID value
     * @param string $iNVOICEHOLDER_OBJID
     * @return \StructType\InvoiceHolder
     */
    public function setINVOICEHOLDER_OBJID($iNVOICEHOLDER_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICEHOLDER_OBJID) && !is_string($iNVOICEHOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICEHOLDER_OBJID, true), gettype($iNVOICEHOLDER_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICEHOLDER_OBJID) && !preg_match('/([0-9])*/', $iNVOICEHOLDER_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICEHOLDER_OBJID, true)), __LINE__);
        }
        $this->INVOICEHOLDER_OBJID = $this->{'INVOICEHOLDER-OBJID'} = $iNVOICEHOLDER_OBJID;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\InvoiceHolder
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
}
