<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Images StructType
 * @subpackage Structs
 */
class Images extends AbstractStructBase
{
    /**
     * The image
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $image;
    /**
     * The filename
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $filename;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The IMAGE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $IMAGE_OBJID;
    /**
     * The filesize
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $filesize;
    /**
     * The Logo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Logo[]
     */
    public $Logo;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Image[]
     */
    public $Image;
    /**
     * Constructor method for Images
     * @uses Images::setImage()
     * @uses Images::setFilename()
     * @uses Images::setDescription()
     * @uses Images::setIMAGE_OBJID()
     * @uses Images::setFilesize()
     * @uses Images::setLogo()
     * @uses Images::setImage_1()
     * @param string $image
     * @param string $filename
     * @param string $description
     * @param string $iMAGE_OBJID
     * @param string $filesize
     * @param \StructType\Logo[] $logo
     * @param \StructType\Image[] $image
     */
    public function __construct($image = null, $filename = null, $description = null, $iMAGE_OBJID = null, $filesize = null, array $logo = array(), array $image_1 = array())
    {
        $this
            ->setImage($image)
            ->setFilename($filename)
            ->setDescription($description)
            ->setIMAGE_OBJID($iMAGE_OBJID)
            ->setFilesize($filesize)
            ->setLogo($logo)
            ->setImage_1($image_1);
    }
    /**
     * Get Image value
     * @return \StructType\Image[]|null
     */
    public function getImage()
    {
        return $this->image;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param \StructType\Image[] $image
     * @return \StructType\Images
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->image = $image;
        return $this;
    }
    /**
     * Get filename value
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\Images
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Images
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get IMAGE_OBJID value
     * @return string
     */
    public function getIMAGE_OBJID()
    {
        return $this->{'IMAGE-OBJID'};
    }
    /**
     * Set IMAGE_OBJID value
     * @param string $iMAGE_OBJID
     * @return \StructType\Images
     */
    public function setIMAGE_OBJID($iMAGE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iMAGE_OBJID) && !is_string($iMAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iMAGE_OBJID, true), gettype($iMAGE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iMAGE_OBJID) && !preg_match('/([0-9])*/', $iMAGE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iMAGE_OBJID, true)), __LINE__);
        }
        $this->IMAGE_OBJID = $this->{'IMAGE-OBJID'} = $iMAGE_OBJID;
        return $this;
    }
    /**
     * Get filesize value
     * @return string
     */
    public function getFilesize()
    {
        return $this->filesize;
    }
    /**
     * Set filesize value
     * @param string $filesize
     * @return \StructType\Images
     */
    public function setFilesize($filesize = null)
    {
        // validation for constraint: string
        if (!is_null($filesize) && !is_string($filesize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filesize, true), gettype($filesize)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($filesize) && !preg_match('/([-+]){0,1}([0-9])*/', $filesize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($filesize, true)), __LINE__);
        }
        $this->filesize = $filesize;
        return $this;
    }
    /**
     * Get Logo value
     * @return \StructType\Logo[]|null
     */
    public function getLogo()
    {
        return $this->Logo;
    }
    /**
     * This method is responsible for validating the values passed to the setLogo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLogo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLogoForArrayConstraintsFromSetLogo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imagesLogoItem) {
            // validation for constraint: itemType
            if (!$imagesLogoItem instanceof \StructType\Logo) {
                $invalidValues[] = is_object($imagesLogoItem) ? get_class($imagesLogoItem) : sprintf('%s(%s)', gettype($imagesLogoItem), var_export($imagesLogoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Logo property can only contain items of type \StructType\Logo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Logo value
     * @throws \InvalidArgumentException
     * @param \StructType\Logo[] $logo
     * @return \StructType\Images
     */
    public function setLogo(array $logo = array())
    {
        // validation for constraint: array
        if ('' !== ($logoArrayErrorMessage = self::validateLogoForArrayConstraintsFromSetLogo($logo))) {
            throw new \InvalidArgumentException($logoArrayErrorMessage, __LINE__);
        }
        $this->Logo = $logo;
        return $this;
    }
    /**
     * Add item to Logo value
     * @throws \InvalidArgumentException
     * @param \StructType\Logo $item
     * @return \StructType\Images
     */
    public function addToLogo(\StructType\Logo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Logo) {
            throw new \InvalidArgumentException(sprintf('The Logo property can only contain items of type \StructType\Logo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Logo[] = $item;
        return $this;
    }
    /**
     * Get Image value
     * @return \StructType\Image[]|null
     */
    public function getImage_1()
    {
        return $this->Image;
    }
    /**
     * This method is responsible for validating the values passed to the setImage_1 method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImage_1 method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImage_1ForArrayConstraintsFromSetImage_1(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $imagesImageItem) {
            // validation for constraint: itemType
            if (!$imagesImageItem instanceof \StructType\Image) {
                $invalidValues[] = is_object($imagesImageItem) ? get_class($imagesImageItem) : sprintf('%s(%s)', gettype($imagesImageItem), var_export($imagesImageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Image property can only contain items of type \StructType\Image, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Image value
     * @throws \InvalidArgumentException
     * @param \StructType\Image[] $image
     * @return \StructType\Images
     */
    public function setImage_1(array $image_1 = array())
    {
        // validation for constraint: array
        if ('' !== ($image_1ArrayErrorMessage = self::validateImage_1ForArrayConstraintsFromSetImage_1($image_1))) {
            throw new \InvalidArgumentException($image_1ArrayErrorMessage, __LINE__);
        }
        $this->Image = $image_1;
        return $this;
    }
    /**
     * Add item to Image value
     * @throws \InvalidArgumentException
     * @param \StructType\Image $item
     * @return \StructType\Images
     */
    public function addToImage(\StructType\Image $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Image) {
            throw new \InvalidArgumentException(sprintf('The Image property can only contain items of type \StructType\Image, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Image[] = $item;
        return $this;
    }
}
