<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE-ADDRESS StructType
 * @subpackage Structs
 */
class INVOICE_ADDRESS extends AbstractStructBase
{
    /**
     * The INVOICE_ADDRESS_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_ADDRESS_OBJID;
    /**
     * The INVOICE_ADDRESS_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_ADDRESS_CENTRALID;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The INVOICE_ADDRESS_CONTACTPERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $INVOICE_ADDRESS_CONTACTPERSON_OBJID;
    /**
     * Constructor method for INVOICE-ADDRESS
     * @uses INVOICE_ADDRESS::setINVOICE_ADDRESS_OBJID()
     * @uses INVOICE_ADDRESS::setINVOICE_ADDRESS_CENTRALID()
     * @uses INVOICE_ADDRESS::setName1()
     * @uses INVOICE_ADDRESS::setName2()
     * @uses INVOICE_ADDRESS::setINVOICE_ADDRESS_CONTACTPERSON_OBJID()
     * @param string $iNVOICE_ADDRESS_OBJID
     * @param string $iNVOICE_ADDRESS_CENTRALID
     * @param string $name1
     * @param string $name2
     * @param string $iNVOICE_ADDRESS_CONTACTPERSON_OBJID
     */
    public function __construct($iNVOICE_ADDRESS_OBJID = null, $iNVOICE_ADDRESS_CENTRALID = null, $name1 = null, $name2 = null, $iNVOICE_ADDRESS_CONTACTPERSON_OBJID = null)
    {
        $this
            ->setINVOICE_ADDRESS_OBJID($iNVOICE_ADDRESS_OBJID)
            ->setINVOICE_ADDRESS_CENTRALID($iNVOICE_ADDRESS_CENTRALID)
            ->setName1($name1)
            ->setName2($name2)
            ->setINVOICE_ADDRESS_CONTACTPERSON_OBJID($iNVOICE_ADDRESS_CONTACTPERSON_OBJID);
    }
    /**
     * Get INVOICE_ADDRESS_OBJID value
     * @return string
     */
    public function getINVOICE_ADDRESS_OBJID()
    {
        return $this->{'INVOICE-ADDRESS-OBJID'};
    }
    /**
     * Set INVOICE_ADDRESS_OBJID value
     * @param string $iNVOICE_ADDRESS_OBJID
     * @return \StructType\INVOICE_ADDRESS
     */
    public function setINVOICE_ADDRESS_OBJID($iNVOICE_ADDRESS_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_ADDRESS_OBJID) && !is_string($iNVOICE_ADDRESS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_ADDRESS_OBJID, true), gettype($iNVOICE_ADDRESS_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_ADDRESS_OBJID) && !preg_match('/([0-9])*/', $iNVOICE_ADDRESS_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_ADDRESS_OBJID, true)), __LINE__);
        }
        $this->INVOICE_ADDRESS_OBJID = $this->{'INVOICE-ADDRESS-OBJID'} = $iNVOICE_ADDRESS_OBJID;
        return $this;
    }
    /**
     * Get INVOICE_ADDRESS_CENTRALID value
     * @return string
     */
    public function getINVOICE_ADDRESS_CENTRALID()
    {
        return $this->{'INVOICE-ADDRESS-CENTRALID'};
    }
    /**
     * Set INVOICE_ADDRESS_CENTRALID value
     * @param string $iNVOICE_ADDRESS_CENTRALID
     * @return \StructType\INVOICE_ADDRESS
     */
    public function setINVOICE_ADDRESS_CENTRALID($iNVOICE_ADDRESS_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_ADDRESS_CENTRALID) && !is_string($iNVOICE_ADDRESS_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_ADDRESS_CENTRALID, true), gettype($iNVOICE_ADDRESS_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_ADDRESS_CENTRALID) && !preg_match('/([0-9])*/', $iNVOICE_ADDRESS_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_ADDRESS_CENTRALID, true)), __LINE__);
        }
        $this->INVOICE_ADDRESS_CENTRALID = $this->{'INVOICE-ADDRESS-CENTRALID'} = $iNVOICE_ADDRESS_CENTRALID;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\INVOICE_ADDRESS
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\INVOICE_ADDRESS
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get INVOICE_ADDRESS_CONTACTPERSON_OBJID value
     * @return string
     */
    public function getINVOICE_ADDRESS_CONTACTPERSON_OBJID()
    {
        return $this->{'INVOICE-ADDRESS-CONTACTPERSON-OBJID'};
    }
    /**
     * Set INVOICE_ADDRESS_CONTACTPERSON_OBJID value
     * @param string $iNVOICE_ADDRESS_CONTACTPERSON_OBJID
     * @return \StructType\INVOICE_ADDRESS
     */
    public function setINVOICE_ADDRESS_CONTACTPERSON_OBJID($iNVOICE_ADDRESS_CONTACTPERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_ADDRESS_CONTACTPERSON_OBJID) && !is_string($iNVOICE_ADDRESS_CONTACTPERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_ADDRESS_CONTACTPERSON_OBJID, true), gettype($iNVOICE_ADDRESS_CONTACTPERSON_OBJID)), __LINE__);
        }
        $this->INVOICE_ADDRESS_CONTACTPERSON_OBJID = $this->{'INVOICE-ADDRESS-CONTACTPERSON-OBJID'} = $iNVOICE_ADDRESS_CONTACTPERSON_OBJID;
        return $this;
    }
}
