<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICESEARCH StructType
 * @subpackage Structs
 */
class INVOICESEARCH extends AbstractStructBase
{
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The invoicenosets
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoicenosets;
    /**
     * The invoicenofrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoicenofrom;
    /**
     * The invoicenoto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoicenoto;
    /**
     * Constructor method for INVOICESEARCH
     * @uses INVOICESEARCH::setDatefrom()
     * @uses INVOICESEARCH::setDateto()
     * @uses INVOICESEARCH::setInvoicenosets()
     * @uses INVOICESEARCH::setInvoicenofrom()
     * @uses INVOICESEARCH::setInvoicenoto()
     * @param string $datefrom
     * @param string $dateto
     * @param string $invoicenosets
     * @param string $invoicenofrom
     * @param string $invoicenoto
     */
    public function __construct($datefrom = null, $dateto = null, $invoicenosets = null, $invoicenofrom = null, $invoicenoto = null)
    {
        $this
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setInvoicenosets($invoicenosets)
            ->setInvoicenofrom($invoicenofrom)
            ->setInvoicenoto($invoicenoto);
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\INVOICESEARCH
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\INVOICESEARCH
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get invoicenosets value
     * @return string
     */
    public function getInvoicenosets()
    {
        return $this->invoicenosets;
    }
    /**
     * Set invoicenosets value
     * @param string $invoicenosets
     * @return \StructType\INVOICESEARCH
     */
    public function setInvoicenosets($invoicenosets = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenosets) && !is_string($invoicenosets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenosets, true), gettype($invoicenosets)), __LINE__);
        }
        $this->invoicenosets = $invoicenosets;
        return $this;
    }
    /**
     * Get invoicenofrom value
     * @return string|null
     */
    public function getInvoicenofrom()
    {
        return $this->invoicenofrom;
    }
    /**
     * Set invoicenofrom value
     * @param string $invoicenofrom
     * @return \StructType\INVOICESEARCH
     */
    public function setInvoicenofrom($invoicenofrom = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenofrom) && !is_string($invoicenofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenofrom, true), gettype($invoicenofrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoicenofrom) && !preg_match('/([0-9])*/', $invoicenofrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoicenofrom, true)), __LINE__);
        }
        $this->invoicenofrom = $invoicenofrom;
        return $this;
    }
    /**
     * Get invoicenoto value
     * @return string|null
     */
    public function getInvoicenoto()
    {
        return $this->invoicenoto;
    }
    /**
     * Set invoicenoto value
     * @param string $invoicenoto
     * @return \StructType\INVOICESEARCH
     */
    public function setInvoicenoto($invoicenoto = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoto) && !is_string($invoicenoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoto, true), gettype($invoicenoto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoicenoto) && !preg_match('/([0-9])*/', $invoicenoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoicenoto, true)), __LINE__);
        }
        $this->invoicenoto = $invoicenoto;
        return $this;
    }
}
