<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for INVOICE StructType
 * @subpackage Structs
 */
class INVOICE extends AbstractStructBase
{
    /**
     * The INVOICE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $INVOICE_OBJID;
    /**
     * The voucherno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $voucherno;
    /**
     * The refno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $refno;
    /**
     * The invoiceno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $invoiceno;
    /**
     * The invoicenoset
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $invoicenoset;
    /**
     * The emailforebill
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $emailforebill;
    /**
     * The hotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotel;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The externalreference2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference2;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The creationdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $creationdate;
    /**
     * The creationtime
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|
     * @var string
     */
    public $creationtime;
    /**
     * The operator
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $operator;
    /**
     * The CANCELTYPE
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $CANCELTYPE;
    /**
     * The cancellationinvoiceno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $cancellationinvoiceno;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The amountpaid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amountpaid;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The currencyinvoiceamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $currencyinvoiceamount;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The fiscalsignature
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $fiscalsignature;
    /**
     * The INVOICEHOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INVOICEHOLDER_1
     */
    public $INVOICEHOLDER;
    /**
     * The VATS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VATS
     */
    public $VATS;
    /**
     * The TAXS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TAXS
     */
    public $TAXS;
    /**
     * The SERVICES
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\SERVICES
     */
    public $SERVICES;
    /**
     * The PAYMENTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PAYMENTS_1
     */
    public $PAYMENTS;
    /**
     * The MAINACCOUNT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MAINACCOUNT_1[]
     */
    public $MAINACCOUNT;
    /**
     * The RESERVATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RESERVATION[]
     */
    public $RESERVATION;
    /**
     * The PRINTDOCUMENT
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PRINTDOCUMENT[]
     */
    public $PRINTDOCUMENT;
    /**
     * Constructor method for INVOICE
     * @uses INVOICE::setINVOICE_OBJID()
     * @uses INVOICE::setVoucherno()
     * @uses INVOICE::setRefno()
     * @uses INVOICE::setInvoiceno()
     * @uses INVOICE::setInvoicenoset()
     * @uses INVOICE::setEmailforebill()
     * @uses INVOICE::setHotel()
     * @uses INVOICE::setExternalreference()
     * @uses INVOICE::setExternalreference2()
     * @uses INVOICE::setDate()
     * @uses INVOICE::setCreationdate()
     * @uses INVOICE::setCreationtime()
     * @uses INVOICE::setOperator()
     * @uses INVOICE::setCANCELTYPE()
     * @uses INVOICE::setCancellationinvoiceno()
     * @uses INVOICE::setResno()
     * @uses INVOICE::setAmount()
     * @uses INVOICE::setAmountpaid()
     * @uses INVOICE::setCurrency()
     * @uses INVOICE::setCurrencyinvoiceamount()
     * @uses INVOICE::setTypeofpayment()
     * @uses INVOICE::setFiscalsignature()
     * @uses INVOICE::setINVOICEHOLDER()
     * @uses INVOICE::setVATS()
     * @uses INVOICE::setTAXS()
     * @uses INVOICE::setSERVICES()
     * @uses INVOICE::setPAYMENTS()
     * @uses INVOICE::setMAINACCOUNT()
     * @uses INVOICE::setRESERVATION()
     * @uses INVOICE::setPRINTDOCUMENT()
     * @param string $iNVOICE_OBJID
     * @param string $voucherno
     * @param string $refno
     * @param string $invoiceno
     * @param string $invoicenoset
     * @param string $emailforebill
     * @param string $hotel
     * @param string $externalreference
     * @param string $externalreference2
     * @param string $date
     * @param string $creationdate
     * @param string $creationtime
     * @param string $operator
     * @param string $cANCELTYPE
     * @param string $cancellationinvoiceno
     * @param string $resno
     * @param string $amount
     * @param string $amountpaid
     * @param string $currency
     * @param string $currencyinvoiceamount
     * @param string $typeofpayment
     * @param string $fiscalsignature
     * @param \StructType\INVOICEHOLDER_1 $iNVOICEHOLDER
     * @param \StructType\VATS $vATS
     * @param \StructType\TAXS $tAXS
     * @param \StructType\SERVICES $sERVICES
     * @param \StructType\PAYMENTS_1 $pAYMENTS
     * @param \StructType\MAINACCOUNT_1[] $mAINACCOUNT
     * @param \StructType\RESERVATION[] $rESERVATION
     * @param \StructType\PRINTDOCUMENT[] $pRINTDOCUMENT
     */
    public function __construct($iNVOICE_OBJID = null, $voucherno = null, $refno = null, $invoiceno = null, $invoicenoset = null, $emailforebill = null, $hotel = null, $externalreference = null, $externalreference2 = null, $date = null, $creationdate = null, $creationtime = null, $operator = null, $cANCELTYPE = null, $cancellationinvoiceno = null, $resno = null, $amount = null, $amountpaid = null, $currency = null, $currencyinvoiceamount = null, $typeofpayment = null, $fiscalsignature = null, \StructType\INVOICEHOLDER_1 $iNVOICEHOLDER = null, \StructType\VATS $vATS = null, \StructType\TAXS $tAXS = null, \StructType\SERVICES $sERVICES = null, \StructType\PAYMENTS_1 $pAYMENTS = null, array $mAINACCOUNT = array(), array $rESERVATION = array(), array $pRINTDOCUMENT = array())
    {
        $this
            ->setINVOICE_OBJID($iNVOICE_OBJID)
            ->setVoucherno($voucherno)
            ->setRefno($refno)
            ->setInvoiceno($invoiceno)
            ->setInvoicenoset($invoicenoset)
            ->setEmailforebill($emailforebill)
            ->setHotel($hotel)
            ->setExternalreference($externalreference)
            ->setExternalreference2($externalreference2)
            ->setDate($date)
            ->setCreationdate($creationdate)
            ->setCreationtime($creationtime)
            ->setOperator($operator)
            ->setCANCELTYPE($cANCELTYPE)
            ->setCancellationinvoiceno($cancellationinvoiceno)
            ->setResno($resno)
            ->setAmount($amount)
            ->setAmountpaid($amountpaid)
            ->setCurrency($currency)
            ->setCurrencyinvoiceamount($currencyinvoiceamount)
            ->setTypeofpayment($typeofpayment)
            ->setFiscalsignature($fiscalsignature)
            ->setINVOICEHOLDER($iNVOICEHOLDER)
            ->setVATS($vATS)
            ->setTAXS($tAXS)
            ->setSERVICES($sERVICES)
            ->setPAYMENTS($pAYMENTS)
            ->setMAINACCOUNT($mAINACCOUNT)
            ->setRESERVATION($rESERVATION)
            ->setPRINTDOCUMENT($pRINTDOCUMENT);
    }
    /**
     * Get INVOICE_OBJID value
     * @return string
     */
    public function getINVOICE_OBJID()
    {
        return $this->{'INVOICE-OBJID'};
    }
    /**
     * Set INVOICE_OBJID value
     * @param string $iNVOICE_OBJID
     * @return \StructType\INVOICE
     */
    public function setINVOICE_OBJID($iNVOICE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_OBJID) && !is_string($iNVOICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_OBJID, true), gettype($iNVOICE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($iNVOICE_OBJID) && !preg_match('/([0-9])*/', $iNVOICE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($iNVOICE_OBJID, true)), __LINE__);
        }
        $this->INVOICE_OBJID = $this->{'INVOICE-OBJID'} = $iNVOICE_OBJID;
        return $this;
    }
    /**
     * Get voucherno value
     * @return string
     */
    public function getVoucherno()
    {
        return $this->voucherno;
    }
    /**
     * Set voucherno value
     * @param string $voucherno
     * @return \StructType\INVOICE
     */
    public function setVoucherno($voucherno = null)
    {
        // validation for constraint: string
        if (!is_null($voucherno) && !is_string($voucherno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherno, true), gettype($voucherno)), __LINE__);
        }
        $this->voucherno = $voucherno;
        return $this;
    }
    /**
     * Get refno value
     * @return string
     */
    public function getRefno()
    {
        return $this->refno;
    }
    /**
     * Set refno value
     * @param string $refno
     * @return \StructType\INVOICE
     */
    public function setRefno($refno = null)
    {
        // validation for constraint: string
        if (!is_null($refno) && !is_string($refno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refno, true), gettype($refno)), __LINE__);
        }
        $this->refno = $refno;
        return $this;
    }
    /**
     * Get invoiceno value
     * @return string
     */
    public function getInvoiceno()
    {
        return $this->invoiceno;
    }
    /**
     * Set invoiceno value
     * @param string $invoiceno
     * @return \StructType\INVOICE
     */
    public function setInvoiceno($invoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceno) && !is_string($invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceno, true), gettype($invoiceno)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($invoiceno) && !preg_match('/([0-9])*/', $invoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($invoiceno, true)), __LINE__);
        }
        $this->invoiceno = $invoiceno;
        return $this;
    }
    /**
     * Get invoicenoset value
     * @return string
     */
    public function getInvoicenoset()
    {
        return $this->invoicenoset;
    }
    /**
     * Set invoicenoset value
     * @param string $invoicenoset
     * @return \StructType\INVOICE
     */
    public function setInvoicenoset($invoicenoset = null)
    {
        // validation for constraint: string
        if (!is_null($invoicenoset) && !is_string($invoicenoset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicenoset, true), gettype($invoicenoset)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($invoicenoset)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($invoicenoset) && mb_strlen($invoicenoset) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($invoicenoset)), __LINE__);
        }
        $this->invoicenoset = $invoicenoset;
        return $this;
    }
    /**
     * Get emailforebill value
     * @return string
     */
    public function getEmailforebill()
    {
        return $this->emailforebill;
    }
    /**
     * Set emailforebill value
     * @param string $emailforebill
     * @return \StructType\INVOICE
     */
    public function setEmailforebill($emailforebill = null)
    {
        // validation for constraint: string
        if (!is_null($emailforebill) && !is_string($emailforebill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailforebill, true), gettype($emailforebill)), __LINE__);
        }
        $this->emailforebill = $emailforebill;
        return $this;
    }
    /**
     * Get hotel value
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }
    /**
     * Set hotel value
     * @param string $hotel
     * @return \StructType\INVOICE
     */
    public function setHotel($hotel = null)
    {
        // validation for constraint: string
        if (!is_null($hotel) && !is_string($hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotel, true), gettype($hotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotel) && !preg_match('/([-+]){0,1}([0-9])*/', $hotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotel, true)), __LINE__);
        }
        $this->hotel = $hotel;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\INVOICE
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get externalreference2 value
     * @return string
     */
    public function getExternalreference2()
    {
        return $this->externalreference2;
    }
    /**
     * Set externalreference2 value
     * @param string $externalreference2
     * @return \StructType\INVOICE
     */
    public function setExternalreference2($externalreference2 = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference2) && !is_string($externalreference2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference2, true), gettype($externalreference2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($externalreference2) && mb_strlen($externalreference2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($externalreference2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference2) && mb_strlen($externalreference2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference2)), __LINE__);
        }
        $this->externalreference2 = $externalreference2;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\INVOICE
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get creationdate value
     * @return string
     */
    public function getCreationdate()
    {
        return $this->creationdate;
    }
    /**
     * Set creationdate value
     * @param string $creationdate
     * @return \StructType\INVOICE
     */
    public function setCreationdate($creationdate = null)
    {
        // validation for constraint: string
        if (!is_null($creationdate) && !is_string($creationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationdate, true), gettype($creationdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($creationdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $creationdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($creationdate, true)), __LINE__);
        }
        $this->creationdate = $creationdate;
        return $this;
    }
    /**
     * Get creationtime value
     * @return string
     */
    public function getCreationtime()
    {
        return $this->creationtime;
    }
    /**
     * Set creationtime value
     * @param string $creationtime
     * @return \StructType\INVOICE
     */
    public function setCreationtime($creationtime = null)
    {
        // validation for constraint: string
        if (!is_null($creationtime) && !is_string($creationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationtime, true), gettype($creationtime)), __LINE__);
        }
        // validation for constraint: pattern(([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|)
        if (!is_null($creationtime) && !preg_match('/([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|/', $creationtime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])|', var_export($creationtime, true)), __LINE__);
        }
        $this->creationtime = $creationtime;
        return $this;
    }
    /**
     * Get operator value
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @param string $operator
     * @return \StructType\INVOICE
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: string
        if (!is_null($operator) && !is_string($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operator, true), gettype($operator)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($operator) && mb_strlen($operator) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($operator)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($operator) && mb_strlen($operator) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($operator)), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get CANCELTYPE value
     * @return string
     */
    public function getCANCELTYPE()
    {
        return $this->CANCELTYPE;
    }
    /**
     * Set CANCELTYPE value
     * @param string $cANCELTYPE
     * @return \StructType\INVOICE
     */
    public function setCANCELTYPE($cANCELTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($cANCELTYPE) && !is_string($cANCELTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cANCELTYPE, true), gettype($cANCELTYPE)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($cANCELTYPE) && !preg_match('/([-+]){0,1}([0-9])*/', $cANCELTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($cANCELTYPE, true)), __LINE__);
        }
        $this->CANCELTYPE = $cANCELTYPE;
        return $this;
    }
    /**
     * Get cancellationinvoiceno value
     * @return string
     */
    public function getCancellationinvoiceno()
    {
        return $this->cancellationinvoiceno;
    }
    /**
     * Set cancellationinvoiceno value
     * @param string $cancellationinvoiceno
     * @return \StructType\INVOICE
     */
    public function setCancellationinvoiceno($cancellationinvoiceno = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationinvoiceno) && !is_string($cancellationinvoiceno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationinvoiceno, true), gettype($cancellationinvoiceno)), __LINE__);
        }
        $this->cancellationinvoiceno = $cancellationinvoiceno;
        return $this;
    }
    /**
     * Get resno value
     * @return string
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\INVOICE
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\INVOICE
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get amountpaid value
     * @return string
     */
    public function getAmountpaid()
    {
        return $this->amountpaid;
    }
    /**
     * Set amountpaid value
     * @param string $amountpaid
     * @return \StructType\INVOICE
     */
    public function setAmountpaid($amountpaid = null)
    {
        // validation for constraint: string
        if (!is_null($amountpaid) && !is_string($amountpaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountpaid, true), gettype($amountpaid)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amountpaid) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amountpaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amountpaid, true)), __LINE__);
        }
        $this->amountpaid = $amountpaid;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\INVOICE
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get currencyinvoiceamount value
     * @return string
     */
    public function getCurrencyinvoiceamount()
    {
        return $this->currencyinvoiceamount;
    }
    /**
     * Set currencyinvoiceamount value
     * @param string $currencyinvoiceamount
     * @return \StructType\INVOICE
     */
    public function setCurrencyinvoiceamount($currencyinvoiceamount = null)
    {
        // validation for constraint: string
        if (!is_null($currencyinvoiceamount) && !is_string($currencyinvoiceamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyinvoiceamount, true), gettype($currencyinvoiceamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($currencyinvoiceamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $currencyinvoiceamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($currencyinvoiceamount, true)), __LINE__);
        }
        $this->currencyinvoiceamount = $currencyinvoiceamount;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\INVOICE
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get fiscalsignature value
     * @return string
     */
    public function getFiscalsignature()
    {
        return $this->fiscalsignature;
    }
    /**
     * Set fiscalsignature value
     * @param string $fiscalsignature
     * @return \StructType\INVOICE
     */
    public function setFiscalsignature($fiscalsignature = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalsignature) && !is_string($fiscalsignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fiscalsignature, true), gettype($fiscalsignature)), __LINE__);
        }
        $this->fiscalsignature = $fiscalsignature;
        return $this;
    }
    /**
     * Get INVOICEHOLDER value
     * @return \StructType\INVOICEHOLDER_1
     */
    public function getINVOICEHOLDER()
    {
        return $this->INVOICEHOLDER;
    }
    /**
     * Set INVOICEHOLDER value
     * @param \StructType\INVOICEHOLDER_1 $iNVOICEHOLDER
     * @return \StructType\INVOICE
     */
    public function setINVOICEHOLDER(\StructType\INVOICEHOLDER_1 $iNVOICEHOLDER = null)
    {
        $this->INVOICEHOLDER = $iNVOICEHOLDER;
        return $this;
    }
    /**
     * Get VATS value
     * @return \StructType\VATS
     */
    public function getVATS()
    {
        return $this->VATS;
    }
    /**
     * Set VATS value
     * @param \StructType\VATS $vATS
     * @return \StructType\INVOICE
     */
    public function setVATS(\StructType\VATS $vATS = null)
    {
        $this->VATS = $vATS;
        return $this;
    }
    /**
     * Get TAXS value
     * @return \StructType\TAXS
     */
    public function getTAXS()
    {
        return $this->TAXS;
    }
    /**
     * Set TAXS value
     * @param \StructType\TAXS $tAXS
     * @return \StructType\INVOICE
     */
    public function setTAXS(\StructType\TAXS $tAXS = null)
    {
        $this->TAXS = $tAXS;
        return $this;
    }
    /**
     * Get SERVICES value
     * @return \StructType\SERVICES
     */
    public function getSERVICES()
    {
        return $this->SERVICES;
    }
    /**
     * Set SERVICES value
     * @param \StructType\SERVICES $sERVICES
     * @return \StructType\INVOICE
     */
    public function setSERVICES(\StructType\SERVICES $sERVICES = null)
    {
        $this->SERVICES = $sERVICES;
        return $this;
    }
    /**
     * Get PAYMENTS value
     * @return \StructType\PAYMENTS_1
     */
    public function getPAYMENTS()
    {
        return $this->PAYMENTS;
    }
    /**
     * Set PAYMENTS value
     * @param \StructType\PAYMENTS_1 $pAYMENTS
     * @return \StructType\INVOICE
     */
    public function setPAYMENTS(\StructType\PAYMENTS_1 $pAYMENTS = null)
    {
        $this->PAYMENTS = $pAYMENTS;
        return $this;
    }
    /**
     * Get MAINACCOUNT value
     * @return \StructType\MAINACCOUNT_1[]|null
     */
    public function getMAINACCOUNT()
    {
        return $this->MAINACCOUNT;
    }
    /**
     * This method is responsible for validating the values passed to the setMAINACCOUNT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMAINACCOUNT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMAINACCOUNTForArrayConstraintsFromSetMAINACCOUNT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iNVOICEMAINACCOUNTItem) {
            // validation for constraint: itemType
            if (!$iNVOICEMAINACCOUNTItem instanceof \StructType\MAINACCOUNT_1) {
                $invalidValues[] = is_object($iNVOICEMAINACCOUNTItem) ? get_class($iNVOICEMAINACCOUNTItem) : sprintf('%s(%s)', gettype($iNVOICEMAINACCOUNTItem), var_export($iNVOICEMAINACCOUNTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MAINACCOUNT property can only contain items of type \StructType\MAINACCOUNT_1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MAINACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\MAINACCOUNT_1[] $mAINACCOUNT
     * @return \StructType\INVOICE
     */
    public function setMAINACCOUNT(array $mAINACCOUNT = array())
    {
        // validation for constraint: array
        if ('' !== ($mAINACCOUNTArrayErrorMessage = self::validateMAINACCOUNTForArrayConstraintsFromSetMAINACCOUNT($mAINACCOUNT))) {
            throw new \InvalidArgumentException($mAINACCOUNTArrayErrorMessage, __LINE__);
        }
        $this->MAINACCOUNT = $mAINACCOUNT;
        return $this;
    }
    /**
     * Add item to MAINACCOUNT value
     * @throws \InvalidArgumentException
     * @param \StructType\MAINACCOUNT_1 $item
     * @return \StructType\INVOICE
     */
    public function addToMAINACCOUNT(\StructType\MAINACCOUNT_1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MAINACCOUNT_1) {
            throw new \InvalidArgumentException(sprintf('The MAINACCOUNT property can only contain items of type \StructType\MAINACCOUNT_1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MAINACCOUNT[] = $item;
        return $this;
    }
    /**
     * Get RESERVATION value
     * @return \StructType\RESERVATION[]|null
     */
    public function getRESERVATION()
    {
        return $this->RESERVATION;
    }
    /**
     * This method is responsible for validating the values passed to the setRESERVATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRESERVATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRESERVATIONForArrayConstraintsFromSetRESERVATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iNVOICERESERVATIONItem) {
            // validation for constraint: itemType
            if (!$iNVOICERESERVATIONItem instanceof \StructType\RESERVATION) {
                $invalidValues[] = is_object($iNVOICERESERVATIONItem) ? get_class($iNVOICERESERVATIONItem) : sprintf('%s(%s)', gettype($iNVOICERESERVATIONItem), var_export($iNVOICERESERVATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION[] $rESERVATION
     * @return \StructType\INVOICE
     */
    public function setRESERVATION(array $rESERVATION = array())
    {
        // validation for constraint: array
        if ('' !== ($rESERVATIONArrayErrorMessage = self::validateRESERVATIONForArrayConstraintsFromSetRESERVATION($rESERVATION))) {
            throw new \InvalidArgumentException($rESERVATIONArrayErrorMessage, __LINE__);
        }
        $this->RESERVATION = $rESERVATION;
        return $this;
    }
    /**
     * Add item to RESERVATION value
     * @throws \InvalidArgumentException
     * @param \StructType\RESERVATION $item
     * @return \StructType\INVOICE
     */
    public function addToRESERVATION(\StructType\RESERVATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RESERVATION) {
            throw new \InvalidArgumentException(sprintf('The RESERVATION property can only contain items of type \StructType\RESERVATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RESERVATION[] = $item;
        return $this;
    }
    /**
     * Get PRINTDOCUMENT value
     * @return \StructType\PRINTDOCUMENT[]|null
     */
    public function getPRINTDOCUMENT()
    {
        return $this->PRINTDOCUMENT;
    }
    /**
     * This method is responsible for validating the values passed to the setPRINTDOCUMENT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPRINTDOCUMENT method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePRINTDOCUMENTForArrayConstraintsFromSetPRINTDOCUMENT(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $iNVOICEPRINTDOCUMENTItem) {
            // validation for constraint: itemType
            if (!$iNVOICEPRINTDOCUMENTItem instanceof \StructType\PRINTDOCUMENT) {
                $invalidValues[] = is_object($iNVOICEPRINTDOCUMENTItem) ? get_class($iNVOICEPRINTDOCUMENTItem) : sprintf('%s(%s)', gettype($iNVOICEPRINTDOCUMENTItem), var_export($iNVOICEPRINTDOCUMENTItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PRINTDOCUMENT property can only contain items of type \StructType\PRINTDOCUMENT, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PRINTDOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\PRINTDOCUMENT[] $pRINTDOCUMENT
     * @return \StructType\INVOICE
     */
    public function setPRINTDOCUMENT(array $pRINTDOCUMENT = array())
    {
        // validation for constraint: array
        if ('' !== ($pRINTDOCUMENTArrayErrorMessage = self::validatePRINTDOCUMENTForArrayConstraintsFromSetPRINTDOCUMENT($pRINTDOCUMENT))) {
            throw new \InvalidArgumentException($pRINTDOCUMENTArrayErrorMessage, __LINE__);
        }
        $this->PRINTDOCUMENT = $pRINTDOCUMENT;
        return $this;
    }
    /**
     * Add item to PRINTDOCUMENT value
     * @throws \InvalidArgumentException
     * @param \StructType\PRINTDOCUMENT $item
     * @return \StructType\INVOICE
     */
    public function addToPRINTDOCUMENT(\StructType\PRINTDOCUMENT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PRINTDOCUMENT) {
            throw new \InvalidArgumentException(sprintf('The PRINTDOCUMENT property can only contain items of type \StructType\PRINTDOCUMENT, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PRINTDOCUMENT[] = $item;
        return $this;
    }
}
