<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel StructType
 * @subpackage Structs
 */
class Hotel extends AbstractStructBase
{
    /**
     * The HOTEL_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $HOTEL_OBJID;
    /**
     * The hotelno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelno;
    /**
     * The name1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name1;
    /**
     * The name2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $name2;
    /**
     * The codeinternal
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $codeinternal;
    /**
     * The hotelregion
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $hotelregion;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The pobox
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $pobox;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $location;
    /**
     * The location2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $location2;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The contactemail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $contactemail;
    /**
     * The statusdirty
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $statusdirty;
    /**
     * The statuscheckin
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $statuscheckin;
    /**
     * The statusclean
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $statusclean;
    /**
     * The statusdirtybyarrival
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $statusdirtybyarrival;
    /**
     * The statusdirtyall
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusdirtyall;
    /**
     * The updatecleaningstatusonckeckout
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $updatecleaningstatusonckeckout;
    /**
     * The updatetechstatusonckeckout
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $updatetechstatusonckeckout;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The uuid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $uuid;
    /**
     * The network1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $network1;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Images[]
     */
    public $Images;
    /**
     * Constructor method for Hotel
     * @uses Hotel::setHOTEL_OBJID()
     * @uses Hotel::setHotelno()
     * @uses Hotel::setName1()
     * @uses Hotel::setName2()
     * @uses Hotel::setCodeinternal()
     * @uses Hotel::setHotelregion()
     * @uses Hotel::setStreet()
     * @uses Hotel::setPobox()
     * @uses Hotel::setCountry()
     * @uses Hotel::setSubcountry()
     * @uses Hotel::setSubsubcountry()
     * @uses Hotel::setPostcode()
     * @uses Hotel::setLocation()
     * @uses Hotel::setLocation2()
     * @uses Hotel::setPhone()
     * @uses Hotel::setEmail1()
     * @uses Hotel::setContactemail()
     * @uses Hotel::setStatusdirty()
     * @uses Hotel::setStatuscheckin()
     * @uses Hotel::setStatusclean()
     * @uses Hotel::setStatusdirtybyarrival()
     * @uses Hotel::setStatusdirtyall()
     * @uses Hotel::setUpdatecleaningstatusonckeckout()
     * @uses Hotel::setUpdatetechstatusonckeckout()
     * @uses Hotel::setCurrency()
     * @uses Hotel::setUuid()
     * @uses Hotel::setNetwork1()
     * @uses Hotel::setImages()
     * @param string $hOTEL_OBJID
     * @param string $hotelno
     * @param string $name1
     * @param string $name2
     * @param string $codeinternal
     * @param string $hotelregion
     * @param string $street
     * @param string $pobox
     * @param string $country
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $postcode
     * @param string $location
     * @param string $location2
     * @param string $phone
     * @param string $email1
     * @param string $contactemail
     * @param string $statusdirty
     * @param string $statuscheckin
     * @param string $statusclean
     * @param string $statusdirtybyarrival
     * @param string $statusdirtyall
     * @param string $updatecleaningstatusonckeckout
     * @param string $updatetechstatusonckeckout
     * @param string $currency
     * @param string $uuid
     * @param string $network1
     * @param \StructType\Images[] $images
     */
    public function __construct($hOTEL_OBJID = null, $hotelno = null, $name1 = null, $name2 = null, $codeinternal = null, $hotelregion = null, $street = null, $pobox = null, $country = null, $subcountry = null, $subsubcountry = null, $postcode = null, $location = null, $location2 = null, $phone = null, $email1 = null, $contactemail = null, $statusdirty = null, $statuscheckin = null, $statusclean = null, $statusdirtybyarrival = null, $statusdirtyall = null, $updatecleaningstatusonckeckout = null, $updatetechstatusonckeckout = null, $currency = null, $uuid = null, $network1 = null, array $images = array())
    {
        $this
            ->setHOTEL_OBJID($hOTEL_OBJID)
            ->setHotelno($hotelno)
            ->setName1($name1)
            ->setName2($name2)
            ->setCodeinternal($codeinternal)
            ->setHotelregion($hotelregion)
            ->setStreet($street)
            ->setPobox($pobox)
            ->setCountry($country)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setPostcode($postcode)
            ->setLocation($location)
            ->setLocation2($location2)
            ->setPhone($phone)
            ->setEmail1($email1)
            ->setContactemail($contactemail)
            ->setStatusdirty($statusdirty)
            ->setStatuscheckin($statuscheckin)
            ->setStatusclean($statusclean)
            ->setStatusdirtybyarrival($statusdirtybyarrival)
            ->setStatusdirtyall($statusdirtyall)
            ->setUpdatecleaningstatusonckeckout($updatecleaningstatusonckeckout)
            ->setUpdatetechstatusonckeckout($updatetechstatusonckeckout)
            ->setCurrency($currency)
            ->setUuid($uuid)
            ->setNetwork1($network1)
            ->setImages($images);
    }
    /**
     * Get HOTEL_OBJID value
     * @return string
     */
    public function getHOTEL_OBJID()
    {
        return $this->{'HOTEL-OBJID'};
    }
    /**
     * Set HOTEL_OBJID value
     * @param string $hOTEL_OBJID
     * @return \StructType\Hotel
     */
    public function setHOTEL_OBJID($hOTEL_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($hOTEL_OBJID) && !is_string($hOTEL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hOTEL_OBJID, true), gettype($hOTEL_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($hOTEL_OBJID) && !preg_match('/([0-9])*/', $hOTEL_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($hOTEL_OBJID, true)), __LINE__);
        }
        $this->HOTEL_OBJID = $this->{'HOTEL-OBJID'} = $hOTEL_OBJID;
        return $this;
    }
    /**
     * Get hotelno value
     * @return string
     */
    public function getHotelno()
    {
        return $this->hotelno;
    }
    /**
     * Set hotelno value
     * @param string $hotelno
     * @return \StructType\Hotel
     */
    public function setHotelno($hotelno = null)
    {
        // validation for constraint: string
        if (!is_null($hotelno) && !is_string($hotelno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelno, true), gettype($hotelno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelno) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelno, true)), __LINE__);
        }
        $this->hotelno = $hotelno;
        return $this;
    }
    /**
     * Get name1 value
     * @return string
     */
    public function getName1()
    {
        return $this->name1;
    }
    /**
     * Set name1 value
     * @param string $name1
     * @return \StructType\Hotel
     */
    public function setName1($name1 = null)
    {
        // validation for constraint: string
        if (!is_null($name1) && !is_string($name1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name1, true), gettype($name1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name1) && mb_strlen($name1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name1) && mb_strlen($name1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name1)), __LINE__);
        }
        $this->name1 = $name1;
        return $this;
    }
    /**
     * Get name2 value
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }
    /**
     * Set name2 value
     * @param string $name2
     * @return \StructType\Hotel
     */
    public function setName2($name2 = null)
    {
        // validation for constraint: string
        if (!is_null($name2) && !is_string($name2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name2, true), gettype($name2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name2) && mb_strlen($name2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($name2) && mb_strlen($name2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($name2)), __LINE__);
        }
        $this->name2 = $name2;
        return $this;
    }
    /**
     * Get codeinternal value
     * @return string
     */
    public function getCodeinternal()
    {
        return $this->codeinternal;
    }
    /**
     * Set codeinternal value
     * @param string $codeinternal
     * @return \StructType\Hotel
     */
    public function setCodeinternal($codeinternal = null)
    {
        // validation for constraint: string
        if (!is_null($codeinternal) && !is_string($codeinternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeinternal, true), gettype($codeinternal)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($codeinternal) && mb_strlen($codeinternal) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($codeinternal)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($codeinternal) && mb_strlen($codeinternal) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($codeinternal)), __LINE__);
        }
        $this->codeinternal = $codeinternal;
        return $this;
    }
    /**
     * Get hotelregion value
     * @return string
     */
    public function getHotelregion()
    {
        return $this->hotelregion;
    }
    /**
     * Set hotelregion value
     * @param string $hotelregion
     * @return \StructType\Hotel
     */
    public function setHotelregion($hotelregion = null)
    {
        // validation for constraint: string
        if (!is_null($hotelregion) && !is_string($hotelregion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelregion, true), gettype($hotelregion)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($hotelregion) && mb_strlen($hotelregion) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($hotelregion)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($hotelregion) && mb_strlen($hotelregion) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($hotelregion)), __LINE__);
        }
        $this->hotelregion = $hotelregion;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Hotel
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get pobox value
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }
    /**
     * Set pobox value
     * @param string $pobox
     * @return \StructType\Hotel
     */
    public function setPobox($pobox = null)
    {
        // validation for constraint: string
        if (!is_null($pobox) && !is_string($pobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pobox, true), gettype($pobox)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($pobox) && mb_strlen($pobox) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($pobox)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pobox) && mb_strlen($pobox) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pobox)), __LINE__);
        }
        $this->pobox = $pobox;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\Hotel
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\Hotel
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\Hotel
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\Hotel
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get location value
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\Hotel
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($location) && mb_strlen($location) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($location)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location) && mb_strlen($location) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get location2 value
     * @return string
     */
    public function getLocation2()
    {
        return $this->location2;
    }
    /**
     * Set location2 value
     * @param string $location2
     * @return \StructType\Hotel
     */
    public function setLocation2($location2 = null)
    {
        // validation for constraint: string
        if (!is_null($location2) && !is_string($location2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location2, true), gettype($location2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($location2) && mb_strlen($location2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($location2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location2) && mb_strlen($location2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location2)), __LINE__);
        }
        $this->location2 = $location2;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\Hotel
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\Hotel
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get contactemail value
     * @return string
     */
    public function getContactemail()
    {
        return $this->contactemail;
    }
    /**
     * Set contactemail value
     * @param string $contactemail
     * @return \StructType\Hotel
     */
    public function setContactemail($contactemail = null)
    {
        // validation for constraint: string
        if (!is_null($contactemail) && !is_string($contactemail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactemail, true), gettype($contactemail)), __LINE__);
        }
        $this->contactemail = $contactemail;
        return $this;
    }
    /**
     * Get statusdirty value
     * @return string
     */
    public function getStatusdirty()
    {
        return $this->statusdirty;
    }
    /**
     * Set statusdirty value
     * @param string $statusdirty
     * @return \StructType\Hotel
     */
    public function setStatusdirty($statusdirty = null)
    {
        // validation for constraint: string
        if (!is_null($statusdirty) && !is_string($statusdirty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusdirty, true), gettype($statusdirty)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($statusdirty) && mb_strlen($statusdirty) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($statusdirty)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($statusdirty) && mb_strlen($statusdirty) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($statusdirty)), __LINE__);
        }
        $this->statusdirty = $statusdirty;
        return $this;
    }
    /**
     * Get statuscheckin value
     * @return string
     */
    public function getStatuscheckin()
    {
        return $this->statuscheckin;
    }
    /**
     * Set statuscheckin value
     * @param string $statuscheckin
     * @return \StructType\Hotel
     */
    public function setStatuscheckin($statuscheckin = null)
    {
        // validation for constraint: string
        if (!is_null($statuscheckin) && !is_string($statuscheckin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statuscheckin, true), gettype($statuscheckin)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($statuscheckin) && mb_strlen($statuscheckin) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($statuscheckin)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($statuscheckin) && mb_strlen($statuscheckin) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($statuscheckin)), __LINE__);
        }
        $this->statuscheckin = $statuscheckin;
        return $this;
    }
    /**
     * Get statusclean value
     * @return string
     */
    public function getStatusclean()
    {
        return $this->statusclean;
    }
    /**
     * Set statusclean value
     * @param string $statusclean
     * @return \StructType\Hotel
     */
    public function setStatusclean($statusclean = null)
    {
        // validation for constraint: string
        if (!is_null($statusclean) && !is_string($statusclean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusclean, true), gettype($statusclean)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($statusclean) && mb_strlen($statusclean) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($statusclean)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($statusclean) && mb_strlen($statusclean) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($statusclean)), __LINE__);
        }
        $this->statusclean = $statusclean;
        return $this;
    }
    /**
     * Get statusdirtybyarrival value
     * @return string
     */
    public function getStatusdirtybyarrival()
    {
        return $this->statusdirtybyarrival;
    }
    /**
     * Set statusdirtybyarrival value
     * @param string $statusdirtybyarrival
     * @return \StructType\Hotel
     */
    public function setStatusdirtybyarrival($statusdirtybyarrival = null)
    {
        // validation for constraint: string
        if (!is_null($statusdirtybyarrival) && !is_string($statusdirtybyarrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusdirtybyarrival, true), gettype($statusdirtybyarrival)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($statusdirtybyarrival) && mb_strlen($statusdirtybyarrival) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($statusdirtybyarrival)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($statusdirtybyarrival) && mb_strlen($statusdirtybyarrival) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($statusdirtybyarrival)), __LINE__);
        }
        $this->statusdirtybyarrival = $statusdirtybyarrival;
        return $this;
    }
    /**
     * Get statusdirtyall value
     * @return string
     */
    public function getStatusdirtyall()
    {
        return $this->statusdirtyall;
    }
    /**
     * Set statusdirtyall value
     * @param string $statusdirtyall
     * @return \StructType\Hotel
     */
    public function setStatusdirtyall($statusdirtyall = null)
    {
        // validation for constraint: string
        if (!is_null($statusdirtyall) && !is_string($statusdirtyall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusdirtyall, true), gettype($statusdirtyall)), __LINE__);
        }
        $this->statusdirtyall = $statusdirtyall;
        return $this;
    }
    /**
     * Get updatecleaningstatusonckeckout value
     * @return string
     */
    public function getUpdatecleaningstatusonckeckout()
    {
        return $this->updatecleaningstatusonckeckout;
    }
    /**
     * Set updatecleaningstatusonckeckout value
     * @param string $updatecleaningstatusonckeckout
     * @return \StructType\Hotel
     */
    public function setUpdatecleaningstatusonckeckout($updatecleaningstatusonckeckout = null)
    {
        // validation for constraint: string
        if (!is_null($updatecleaningstatusonckeckout) && !is_string($updatecleaningstatusonckeckout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatecleaningstatusonckeckout, true), gettype($updatecleaningstatusonckeckout)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($updatecleaningstatusonckeckout) && mb_strlen($updatecleaningstatusonckeckout) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($updatecleaningstatusonckeckout)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($updatecleaningstatusonckeckout) && mb_strlen($updatecleaningstatusonckeckout) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($updatecleaningstatusonckeckout)), __LINE__);
        }
        $this->updatecleaningstatusonckeckout = $updatecleaningstatusonckeckout;
        return $this;
    }
    /**
     * Get updatetechstatusonckeckout value
     * @return string
     */
    public function getUpdatetechstatusonckeckout()
    {
        return $this->updatetechstatusonckeckout;
    }
    /**
     * Set updatetechstatusonckeckout value
     * @param string $updatetechstatusonckeckout
     * @return \StructType\Hotel
     */
    public function setUpdatetechstatusonckeckout($updatetechstatusonckeckout = null)
    {
        // validation for constraint: string
        if (!is_null($updatetechstatusonckeckout) && !is_string($updatetechstatusonckeckout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatetechstatusonckeckout, true), gettype($updatetechstatusonckeckout)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($updatetechstatusonckeckout) && mb_strlen($updatetechstatusonckeckout) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($updatetechstatusonckeckout)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($updatetechstatusonckeckout) && mb_strlen($updatetechstatusonckeckout) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($updatetechstatusonckeckout)), __LINE__);
        }
        $this->updatetechstatusonckeckout = $updatetechstatusonckeckout;
        return $this;
    }
    /**
     * Get currency value
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Hotel
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get uuid value
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\Hotel
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get network1 value
     * @return string
     */
    public function getNetwork1()
    {
        return $this->network1;
    }
    /**
     * Set network1 value
     * @param string $network1
     * @return \StructType\Hotel
     */
    public function setNetwork1($network1 = null)
    {
        // validation for constraint: string
        if (!is_null($network1) && !is_string($network1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($network1, true), gettype($network1)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($network1) && mb_strlen($network1) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($network1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($network1) && mb_strlen($network1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($network1)), __LINE__);
        }
        $this->network1 = $network1;
        return $this;
    }
    /**
     * Get Images value
     * @return \StructType\Images[]|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * This method is responsible for validating the values passed to the setImages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImagesForArrayConstraintsFromSetImages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelImagesItem) {
            // validation for constraint: itemType
            if (!$hotelImagesItem instanceof \StructType\Images) {
                $invalidValues[] = is_object($hotelImagesItem) ? get_class($hotelImagesItem) : sprintf('%s(%s)', gettype($hotelImagesItem), var_export($hotelImagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images[] $images
     * @return \StructType\Hotel
     */
    public function setImages(array $images = array())
    {
        // validation for constraint: array
        if ('' !== ($imagesArrayErrorMessage = self::validateImagesForArrayConstraintsFromSetImages($images))) {
            throw new \InvalidArgumentException($imagesArrayErrorMessage, __LINE__);
        }
        $this->Images = $images;
        return $this;
    }
    /**
     * Add item to Images value
     * @throws \InvalidArgumentException
     * @param \StructType\Images $item
     * @return \StructType\Hotel
     */
    public function addToImages(\StructType\Images $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Images) {
            throw new \InvalidArgumentException(sprintf('The Images property can only contain items of type \StructType\Images, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Images[] = $item;
        return $this;
    }
}
