<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guests StructType
 * @subpackage Structs
 */
class Guests extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The centralid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $centralid;
    /**
     * Constructor method for Guests
     * @uses Guests::setGUEST_OBJID()
     * @uses Guests::setCentralid()
     * @param string $gUEST_OBJID
     * @param string $centralid
     */
    public function __construct($gUEST_OBJID = null, $centralid = null)
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setCentralid($centralid);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\Guests
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get centralid value
     * @return string
     */
    public function getCentralid()
    {
        return $this->centralid;
    }
    /**
     * Set centralid value
     * @param string $centralid
     * @return \StructType\Guests
     */
    public function setCentralid($centralid = null)
    {
        // validation for constraint: string
        if (!is_null($centralid) && !is_string($centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($centralid, true), gettype($centralid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($centralid) && !preg_match('/([0-9])*/', $centralid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($centralid, true)), __LINE__);
        }
        $this->centralid = $centralid;
        return $this;
    }
}
