<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestInHouseSearch StructType
 * @subpackage Structs
 */
class GuestInHouseSearch extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The scope
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scope;
    /**
     * The resno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $resno;
    /**
     * The orderer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderer;
    /**
     * The room
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $room;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastnamefirstname;
    /**
     * The birthday
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthday;
    /**
     * The externaltype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externaltype;
    /**
     * The externalid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalid;
    /**
     * The kioskexactsearch
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $kioskexactsearch;
    /**
     * The ignorevirtualcategories
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $ignorevirtualcategories;
    /**
     * Constructor method for GuestInHouseSearch
     * @uses GuestInHouseSearch::setDate()
     * @uses GuestInHouseSearch::setScope()
     * @uses GuestInHouseSearch::setResno()
     * @uses GuestInHouseSearch::setOrderer()
     * @uses GuestInHouseSearch::setRoom()
     * @uses GuestInHouseSearch::setLastnamefirstname()
     * @uses GuestInHouseSearch::setBirthday()
     * @uses GuestInHouseSearch::setExternaltype()
     * @uses GuestInHouseSearch::setExternalid()
     * @uses GuestInHouseSearch::setKioskexactsearch()
     * @uses GuestInHouseSearch::setIgnorevirtualcategories()
     * @param string $date
     * @param string $scope
     * @param string $resno
     * @param string $orderer
     * @param string $room
     * @param string $lastnamefirstname
     * @param string $birthday
     * @param string $externaltype
     * @param string $externalid
     * @param string $kioskexactsearch
     * @param string $ignorevirtualcategories
     */
    public function __construct($date = null, $scope = null, $resno = null, $orderer = null, $room = null, $lastnamefirstname = null, $birthday = null, $externaltype = null, $externalid = null, $kioskexactsearch = null, $ignorevirtualcategories = null)
    {
        $this
            ->setDate($date)
            ->setScope($scope)
            ->setResno($resno)
            ->setOrderer($orderer)
            ->setRoom($room)
            ->setLastnamefirstname($lastnamefirstname)
            ->setBirthday($birthday)
            ->setExternaltype($externaltype)
            ->setExternalid($externalid)
            ->setKioskexactsearch($kioskexactsearch)
            ->setIgnorevirtualcategories($ignorevirtualcategories);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\GuestInHouseSearch
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\GuestInHouseSearch
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Get resno value
     * @return string|null
     */
    public function getResno()
    {
        return $this->resno;
    }
    /**
     * Set resno value
     * @param string $resno
     * @return \StructType\GuestInHouseSearch
     */
    public function setResno($resno = null)
    {
        // validation for constraint: string
        if (!is_null($resno) && !is_string($resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resno, true), gettype($resno)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($resno) && !preg_match('/([-+]){0,1}([0-9])*/', $resno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($resno, true)), __LINE__);
        }
        $this->resno = $resno;
        return $this;
    }
    /**
     * Get orderer value
     * @return string|null
     */
    public function getOrderer()
    {
        return $this->orderer;
    }
    /**
     * Set orderer value
     * @param string $orderer
     * @return \StructType\GuestInHouseSearch
     */
    public function setOrderer($orderer = null)
    {
        // validation for constraint: string
        if (!is_null($orderer) && !is_string($orderer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderer, true), gettype($orderer)), __LINE__);
        }
        $this->orderer = $orderer;
        return $this;
    }
    /**
     * Get room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\GuestInHouseSearch
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string|null
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\GuestInHouseSearch
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
    /**
     * Get birthday value
     * @return string|null
     */
    public function getBirthday()
    {
        return $this->birthday;
    }
    /**
     * Set birthday value
     * @param string $birthday
     * @return \StructType\GuestInHouseSearch
     */
    public function setBirthday($birthday = null)
    {
        // validation for constraint: string
        if (!is_null($birthday) && !is_string($birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthday, true), gettype($birthday)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthday) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthday, true)), __LINE__);
        }
        $this->birthday = $birthday;
        return $this;
    }
    /**
     * Get externaltype value
     * @return string|null
     */
    public function getExternaltype()
    {
        return $this->externaltype;
    }
    /**
     * Set externaltype value
     * @param string $externaltype
     * @return \StructType\GuestInHouseSearch
     */
    public function setExternaltype($externaltype = null)
    {
        // validation for constraint: string
        if (!is_null($externaltype) && !is_string($externaltype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externaltype, true), gettype($externaltype)), __LINE__);
        }
        $this->externaltype = $externaltype;
        return $this;
    }
    /**
     * Get externalid value
     * @return string|null
     */
    public function getExternalid()
    {
        return $this->externalid;
    }
    /**
     * Set externalid value
     * @param string $externalid
     * @return \StructType\GuestInHouseSearch
     */
    public function setExternalid($externalid = null)
    {
        // validation for constraint: string
        if (!is_null($externalid) && !is_string($externalid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalid, true), gettype($externalid)), __LINE__);
        }
        $this->externalid = $externalid;
        return $this;
    }
    /**
     * Get kioskexactsearch value
     * @return string|null
     */
    public function getKioskexactsearch()
    {
        return $this->kioskexactsearch;
    }
    /**
     * Set kioskexactsearch value
     * @param string $kioskexactsearch
     * @return \StructType\GuestInHouseSearch
     */
    public function setKioskexactsearch($kioskexactsearch = null)
    {
        // validation for constraint: string
        if (!is_null($kioskexactsearch) && !is_string($kioskexactsearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kioskexactsearch, true), gettype($kioskexactsearch)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($kioskexactsearch) && !preg_match('/([-+]){0,1}([0-9])*/', $kioskexactsearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($kioskexactsearch, true)), __LINE__);
        }
        $this->kioskexactsearch = $kioskexactsearch;
        return $this;
    }
    /**
     * Get ignorevirtualcategories value
     * @return string|null
     */
    public function getIgnorevirtualcategories()
    {
        return $this->ignorevirtualcategories;
    }
    /**
     * Set ignorevirtualcategories value
     * @param string $ignorevirtualcategories
     * @return \StructType\GuestInHouseSearch
     */
    public function setIgnorevirtualcategories($ignorevirtualcategories = null)
    {
        // validation for constraint: string
        if (!is_null($ignorevirtualcategories) && !is_string($ignorevirtualcategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ignorevirtualcategories, true), gettype($ignorevirtualcategories)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($ignorevirtualcategories) && !preg_match('/([-+]){0,1}([0-9])*/', $ignorevirtualcategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($ignorevirtualcategories, true)), __LINE__);
        }
        $this->ignorevirtualcategories = $ignorevirtualcategories;
        return $this;
    }
}
