<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gst StructType
 * @subpackage Structs
 */
class Gst extends AbstractStructBase
{
    /**
     * The GST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GST_OBJID;
    /**
     * The externaltypefilter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $externaltypefilter;
    /**
     * The EXTERNALID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EXTERNALID[]
     */
    public $EXTERNALID;
    /**
     * Constructor method for Gst
     * @uses Gst::setGST_OBJID()
     * @uses Gst::setExternaltypefilter()
     * @uses Gst::setEXTERNALID()
     * @param string $gST_OBJID
     * @param string $externaltypefilter
     * @param \StructType\EXTERNALID[] $eXTERNALID
     */
    public function __construct($gST_OBJID = null, $externaltypefilter = null, array $eXTERNALID = array())
    {
        $this
            ->setGST_OBJID($gST_OBJID)
            ->setExternaltypefilter($externaltypefilter)
            ->setEXTERNALID($eXTERNALID);
    }
    /**
     * Get GST_OBJID value
     * @return string
     */
    public function getGST_OBJID()
    {
        return $this->{'GST-OBJID'};
    }
    /**
     * Set GST_OBJID value
     * @param string $gST_OBJID
     * @return \StructType\Gst
     */
    public function setGST_OBJID($gST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gST_OBJID) && !is_string($gST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gST_OBJID, true), gettype($gST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gST_OBJID) && !preg_match('/([0-9])*/', $gST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gST_OBJID, true)), __LINE__);
        }
        $this->GST_OBJID = $this->{'GST-OBJID'} = $gST_OBJID;
        return $this;
    }
    /**
     * Get externaltypefilter value
     * @return string
     */
    public function getExternaltypefilter()
    {
        return $this->externaltypefilter;
    }
    /**
     * Set externaltypefilter value
     * @param string $externaltypefilter
     * @return \StructType\Gst
     */
    public function setExternaltypefilter($externaltypefilter = null)
    {
        // validation for constraint: string
        if (!is_null($externaltypefilter) && !is_string($externaltypefilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externaltypefilter, true), gettype($externaltypefilter)), __LINE__);
        }
        $this->externaltypefilter = $externaltypefilter;
        return $this;
    }
    /**
     * Get EXTERNALID value
     * @return \StructType\EXTERNALID[]|null
     */
    public function getEXTERNALID()
    {
        return $this->EXTERNALID;
    }
    /**
     * This method is responsible for validating the values passed to the setEXTERNALID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEXTERNALID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gstEXTERNALIDItem) {
            // validation for constraint: itemType
            if (!$gstEXTERNALIDItem instanceof \StructType\EXTERNALID) {
                $invalidValues[] = is_object($gstEXTERNALIDItem) ? get_class($gstEXTERNALIDItem) : sprintf('%s(%s)', gettype($gstEXTERNALIDItem), var_export($gstEXTERNALIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID[] $eXTERNALID
     * @return \StructType\Gst
     */
    public function setEXTERNALID(array $eXTERNALID = array())
    {
        // validation for constraint: array
        if ('' !== ($eXTERNALIDArrayErrorMessage = self::validateEXTERNALIDForArrayConstraintsFromSetEXTERNALID($eXTERNALID))) {
            throw new \InvalidArgumentException($eXTERNALIDArrayErrorMessage, __LINE__);
        }
        $this->EXTERNALID = $eXTERNALID;
        return $this;
    }
    /**
     * Add item to EXTERNALID value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTERNALID $item
     * @return \StructType\Gst
     */
    public function addToEXTERNALID(\StructType\EXTERNALID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EXTERNALID) {
            throw new \InvalidArgumentException(sprintf('The EXTERNALID property can only contain items of type \StructType\EXTERNALID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EXTERNALID[] = $item;
        return $this;
    }
}
