<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftvoucherSearch StructType
 * @subpackage Structs
 */
class GiftvoucherSearch extends AbstractStructBase
{
    /**
     * The selldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $selldate;
    /**
     * The selldateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $selldateto;
    /**
     * The giftVoucherNoFrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $giftVoucherNoFrom;
    /**
     * The giftvouchernoto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $giftvouchernoto;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externalreference;
    /**
     * The blocked
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $blocked;
    /**
     * The all
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $all;
    /**
     * The open
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $open;
    /**
     * The holderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $holderName;
    /**
     * The redemptiondate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $redemptiondate;
    /**
     * The redemptiondateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $redemptiondateto;
    /**
     * The hotelsell
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hotelsell;
    /**
     * The hotelredeem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hotelredeem;
    /**
     * Constructor method for GiftvoucherSearch
     * @uses GiftvoucherSearch::setSelldate()
     * @uses GiftvoucherSearch::setSelldateto()
     * @uses GiftvoucherSearch::setGiftVoucherNoFrom()
     * @uses GiftvoucherSearch::setGiftvouchernoto()
     * @uses GiftvoucherSearch::setExternalreference()
     * @uses GiftvoucherSearch::setBlocked()
     * @uses GiftvoucherSearch::setAll()
     * @uses GiftvoucherSearch::setOpen()
     * @uses GiftvoucherSearch::setHolderName()
     * @uses GiftvoucherSearch::setRedemptiondate()
     * @uses GiftvoucherSearch::setRedemptiondateto()
     * @uses GiftvoucherSearch::setHotelsell()
     * @uses GiftvoucherSearch::setHotelredeem()
     * @param string $selldate
     * @param string $selldateto
     * @param string $giftVoucherNoFrom
     * @param string $giftvouchernoto
     * @param string $externalreference
     * @param string $blocked
     * @param string $all
     * @param string $open
     * @param string $holderName
     * @param string $redemptiondate
     * @param string $redemptiondateto
     * @param string $hotelsell
     * @param string $hotelredeem
     */
    public function __construct($selldate = null, $selldateto = null, $giftVoucherNoFrom = null, $giftvouchernoto = null, $externalreference = null, $blocked = null, $all = null, $open = null, $holderName = null, $redemptiondate = null, $redemptiondateto = null, $hotelsell = null, $hotelredeem = null)
    {
        $this
            ->setSelldate($selldate)
            ->setSelldateto($selldateto)
            ->setGiftVoucherNoFrom($giftVoucherNoFrom)
            ->setGiftvouchernoto($giftvouchernoto)
            ->setExternalreference($externalreference)
            ->setBlocked($blocked)
            ->setAll($all)
            ->setOpen($open)
            ->setHolderName($holderName)
            ->setRedemptiondate($redemptiondate)
            ->setRedemptiondateto($redemptiondateto)
            ->setHotelsell($hotelsell)
            ->setHotelredeem($hotelredeem);
    }
    /**
     * Get selldate value
     * @return string|null
     */
    public function getSelldate()
    {
        return $this->selldate;
    }
    /**
     * Set selldate value
     * @param string $selldate
     * @return \StructType\GiftvoucherSearch
     */
    public function setSelldate($selldate = null)
    {
        // validation for constraint: string
        if (!is_null($selldate) && !is_string($selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selldate, true), gettype($selldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($selldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($selldate, true)), __LINE__);
        }
        $this->selldate = $selldate;
        return $this;
    }
    /**
     * Get selldateto value
     * @return string|null
     */
    public function getSelldateto()
    {
        return $this->selldateto;
    }
    /**
     * Set selldateto value
     * @param string $selldateto
     * @return \StructType\GiftvoucherSearch
     */
    public function setSelldateto($selldateto = null)
    {
        // validation for constraint: string
        if (!is_null($selldateto) && !is_string($selldateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selldateto, true), gettype($selldateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($selldateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $selldateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($selldateto, true)), __LINE__);
        }
        $this->selldateto = $selldateto;
        return $this;
    }
    /**
     * Get giftVoucherNoFrom value
     * @return string|null
     */
    public function getGiftVoucherNoFrom()
    {
        return $this->giftVoucherNoFrom;
    }
    /**
     * Set giftVoucherNoFrom value
     * @param string $giftVoucherNoFrom
     * @return \StructType\GiftvoucherSearch
     */
    public function setGiftVoucherNoFrom($giftVoucherNoFrom = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNoFrom) && !is_string($giftVoucherNoFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNoFrom, true), gettype($giftVoucherNoFrom)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($giftVoucherNoFrom) && !preg_match('/([-+]){0,1}([0-9])*/', $giftVoucherNoFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($giftVoucherNoFrom, true)), __LINE__);
        }
        $this->giftVoucherNoFrom = $giftVoucherNoFrom;
        return $this;
    }
    /**
     * Get giftvouchernoto value
     * @return string|null
     */
    public function getGiftvouchernoto()
    {
        return $this->giftvouchernoto;
    }
    /**
     * Set giftvouchernoto value
     * @param string $giftvouchernoto
     * @return \StructType\GiftvoucherSearch
     */
    public function setGiftvouchernoto($giftvouchernoto = null)
    {
        // validation for constraint: string
        if (!is_null($giftvouchernoto) && !is_string($giftvouchernoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftvouchernoto, true), gettype($giftvouchernoto)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($giftvouchernoto) && !preg_match('/([-+]){0,1}([0-9])*/', $giftvouchernoto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($giftvouchernoto, true)), __LINE__);
        }
        $this->giftvouchernoto = $giftvouchernoto;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string|null
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\GiftvoucherSearch
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get blocked value
     * @return string|null
     */
    public function getBlocked()
    {
        return $this->blocked;
    }
    /**
     * Set blocked value
     * @param string $blocked
     * @return \StructType\GiftvoucherSearch
     */
    public function setBlocked($blocked = null)
    {
        // validation for constraint: string
        if (!is_null($blocked) && !is_string($blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blocked, true), gettype($blocked)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($blocked) && !preg_match('/([-+]){0,1}([0-9])*/', $blocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($blocked, true)), __LINE__);
        }
        $this->blocked = $blocked;
        return $this;
    }
    /**
     * Get all value
     * @return string|null
     */
    public function getAll()
    {
        return $this->all;
    }
    /**
     * Set all value
     * @param string $all
     * @return \StructType\GiftvoucherSearch
     */
    public function setAll($all = null)
    {
        // validation for constraint: string
        if (!is_null($all) && !is_string($all)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($all, true), gettype($all)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($all) && !preg_match('/([-+]){0,1}([0-9])*/', $all)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($all, true)), __LINE__);
        }
        $this->all = $all;
        return $this;
    }
    /**
     * Get open value
     * @return string|null
     */
    public function getOpen()
    {
        return $this->open;
    }
    /**
     * Set open value
     * @param string $open
     * @return \StructType\GiftvoucherSearch
     */
    public function setOpen($open = null)
    {
        // validation for constraint: string
        if (!is_null($open) && !is_string($open)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($open, true), gettype($open)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($open) && !preg_match('/([-+]){0,1}([0-9])*/', $open)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($open, true)), __LINE__);
        }
        $this->open = $open;
        return $this;
    }
    /**
     * Get holderName value
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \StructType\GiftvoucherSearch
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holderName, true), gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Get redemptiondate value
     * @return string|null
     */
    public function getRedemptiondate()
    {
        return $this->redemptiondate;
    }
    /**
     * Set redemptiondate value
     * @param string $redemptiondate
     * @return \StructType\GiftvoucherSearch
     */
    public function setRedemptiondate($redemptiondate = null)
    {
        // validation for constraint: string
        if (!is_null($redemptiondate) && !is_string($redemptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redemptiondate, true), gettype($redemptiondate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($redemptiondate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $redemptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($redemptiondate, true)), __LINE__);
        }
        $this->redemptiondate = $redemptiondate;
        return $this;
    }
    /**
     * Get redemptiondateto value
     * @return string|null
     */
    public function getRedemptiondateto()
    {
        return $this->redemptiondateto;
    }
    /**
     * Set redemptiondateto value
     * @param string $redemptiondateto
     * @return \StructType\GiftvoucherSearch
     */
    public function setRedemptiondateto($redemptiondateto = null)
    {
        // validation for constraint: string
        if (!is_null($redemptiondateto) && !is_string($redemptiondateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redemptiondateto, true), gettype($redemptiondateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($redemptiondateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $redemptiondateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($redemptiondateto, true)), __LINE__);
        }
        $this->redemptiondateto = $redemptiondateto;
        return $this;
    }
    /**
     * Get hotelsell value
     * @return string|null
     */
    public function getHotelsell()
    {
        return $this->hotelsell;
    }
    /**
     * Set hotelsell value
     * @param string $hotelsell
     * @return \StructType\GiftvoucherSearch
     */
    public function setHotelsell($hotelsell = null)
    {
        // validation for constraint: string
        if (!is_null($hotelsell) && !is_string($hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelsell, true), gettype($hotelsell)), __LINE__);
        }
        $this->hotelsell = $hotelsell;
        return $this;
    }
    /**
     * Get hotelredeem value
     * @return string|null
     */
    public function getHotelredeem()
    {
        return $this->hotelredeem;
    }
    /**
     * Set hotelredeem value
     * @param string $hotelredeem
     * @return \StructType\GiftvoucherSearch
     */
    public function setHotelredeem($hotelredeem = null)
    {
        // validation for constraint: string
        if (!is_null($hotelredeem) && !is_string($hotelredeem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelredeem, true), gettype($hotelredeem)), __LINE__);
        }
        $this->hotelredeem = $hotelredeem;
        return $this;
    }
}
