<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Giftvoucher StructType
 * @subpackage Structs
 */
class Giftvoucher extends AbstractStructBase
{
    /**
     * The objid
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $objid;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $number;
    /**
     * The externalreference
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $externalreference;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $amount;
    /**
     * The selldate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $selldate;
    /**
     * The hotelsell
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelsell;
    /**
     * The expirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $expirydate;
    /**
     * The redemptiondate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $redemptiondate;
    /**
     * The hotelredeem
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $hotelredeem;
    /**
     * The GiftvoucherHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GiftvoucherHolder[]
     */
    public $GiftvoucherHolder;
    /**
     * Constructor method for Giftvoucher
     * @uses Giftvoucher::setObjid()
     * @uses Giftvoucher::setStatus()
     * @uses Giftvoucher::setNumber()
     * @uses Giftvoucher::setExternalreference()
     * @uses Giftvoucher::setAmount()
     * @uses Giftvoucher::setSelldate()
     * @uses Giftvoucher::setHotelsell()
     * @uses Giftvoucher::setExpirydate()
     * @uses Giftvoucher::setRedemptiondate()
     * @uses Giftvoucher::setHotelredeem()
     * @uses Giftvoucher::setGiftvoucherHolder()
     * @param string $objid
     * @param string $status
     * @param string $number
     * @param string $externalreference
     * @param string $amount
     * @param string $selldate
     * @param string $hotelsell
     * @param string $expirydate
     * @param string $redemptiondate
     * @param string $hotelredeem
     * @param \StructType\GiftvoucherHolder[] $giftvoucherHolder
     */
    public function __construct($objid = null, $status = null, $number = null, $externalreference = null, $amount = null, $selldate = null, $hotelsell = null, $expirydate = null, $redemptiondate = null, $hotelredeem = null, array $giftvoucherHolder = array())
    {
        $this
            ->setObjid($objid)
            ->setStatus($status)
            ->setNumber($number)
            ->setExternalreference($externalreference)
            ->setAmount($amount)
            ->setSelldate($selldate)
            ->setHotelsell($hotelsell)
            ->setExpirydate($expirydate)
            ->setRedemptiondate($redemptiondate)
            ->setHotelredeem($hotelredeem)
            ->setGiftvoucherHolder($giftvoucherHolder);
    }
    /**
     * Get objid value
     * @return string
     */
    public function getObjid()
    {
        return $this->objid;
    }
    /**
     * Set objid value
     * @param string $objid
     * @return \StructType\Giftvoucher
     */
    public function setObjid($objid = null)
    {
        // validation for constraint: string
        if (!is_null($objid) && !is_string($objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objid, true), gettype($objid)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($objid) && !preg_match('/([0-9])*/', $objid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($objid, true)), __LINE__);
        }
        $this->objid = $objid;
        return $this;
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\Giftvoucher
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Giftvoucher
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($number) && !preg_match('/([-+]){0,1}([0-9])*/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($number, true)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get externalreference value
     * @return string
     */
    public function getExternalreference()
    {
        return $this->externalreference;
    }
    /**
     * Set externalreference value
     * @param string $externalreference
     * @return \StructType\Giftvoucher
     */
    public function setExternalreference($externalreference = null)
    {
        // validation for constraint: string
        if (!is_null($externalreference) && !is_string($externalreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalreference, true), gettype($externalreference)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($externalreference) && mb_strlen($externalreference) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($externalreference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($externalreference) && mb_strlen($externalreference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($externalreference)), __LINE__);
        }
        $this->externalreference = $externalreference;
        return $this;
    }
    /**
     * Get amount value
     * @return string
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\Giftvoucher
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($amount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($amount, true)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get selldate value
     * @return string
     */
    public function getSelldate()
    {
        return $this->selldate;
    }
    /**
     * Set selldate value
     * @param string $selldate
     * @return \StructType\Giftvoucher
     */
    public function setSelldate($selldate = null)
    {
        // validation for constraint: string
        if (!is_null($selldate) && !is_string($selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selldate, true), gettype($selldate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($selldate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $selldate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($selldate, true)), __LINE__);
        }
        $this->selldate = $selldate;
        return $this;
    }
    /**
     * Get hotelsell value
     * @return string
     */
    public function getHotelsell()
    {
        return $this->hotelsell;
    }
    /**
     * Set hotelsell value
     * @param string $hotelsell
     * @return \StructType\Giftvoucher
     */
    public function setHotelsell($hotelsell = null)
    {
        // validation for constraint: string
        if (!is_null($hotelsell) && !is_string($hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelsell, true), gettype($hotelsell)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelsell) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelsell)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelsell, true)), __LINE__);
        }
        $this->hotelsell = $hotelsell;
        return $this;
    }
    /**
     * Get expirydate value
     * @return string
     */
    public function getExpirydate()
    {
        return $this->expirydate;
    }
    /**
     * Set expirydate value
     * @param string $expirydate
     * @return \StructType\Giftvoucher
     */
    public function setExpirydate($expirydate = null)
    {
        // validation for constraint: string
        if (!is_null($expirydate) && !is_string($expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirydate, true), gettype($expirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($expirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $expirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($expirydate, true)), __LINE__);
        }
        $this->expirydate = $expirydate;
        return $this;
    }
    /**
     * Get redemptiondate value
     * @return string
     */
    public function getRedemptiondate()
    {
        return $this->redemptiondate;
    }
    /**
     * Set redemptiondate value
     * @param string $redemptiondate
     * @return \StructType\Giftvoucher
     */
    public function setRedemptiondate($redemptiondate = null)
    {
        // validation for constraint: string
        if (!is_null($redemptiondate) && !is_string($redemptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redemptiondate, true), gettype($redemptiondate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($redemptiondate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $redemptiondate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($redemptiondate, true)), __LINE__);
        }
        $this->redemptiondate = $redemptiondate;
        return $this;
    }
    /**
     * Get hotelredeem value
     * @return string
     */
    public function getHotelredeem()
    {
        return $this->hotelredeem;
    }
    /**
     * Set hotelredeem value
     * @param string $hotelredeem
     * @return \StructType\Giftvoucher
     */
    public function setHotelredeem($hotelredeem = null)
    {
        // validation for constraint: string
        if (!is_null($hotelredeem) && !is_string($hotelredeem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelredeem, true), gettype($hotelredeem)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($hotelredeem) && !preg_match('/([-+]){0,1}([0-9])*/', $hotelredeem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($hotelredeem, true)), __LINE__);
        }
        $this->hotelredeem = $hotelredeem;
        return $this;
    }
    /**
     * Get GiftvoucherHolder value
     * @return \StructType\GiftvoucherHolder[]|null
     */
    public function getGiftvoucherHolder()
    {
        return $this->GiftvoucherHolder;
    }
    /**
     * This method is responsible for validating the values passed to the setGiftvoucherHolder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGiftvoucherHolder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGiftvoucherHolderForArrayConstraintsFromSetGiftvoucherHolder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $giftvoucherGiftvoucherHolderItem) {
            // validation for constraint: itemType
            if (!$giftvoucherGiftvoucherHolderItem instanceof \StructType\GiftvoucherHolder) {
                $invalidValues[] = is_object($giftvoucherGiftvoucherHolderItem) ? get_class($giftvoucherGiftvoucherHolderItem) : sprintf('%s(%s)', gettype($giftvoucherGiftvoucherHolderItem), var_export($giftvoucherGiftvoucherHolderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GiftvoucherHolder property can only contain items of type \StructType\GiftvoucherHolder, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GiftvoucherHolder value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftvoucherHolder[] $giftvoucherHolder
     * @return \StructType\Giftvoucher
     */
    public function setGiftvoucherHolder(array $giftvoucherHolder = array())
    {
        // validation for constraint: array
        if ('' !== ($giftvoucherHolderArrayErrorMessage = self::validateGiftvoucherHolderForArrayConstraintsFromSetGiftvoucherHolder($giftvoucherHolder))) {
            throw new \InvalidArgumentException($giftvoucherHolderArrayErrorMessage, __LINE__);
        }
        $this->GiftvoucherHolder = $giftvoucherHolder;
        return $this;
    }
    /**
     * Add item to GiftvoucherHolder value
     * @throws \InvalidArgumentException
     * @param \StructType\GiftvoucherHolder $item
     * @return \StructType\Giftvoucher
     */
    public function addToGiftvoucherHolder(\StructType\GiftvoucherHolder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GiftvoucherHolder) {
            throw new \InvalidArgumentException(sprintf('The GiftvoucherHolder property can only contain items of type \StructType\GiftvoucherHolder, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GiftvoucherHolder[] = $item;
        return $this;
    }
}
