<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceMappingRequest StructType
 * @subpackage Structs
 */
class GetServiceMappingRequest extends AbstractStructBase
{
    /**
     * The Authentication
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Authentication
     */
    public $Authentication;
    /**
     * The ServiceSearch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceSearch
     */
    public $ServiceSearch;
    /**
     * The TransactionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * Constructor method for GetServiceMappingRequest
     * @uses GetServiceMappingRequest::setAuthentication()
     * @uses GetServiceMappingRequest::setServiceSearch()
     * @uses GetServiceMappingRequest::setTransactionID()
     * @param \StructType\Authentication $authentication
     * @param \StructType\ServiceSearch $serviceSearch
     * @param string $transactionID
     */
    public function __construct(\StructType\Authentication $authentication = null, \StructType\ServiceSearch $serviceSearch = null, $transactionID = null)
    {
        $this
            ->setAuthentication($authentication)
            ->setServiceSearch($serviceSearch)
            ->setTransactionID($transactionID);
    }
    /**
     * Get Authentication value
     * @return \StructType\Authentication
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \StructType\Authentication $authentication
     * @return \StructType\GetServiceMappingRequest
     */
    public function setAuthentication(\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Get ServiceSearch value
     * @return \StructType\ServiceSearch
     */
    public function getServiceSearch()
    {
        return $this->ServiceSearch;
    }
    /**
     * Set ServiceSearch value
     * @param \StructType\ServiceSearch $serviceSearch
     * @return \StructType\GetServiceMappingRequest
     */
    public function setServiceSearch(\StructType\ServiceSearch $serviceSearch = null)
    {
        $this->ServiceSearch = $serviceSearch;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \StructType\GetServiceMappingRequest
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
}
