<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUEST-ID StructType
 * @subpackage Structs
 */
class GUEST_ID extends AbstractStructBase
{
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The validfrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $validfrom;
    /**
     * The validuntil
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $validuntil;
    /**
     * Constructor method for GUEST-ID
     * @uses GUEST_ID::setType()
     * @uses GUEST_ID::setNumber()
     * @uses GUEST_ID::setValidfrom()
     * @uses GUEST_ID::setValiduntil()
     * @param string $type
     * @param string $number
     * @param string $validfrom
     * @param string $validuntil
     */
    public function __construct($type = null, $number = null, $validfrom = null, $validuntil = null)
    {
        $this
            ->setType($type)
            ->setNumber($number)
            ->setValidfrom($validfrom)
            ->setValiduntil($validuntil);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GUEST_ID
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type) && mb_strlen($type) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($type) && mb_strlen($type) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\GUEST_ID
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get validfrom value
     * @return string
     */
    public function getValidfrom()
    {
        return $this->validfrom;
    }
    /**
     * Set validfrom value
     * @param string $validfrom
     * @return \StructType\GUEST_ID
     */
    public function setValidfrom($validfrom = null)
    {
        // validation for constraint: string
        if (!is_null($validfrom) && !is_string($validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validfrom, true), gettype($validfrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($validfrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $validfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($validfrom, true)), __LINE__);
        }
        $this->validfrom = $validfrom;
        return $this;
    }
    /**
     * Get validuntil value
     * @return string
     */
    public function getValiduntil()
    {
        return $this->validuntil;
    }
    /**
     * Set validuntil value
     * @param string $validuntil
     * @return \StructType\GUEST_ID
     */
    public function setValiduntil($validuntil = null)
    {
        // validation for constraint: string
        if (!is_null($validuntil) && !is_string($validuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validuntil, true), gettype($validuntil)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($validuntil) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $validuntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($validuntil, true)), __LINE__);
        }
        $this->validuntil = $validuntil;
        return $this;
    }
}
