<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GUEST StructType
 * @subpackage Structs
 */
class GUEST extends AbstractStructBase
{
    /**
     * The GUEST_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_OBJID;
    /**
     * The GUEST_CENTRALID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $GUEST_CENTRALID;
    /**
     * The lastnamefirstname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastnamefirstname;
    /**
     * The creditlimitcl
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $creditlimitcl;
    /**
     * The lastName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $lastName;
    /**
     * The firstName
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $firstName;
    /**
     * The matchcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $matchcode;
    /**
     * The guestType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $guestType;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $street;
    /**
     * The pobox
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $pobox;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The identificationNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $identificationNo;
    /**
     * The phone1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone1;
    /**
     * The phone2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone2;
    /**
     * The mobile1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $mobile1;
    /**
     * The email1
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email1;
    /**
     * The address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address;
    /**
     * The language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $language;
    /**
     * The salutcorrespond
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $salutcorrespond;
    /**
     * The ratesegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $ratesegment;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $documenttype;
    /**
     * The documentnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 44
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $documentnumber;
    /**
     * The subcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subcountry;
    /**
     * The subsubcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subsubcountry;
    /**
     * The birthdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $birthdate;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $email;
    /**
     * The iata
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $iata;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $fax;
    /**
     * The marketsegment
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $marketsegment;
    /**
     * The vip
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip;
    /**
     * The vip2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $vip2;
    /**
     * The guestHotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestHotel;
    /**
     * The guestNo
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $guestNo;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $phone;
    /**
     * The languageiso639_1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $languageiso639_1;
    /**
     * The NEWSLETTER_SUBSCRIPTION
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public $NEWSLETTER_SUBSCRIPTION;
    /**
     * The EXTRA_INFORMATIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\EXTRA_INFORMATIONS
     */
    public $EXTRA_INFORMATIONS;
    /**
     * The LOYALTY
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LOYALTY
     */
    public $LOYALTY;
    /**
     * The GUEST_IDENTIFICATIONS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GUEST_IDENTIFICATIONS
     */
    public $GUEST_IDENTIFICATIONS;
    /**
     * The COMMENTS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\COMMENTS_1
     */
    public $COMMENTS;
    /**
     * The LOYALTY_CARD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\LOYALTY_CARD
     */
    public $LOYALTY_CARD;
    /**
     * The LOYALTY_CARD_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LOYALTY_CARD_OBJID;
    /**
     * The CARD
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CARD
     */
    public $CARD;
    /**
     * The location2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $location2;
    /**
     * The savecontactdata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $savecontactdata;
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The INVOICE_HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INVOICE_HOLDER
     */
    public $INVOICE_HOLDER;
    /**
     * The INVOICE_ADDRESS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INVOICE_ADDRESS
     */
    public $INVOICE_ADDRESS;
    /**
     * The general
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $general;
    /**
     * The housekeeping
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $housekeeping;
    /**
     * The kitchen
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kitchen;
    /**
     * The frontoffice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $frontoffice;
    /**
     * The sales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sales;
    /**
     * The event
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $event;
    /**
     * The debitor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $debitor;
    /**
     * The restaurant
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $restaurant;
    /**
     * The checkin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $checkin;
    /**
     * The checkout
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $checkout;
    /**
     * The interface
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $interface;
    /**
     * The central
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $central;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $contact;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 60
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The mobile2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $mobile2;
    /**
     * The email2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $email2;
    /**
     * The keycardaccesscode
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $keycardaccesscode;
    /**
     * The salutation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The profession
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $profession;
    /**
     * The delete
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $delete;
    /**
     * The industryfield
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $industryfield;
    /**
     * The salescategory
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $salescategory;
    /**
     * The GuestIdentifcation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestIdentifcation[]
     */
    public $GuestIdentifcation;
    /**
     * The GuestAdditional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GuestAdditional
     */
    public $GuestAdditional;
    /**
     * The discountgroup
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $discountgroup;
    /**
     * The emailfilter
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 18
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $emailfilter;
    /**
     * The emailsubscriptionhotel
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $emailsubscriptionhotel;
    /**
     * The emailsubscriptionpartner
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $emailsubscriptionpartner;
    /**
     * The GuestIdentification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestIdentification[]
     */
    public $GuestIdentification;
    /**
     * The EXTRA_INFORMATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EXTRA_INFORMATION[]
     */
    public $EXTRA_INFORMATION;
    /**
     * The region
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $region;
    /**
     * The nationality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $nationality;
    /**
     * The placeofbirth
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $placeofbirth;
    /**
     * The birthcountry
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 9
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $birthcountry;
    /**
     * The licenceplatenumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $licenceplatenumber;
    /**
     * The documentdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $documentdate;
    /**
     * The docissuingcountry
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $docissuingcountry;
    /**
     * The docissuedat
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $docissuedat;
    /**
     * The docexpirydate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $docexpirydate;
    /**
     * The taxnumber
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $taxnumber;
    /**
     * The taxnumber2
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $taxnumber2;
    /**
     * The taxnumber3
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 0
     * @var string
     */
    public $taxnumber3;
    /**
     * The subjecttotax
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $subjecttotax;
    /**
     * The GUEST_IDENTIFICATION
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GUEST_IDENTIFICATION[]
     */
    public $GUEST_IDENTIFICATION;
    /**
     * The MOTHER_COMPANY
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MOTHER_COMPANY[]
     */
    public $MOTHER_COMPANY;
    /**
     * Constructor method for GUEST
     * @uses GUEST::setGUEST_OBJID()
     * @uses GUEST::setGUEST_CENTRALID()
     * @uses GUEST::setLastnamefirstname()
     * @uses GUEST::setCreditlimitcl()
     * @uses GUEST::setLastName()
     * @uses GUEST::setFirstName()
     * @uses GUEST::setMatchcode()
     * @uses GUEST::setGuestType()
     * @uses GUEST::setStreet()
     * @uses GUEST::setPobox()
     * @uses GUEST::setCountry()
     * @uses GUEST::setPostcode()
     * @uses GUEST::setCity()
     * @uses GUEST::setIdentificationNo()
     * @uses GUEST::setPhone1()
     * @uses GUEST::setPhone2()
     * @uses GUEST::setMobile1()
     * @uses GUEST::setEmail1()
     * @uses GUEST::setAddress()
     * @uses GUEST::setLanguage()
     * @uses GUEST::setSalutcorrespond()
     * @uses GUEST::setRatesegment()
     * @uses GUEST::setDocumenttype()
     * @uses GUEST::setDocumentnumber()
     * @uses GUEST::setSubcountry()
     * @uses GUEST::setSubsubcountry()
     * @uses GUEST::setBirthdate()
     * @uses GUEST::setEmail()
     * @uses GUEST::setIata()
     * @uses GUEST::setFax()
     * @uses GUEST::setMarketsegment()
     * @uses GUEST::setVip()
     * @uses GUEST::setVip2()
     * @uses GUEST::setGuestHotel()
     * @uses GUEST::setGuestNo()
     * @uses GUEST::setPhone()
     * @uses GUEST::setLanguageiso639_1()
     * @uses GUEST::setNEWSLETTER_SUBSCRIPTION()
     * @uses GUEST::setEXTRA_INFORMATIONS()
     * @uses GUEST::setLOYALTY()
     * @uses GUEST::setGUEST_IDENTIFICATIONS()
     * @uses GUEST::setCOMMENTS()
     * @uses GUEST::setLOYALTY_CARD()
     * @uses GUEST::setLOYALTY_CARD_OBJID()
     * @uses GUEST::setCARD()
     * @uses GUEST::setLocation2()
     * @uses GUEST::setSavecontactdata()
     * @uses GUEST::setServicetype()
     * @uses GUEST::setService()
     * @uses GUEST::setINVOICE_HOLDER()
     * @uses GUEST::setINVOICE_ADDRESS()
     * @uses GUEST::setGeneral()
     * @uses GUEST::setHousekeeping()
     * @uses GUEST::setKitchen()
     * @uses GUEST::setFrontoffice()
     * @uses GUEST::setSales()
     * @uses GUEST::setEvent()
     * @uses GUEST::setDebitor()
     * @uses GUEST::setRestaurant()
     * @uses GUEST::setCheckin()
     * @uses GUEST::setCheckout()
     * @uses GUEST::setInterface()
     * @uses GUEST::setCentral()
     * @uses GUEST::setContact()
     * @uses GUEST::setNote()
     * @uses GUEST::setMobile2()
     * @uses GUEST::setEmail2()
     * @uses GUEST::setKeycardaccesscode()
     * @uses GUEST::setSalutation()
     * @uses GUEST::setProfession()
     * @uses GUEST::setDelete()
     * @uses GUEST::setIndustryfield()
     * @uses GUEST::setSalescategory()
     * @uses GUEST::setGuestIdentifcation()
     * @uses GUEST::setGuestAdditional()
     * @uses GUEST::setDiscountgroup()
     * @uses GUEST::setEmailfilter()
     * @uses GUEST::setEmailsubscriptionhotel()
     * @uses GUEST::setEmailsubscriptionpartner()
     * @uses GUEST::setGuestIdentification()
     * @uses GUEST::setEXTRA_INFORMATION()
     * @uses GUEST::setRegion()
     * @uses GUEST::setNationality()
     * @uses GUEST::setPlaceofbirth()
     * @uses GUEST::setBirthcountry()
     * @uses GUEST::setLicenceplatenumber()
     * @uses GUEST::setDocumentdate()
     * @uses GUEST::setDocissuingcountry()
     * @uses GUEST::setDocissuedat()
     * @uses GUEST::setDocexpirydate()
     * @uses GUEST::setTaxnumber()
     * @uses GUEST::setTaxnumber2()
     * @uses GUEST::setTaxnumber3()
     * @uses GUEST::setSubjecttotax()
     * @uses GUEST::setGUEST_IDENTIFICATION()
     * @uses GUEST::setMOTHER_COMPANY()
     * @param string $gUEST_OBJID
     * @param string $gUEST_CENTRALID
     * @param string $lastnamefirstname
     * @param string $creditlimitcl
     * @param string $lastName
     * @param string $firstName
     * @param string $matchcode
     * @param string $guestType
     * @param string $street
     * @param string $pobox
     * @param string $country
     * @param string $postcode
     * @param string $city
     * @param string $identificationNo
     * @param string $phone1
     * @param string $phone2
     * @param string $mobile1
     * @param string $email1
     * @param string $address
     * @param string $language
     * @param string $salutcorrespond
     * @param string $ratesegment
     * @param string $documenttype
     * @param string $documentnumber
     * @param string $subcountry
     * @param string $subsubcountry
     * @param string $birthdate
     * @param string $email
     * @param string $iata
     * @param string $fax
     * @param string $marketsegment
     * @param string $vip
     * @param string $vip2
     * @param string $guestHotel
     * @param string $guestNo
     * @param string $phone
     * @param string $languageiso639_1
     * @param \StructType\NEWSLETTER_SUBSCRIPTION $nEWSLETTER_SUBSCRIPTION
     * @param \StructType\EXTRA_INFORMATIONS $eXTRA_INFORMATIONS
     * @param \StructType\LOYALTY $lOYALTY
     * @param \StructType\GUEST_IDENTIFICATIONS $gUEST_IDENTIFICATIONS
     * @param \StructType\COMMENTS_1 $cOMMENTS
     * @param \StructType\LOYALTY_CARD $lOYALTY_CARD
     * @param string $lOYALTY_CARD_OBJID
     * @param \StructType\CARD $cARD
     * @param string $location2
     * @param string $savecontactdata
     * @param string $servicetype
     * @param string $service
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @param \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS
     * @param string $general
     * @param string $housekeeping
     * @param string $kitchen
     * @param string $frontoffice
     * @param string $sales
     * @param string $event
     * @param string $debitor
     * @param string $restaurant
     * @param string $checkin
     * @param string $checkout
     * @param string $interface
     * @param string $central
     * @param string $contact
     * @param string $note
     * @param string $mobile2
     * @param string $email2
     * @param string $keycardaccesscode
     * @param string $salutation
     * @param string $profession
     * @param string $delete
     * @param string $industryfield
     * @param string $salescategory
     * @param \StructType\GuestIdentifcation[] $guestIdentifcation
     * @param \StructType\GuestAdditional $guestAdditional
     * @param string $discountgroup
     * @param string $emailfilter
     * @param string $emailsubscriptionhotel
     * @param string $emailsubscriptionpartner
     * @param \StructType\GuestIdentification[] $guestIdentification
     * @param \StructType\EXTRA_INFORMATION[] $eXTRA_INFORMATION
     * @param string $region
     * @param string $nationality
     * @param string $placeofbirth
     * @param string $birthcountry
     * @param string $licenceplatenumber
     * @param string $documentdate
     * @param string $docissuingcountry
     * @param string $docissuedat
     * @param string $docexpirydate
     * @param string $taxnumber
     * @param string $taxnumber2
     * @param string $taxnumber3
     * @param string $subjecttotax
     * @param \StructType\GUEST_IDENTIFICATION[] $gUEST_IDENTIFICATION
     * @param \StructType\MOTHER_COMPANY[] $mOTHER_COMPANY
     */
    public function __construct($gUEST_OBJID = null, $gUEST_CENTRALID = null, $lastnamefirstname = null, $creditlimitcl = null, $lastName = null, $firstName = null, $matchcode = null, $guestType = null, $street = null, $pobox = null, $country = null, $postcode = null, $city = null, $identificationNo = null, $phone1 = null, $phone2 = null, $mobile1 = null, $email1 = null, $address = null, $language = null, $salutcorrespond = null, $ratesegment = null, $documenttype = null, $documentnumber = null, $subcountry = null, $subsubcountry = null, $birthdate = null, $email = null, $iata = null, $fax = null, $marketsegment = null, $vip = null, $vip2 = null, $guestHotel = null, $guestNo = null, $phone = null, $languageiso639_1 = null, \StructType\NEWSLETTER_SUBSCRIPTION $nEWSLETTER_SUBSCRIPTION = null, \StructType\EXTRA_INFORMATIONS $eXTRA_INFORMATIONS = null, \StructType\LOYALTY $lOYALTY = null, \StructType\GUEST_IDENTIFICATIONS $gUEST_IDENTIFICATIONS = null, \StructType\COMMENTS_1 $cOMMENTS = null, \StructType\LOYALTY_CARD $lOYALTY_CARD = null, $lOYALTY_CARD_OBJID = null, \StructType\CARD $cARD = null, $location2 = null, $savecontactdata = null, $servicetype = null, $service = null, \StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null, \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS = null, $general = null, $housekeeping = null, $kitchen = null, $frontoffice = null, $sales = null, $event = null, $debitor = null, $restaurant = null, $checkin = null, $checkout = null, $interface = null, $central = null, $contact = null, $note = null, $mobile2 = null, $email2 = null, $keycardaccesscode = null, $salutation = null, $profession = null, $delete = null, $industryfield = null, $salescategory = null, array $guestIdentifcation = array(), \StructType\GuestAdditional $guestAdditional = null, $discountgroup = null, $emailfilter = null, $emailsubscriptionhotel = null, $emailsubscriptionpartner = null, array $guestIdentification = array(), array $eXTRA_INFORMATION = array(), $region = null, $nationality = null, $placeofbirth = null, $birthcountry = null, $licenceplatenumber = null, $documentdate = null, $docissuingcountry = null, $docissuedat = null, $docexpirydate = null, $taxnumber = null, $taxnumber2 = null, $taxnumber3 = null, $subjecttotax = null, array $gUEST_IDENTIFICATION = array(), array $mOTHER_COMPANY = array())
    {
        $this
            ->setGUEST_OBJID($gUEST_OBJID)
            ->setGUEST_CENTRALID($gUEST_CENTRALID)
            ->setLastnamefirstname($lastnamefirstname)
            ->setCreditlimitcl($creditlimitcl)
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setMatchcode($matchcode)
            ->setGuestType($guestType)
            ->setStreet($street)
            ->setPobox($pobox)
            ->setCountry($country)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setIdentificationNo($identificationNo)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setMobile1($mobile1)
            ->setEmail1($email1)
            ->setAddress($address)
            ->setLanguage($language)
            ->setSalutcorrespond($salutcorrespond)
            ->setRatesegment($ratesegment)
            ->setDocumenttype($documenttype)
            ->setDocumentnumber($documentnumber)
            ->setSubcountry($subcountry)
            ->setSubsubcountry($subsubcountry)
            ->setBirthdate($birthdate)
            ->setEmail($email)
            ->setIata($iata)
            ->setFax($fax)
            ->setMarketsegment($marketsegment)
            ->setVip($vip)
            ->setVip2($vip2)
            ->setGuestHotel($guestHotel)
            ->setGuestNo($guestNo)
            ->setPhone($phone)
            ->setLanguageiso639_1($languageiso639_1)
            ->setNEWSLETTER_SUBSCRIPTION($nEWSLETTER_SUBSCRIPTION)
            ->setEXTRA_INFORMATIONS($eXTRA_INFORMATIONS)
            ->setLOYALTY($lOYALTY)
            ->setGUEST_IDENTIFICATIONS($gUEST_IDENTIFICATIONS)
            ->setCOMMENTS($cOMMENTS)
            ->setLOYALTY_CARD($lOYALTY_CARD)
            ->setLOYALTY_CARD_OBJID($lOYALTY_CARD_OBJID)
            ->setCARD($cARD)
            ->setLocation2($location2)
            ->setSavecontactdata($savecontactdata)
            ->setServicetype($servicetype)
            ->setService($service)
            ->setINVOICE_HOLDER($iNVOICE_HOLDER)
            ->setINVOICE_ADDRESS($iNVOICE_ADDRESS)
            ->setGeneral($general)
            ->setHousekeeping($housekeeping)
            ->setKitchen($kitchen)
            ->setFrontoffice($frontoffice)
            ->setSales($sales)
            ->setEvent($event)
            ->setDebitor($debitor)
            ->setRestaurant($restaurant)
            ->setCheckin($checkin)
            ->setCheckout($checkout)
            ->setInterface($interface)
            ->setCentral($central)
            ->setContact($contact)
            ->setNote($note)
            ->setMobile2($mobile2)
            ->setEmail2($email2)
            ->setKeycardaccesscode($keycardaccesscode)
            ->setSalutation($salutation)
            ->setProfession($profession)
            ->setDelete($delete)
            ->setIndustryfield($industryfield)
            ->setSalescategory($salescategory)
            ->setGuestIdentifcation($guestIdentifcation)
            ->setGuestAdditional($guestAdditional)
            ->setDiscountgroup($discountgroup)
            ->setEmailfilter($emailfilter)
            ->setEmailsubscriptionhotel($emailsubscriptionhotel)
            ->setEmailsubscriptionpartner($emailsubscriptionpartner)
            ->setGuestIdentification($guestIdentification)
            ->setEXTRA_INFORMATION($eXTRA_INFORMATION)
            ->setRegion($region)
            ->setNationality($nationality)
            ->setPlaceofbirth($placeofbirth)
            ->setBirthcountry($birthcountry)
            ->setLicenceplatenumber($licenceplatenumber)
            ->setDocumentdate($documentdate)
            ->setDocissuingcountry($docissuingcountry)
            ->setDocissuedat($docissuedat)
            ->setDocexpirydate($docexpirydate)
            ->setTaxnumber($taxnumber)
            ->setTaxnumber2($taxnumber2)
            ->setTaxnumber3($taxnumber3)
            ->setSubjecttotax($subjecttotax)
            ->setGUEST_IDENTIFICATION($gUEST_IDENTIFICATION)
            ->setMOTHER_COMPANY($mOTHER_COMPANY);
    }
    /**
     * Get GUEST_OBJID value
     * @return string
     */
    public function getGUEST_OBJID()
    {
        return $this->{'GUEST-OBJID'};
    }
    /**
     * Set GUEST_OBJID value
     * @param string $gUEST_OBJID
     * @return \StructType\GUEST
     */
    public function setGUEST_OBJID($gUEST_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_OBJID) && !is_string($gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_OBJID, true), gettype($gUEST_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_OBJID) && !preg_match('/([0-9])*/', $gUEST_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_OBJID, true)), __LINE__);
        }
        $this->GUEST_OBJID = $this->{'GUEST-OBJID'} = $gUEST_OBJID;
        return $this;
    }
    /**
     * Get GUEST_CENTRALID value
     * @return string
     */
    public function getGUEST_CENTRALID()
    {
        return $this->{'GUEST-CENTRALID'};
    }
    /**
     * Set GUEST_CENTRALID value
     * @param string $gUEST_CENTRALID
     * @return \StructType\GUEST
     */
    public function setGUEST_CENTRALID($gUEST_CENTRALID = null)
    {
        // validation for constraint: string
        if (!is_null($gUEST_CENTRALID) && !is_string($gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gUEST_CENTRALID, true), gettype($gUEST_CENTRALID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($gUEST_CENTRALID) && !preg_match('/([0-9])*/', $gUEST_CENTRALID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($gUEST_CENTRALID, true)), __LINE__);
        }
        $this->GUEST_CENTRALID = $this->{'GUEST-CENTRALID'} = $gUEST_CENTRALID;
        return $this;
    }
    /**
     * Get lastnamefirstname value
     * @return string
     */
    public function getLastnamefirstname()
    {
        return $this->lastnamefirstname;
    }
    /**
     * Set lastnamefirstname value
     * @param string $lastnamefirstname
     * @return \StructType\GUEST
     */
    public function setLastnamefirstname($lastnamefirstname = null)
    {
        // validation for constraint: string
        if (!is_null($lastnamefirstname) && !is_string($lastnamefirstname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastnamefirstname, true), gettype($lastnamefirstname)), __LINE__);
        }
        $this->lastnamefirstname = $lastnamefirstname;
        return $this;
    }
    /**
     * Get creditlimitcl value
     * @return string
     */
    public function getCreditlimitcl()
    {
        return $this->creditlimitcl;
    }
    /**
     * Set creditlimitcl value
     * @param string $creditlimitcl
     * @return \StructType\GUEST
     */
    public function setCreditlimitcl($creditlimitcl = null)
    {
        // validation for constraint: string
        if (!is_null($creditlimitcl) && !is_string($creditlimitcl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditlimitcl, true), gettype($creditlimitcl)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($creditlimitcl) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $creditlimitcl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($creditlimitcl, true)), __LINE__);
        }
        $this->creditlimitcl = $creditlimitcl;
        return $this;
    }
    /**
     * Get lastName value
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\GUEST
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\GUEST
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firstName) && mb_strlen($firstName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($firstName) && mb_strlen($firstName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get matchcode value
     * @return string
     */
    public function getMatchcode()
    {
        return $this->matchcode;
    }
    /**
     * Set matchcode value
     * @param string $matchcode
     * @return \StructType\GUEST
     */
    public function setMatchcode($matchcode = null)
    {
        // validation for constraint: string
        if (!is_null($matchcode) && !is_string($matchcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchcode, true), gettype($matchcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($matchcode) && mb_strlen($matchcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($matchcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($matchcode) && mb_strlen($matchcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($matchcode)), __LINE__);
        }
        $this->matchcode = $matchcode;
        return $this;
    }
    /**
     * Get guestType value
     * @return string
     */
    public function getGuestType()
    {
        return $this->guestType;
    }
    /**
     * Set guestType value
     * @param string $guestType
     * @return \StructType\GUEST
     */
    public function setGuestType($guestType = null)
    {
        // validation for constraint: string
        if (!is_null($guestType) && !is_string($guestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestType, true), gettype($guestType)), __LINE__);
        }
        $this->guestType = $guestType;
        return $this;
    }
    /**
     * Get street value
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\GUEST
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($street) && mb_strlen($street) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($street)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($street) && mb_strlen($street) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Get pobox value
     * @return string
     */
    public function getPobox()
    {
        return $this->pobox;
    }
    /**
     * Set pobox value
     * @param string $pobox
     * @return \StructType\GUEST
     */
    public function setPobox($pobox = null)
    {
        // validation for constraint: string
        if (!is_null($pobox) && !is_string($pobox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pobox, true), gettype($pobox)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($pobox) && mb_strlen($pobox) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($pobox)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($pobox) && mb_strlen($pobox) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($pobox)), __LINE__);
        }
        $this->pobox = $pobox;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GUEST
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \StructType\GUEST
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($postcode) && mb_strlen($postcode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($postcode) && mb_strlen($postcode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\GUEST
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($city) && mb_strlen($city) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($city)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($city) && mb_strlen($city) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get identificationNo value
     * @return string
     */
    public function getIdentificationNo()
    {
        return $this->identificationNo;
    }
    /**
     * Set identificationNo value
     * @param string $identificationNo
     * @return \StructType\GUEST
     */
    public function setIdentificationNo($identificationNo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationNo) && !is_string($identificationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationNo, true), gettype($identificationNo)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($identificationNo) && mb_strlen($identificationNo) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($identificationNo)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($identificationNo) && mb_strlen($identificationNo) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($identificationNo)), __LINE__);
        }
        $this->identificationNo = $identificationNo;
        return $this;
    }
    /**
     * Get phone1 value
     * @return string
     */
    public function getPhone1()
    {
        return $this->phone1;
    }
    /**
     * Set phone1 value
     * @param string $phone1
     * @return \StructType\GUEST
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone1) && mb_strlen($phone1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone1) && mb_strlen($phone1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone1)), __LINE__);
        }
        $this->phone1 = $phone1;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \StructType\GUEST
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone2) && mb_strlen($phone2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone2) && mb_strlen($phone2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get mobile1 value
     * @return string
     */
    public function getMobile1()
    {
        return $this->mobile1;
    }
    /**
     * Set mobile1 value
     * @param string $mobile1
     * @return \StructType\GUEST
     */
    public function setMobile1($mobile1 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile1) && !is_string($mobile1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile1, true), gettype($mobile1)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile1) && mb_strlen($mobile1) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile1) && mb_strlen($mobile1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile1)), __LINE__);
        }
        $this->mobile1 = $mobile1;
        return $this;
    }
    /**
     * Get email1 value
     * @return string
     */
    public function getEmail1()
    {
        return $this->email1;
    }
    /**
     * Set email1 value
     * @param string $email1
     * @return \StructType\GUEST
     */
    public function setEmail1($email1 = null)
    {
        // validation for constraint: string
        if (!is_null($email1) && !is_string($email1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email1, true), gettype($email1)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email1) && mb_strlen($email1) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email1)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email1) && mb_strlen($email1) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email1)), __LINE__);
        }
        $this->email1 = $email1;
        return $this;
    }
    /**
     * Get address value
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\GUEST
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get language value
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\GUEST
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get salutcorrespond value
     * @return string
     */
    public function getSalutcorrespond()
    {
        return $this->salutcorrespond;
    }
    /**
     * Set salutcorrespond value
     * @param string $salutcorrespond
     * @return \StructType\GUEST
     */
    public function setSalutcorrespond($salutcorrespond = null)
    {
        // validation for constraint: string
        if (!is_null($salutcorrespond) && !is_string($salutcorrespond)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutcorrespond, true), gettype($salutcorrespond)), __LINE__);
        }
        $this->salutcorrespond = $salutcorrespond;
        return $this;
    }
    /**
     * Get ratesegment value
     * @return string
     */
    public function getRatesegment()
    {
        return $this->ratesegment;
    }
    /**
     * Set ratesegment value
     * @param string $ratesegment
     * @return \StructType\GUEST
     */
    public function setRatesegment($ratesegment = null)
    {
        // validation for constraint: string
        if (!is_null($ratesegment) && !is_string($ratesegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratesegment, true), gettype($ratesegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($ratesegment) && mb_strlen($ratesegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($ratesegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($ratesegment) && mb_strlen($ratesegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($ratesegment)), __LINE__);
        }
        $this->ratesegment = $ratesegment;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \StructType\GUEST
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($documenttype) && mb_strlen($documenttype) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($documenttype)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documenttype) && mb_strlen($documenttype) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
    /**
     * Get documentnumber value
     * @return string
     */
    public function getDocumentnumber()
    {
        return $this->documentnumber;
    }
    /**
     * Set documentnumber value
     * @param string $documentnumber
     * @return \StructType\GUEST
     */
    public function setDocumentnumber($documentnumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentnumber) && !is_string($documentnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentnumber, true), gettype($documentnumber)), __LINE__);
        }
        // validation for constraint: maxLength(44)
        if (!is_null($documentnumber) && mb_strlen($documentnumber) > 44) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 44', mb_strlen($documentnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($documentnumber) && mb_strlen($documentnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($documentnumber)), __LINE__);
        }
        $this->documentnumber = $documentnumber;
        return $this;
    }
    /**
     * Get subcountry value
     * @return string
     */
    public function getSubcountry()
    {
        return $this->subcountry;
    }
    /**
     * Set subcountry value
     * @param string $subcountry
     * @return \StructType\GUEST
     */
    public function setSubcountry($subcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subcountry) && !is_string($subcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subcountry, true), gettype($subcountry)), __LINE__);
        }
        $this->subcountry = $subcountry;
        return $this;
    }
    /**
     * Get subsubcountry value
     * @return string
     */
    public function getSubsubcountry()
    {
        return $this->subsubcountry;
    }
    /**
     * Set subsubcountry value
     * @param string $subsubcountry
     * @return \StructType\GUEST
     */
    public function setSubsubcountry($subsubcountry = null)
    {
        // validation for constraint: string
        if (!is_null($subsubcountry) && !is_string($subsubcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsubcountry, true), gettype($subsubcountry)), __LINE__);
        }
        $this->subsubcountry = $subsubcountry;
        return $this;
    }
    /**
     * Get birthdate value
     * @return string
     */
    public function getBirthdate()
    {
        return $this->birthdate;
    }
    /**
     * Set birthdate value
     * @param string $birthdate
     * @return \StructType\GUEST
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($birthdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($birthdate, true)), __LINE__);
        }
        $this->birthdate = $birthdate;
        return $this;
    }
    /**
     * Get email value
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\GUEST
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email) && mb_strlen($email) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email) && mb_strlen($email) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get iata value
     * @return string
     */
    public function getIata()
    {
        return $this->iata;
    }
    /**
     * Set iata value
     * @param string $iata
     * @return \StructType\GUEST
     */
    public function setIata($iata = null)
    {
        // validation for constraint: string
        if (!is_null($iata) && !is_string($iata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iata, true), gettype($iata)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($iata) && mb_strlen($iata) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($iata)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($iata) && mb_strlen($iata) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($iata)), __LINE__);
        }
        $this->iata = $iata;
        return $this;
    }
    /**
     * Get fax value
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\GUEST
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($fax) && mb_strlen($fax) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($fax)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($fax) && mb_strlen($fax) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get marketsegment value
     * @return string
     */
    public function getMarketsegment()
    {
        return $this->marketsegment;
    }
    /**
     * Set marketsegment value
     * @param string $marketsegment
     * @return \StructType\GUEST
     */
    public function setMarketsegment($marketsegment = null)
    {
        // validation for constraint: string
        if (!is_null($marketsegment) && !is_string($marketsegment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketsegment, true), gettype($marketsegment)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($marketsegment) && mb_strlen($marketsegment) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($marketsegment)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($marketsegment) && mb_strlen($marketsegment) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($marketsegment)), __LINE__);
        }
        $this->marketsegment = $marketsegment;
        return $this;
    }
    /**
     * Get vip value
     * @return string
     */
    public function getVip()
    {
        return $this->vip;
    }
    /**
     * Set vip value
     * @param string $vip
     * @return \StructType\GUEST
     */
    public function setVip($vip = null)
    {
        // validation for constraint: string
        if (!is_null($vip) && !is_string($vip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip, true), gettype($vip)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip) && mb_strlen($vip) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip) && mb_strlen($vip) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip)), __LINE__);
        }
        $this->vip = $vip;
        return $this;
    }
    /**
     * Get vip2 value
     * @return string
     */
    public function getVip2()
    {
        return $this->vip2;
    }
    /**
     * Set vip2 value
     * @param string $vip2
     * @return \StructType\GUEST
     */
    public function setVip2($vip2 = null)
    {
        // validation for constraint: string
        if (!is_null($vip2) && !is_string($vip2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vip2, true), gettype($vip2)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($vip2) && mb_strlen($vip2) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($vip2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($vip2) && mb_strlen($vip2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($vip2)), __LINE__);
        }
        $this->vip2 = $vip2;
        return $this;
    }
    /**
     * Get guestHotel value
     * @return string
     */
    public function getGuestHotel()
    {
        return $this->guestHotel;
    }
    /**
     * Set guestHotel value
     * @param string $guestHotel
     * @return \StructType\GUEST
     */
    public function setGuestHotel($guestHotel = null)
    {
        // validation for constraint: string
        if (!is_null($guestHotel) && !is_string($guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestHotel, true), gettype($guestHotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestHotel) && !preg_match('/([-+]){0,1}([0-9])*/', $guestHotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestHotel, true)), __LINE__);
        }
        $this->guestHotel = $guestHotel;
        return $this;
    }
    /**
     * Get guestNo value
     * @return string
     */
    public function getGuestNo()
    {
        return $this->guestNo;
    }
    /**
     * Set guestNo value
     * @param string $guestNo
     * @return \StructType\GUEST
     */
    public function setGuestNo($guestNo = null)
    {
        // validation for constraint: string
        if (!is_null($guestNo) && !is_string($guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestNo, true), gettype($guestNo)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($guestNo) && !preg_match('/([-+]){0,1}([0-9])*/', $guestNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($guestNo, true)), __LINE__);
        }
        $this->guestNo = $guestNo;
        return $this;
    }
    /**
     * Get phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\GUEST
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($phone) && mb_strlen($phone) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($phone) && mb_strlen($phone) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get languageiso639 value
     * @return languageiso639
     */
    public function getLanguageiso639_1()
    {
        return $this->languageiso639_1;
    }
    /**
     * Set languageiso639 value
     * @param languageiso639 $languageiso639
     * @return \StructType\GUEST
     */
    public function setLanguageiso639_1($languageiso639_1 = null)
    {
        // validation for constraint: string
        if (!is_null($languageiso639_1) && !is_string($languageiso639_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageiso639_1, true), gettype($languageiso639_1)), __LINE__);
        }
        $this->languageiso639_1 = $languageiso639_1;
        return $this;
    }
    /**
     * Get NEWSLETTER_SUBSCRIPTION value
     * @return \StructType\NEWSLETTER_SUBSCRIPTION
     */
    public function getNEWSLETTER_SUBSCRIPTION()
    {
        return $this->{'NEWSLETTER-SUBSCRIPTION'};
    }
    /**
     * Set NEWSLETTER_SUBSCRIPTION value
     * @param \StructType\NEWSLETTER_SUBSCRIPTION $nEWSLETTER_SUBSCRIPTION
     * @return \StructType\GUEST
     */
    public function setNEWSLETTER_SUBSCRIPTION(\StructType\NEWSLETTER_SUBSCRIPTION $nEWSLETTER_SUBSCRIPTION = null)
    {
        $this->NEWSLETTER_SUBSCRIPTION = $this->{'NEWSLETTER-SUBSCRIPTION'} = $nEWSLETTER_SUBSCRIPTION;
        return $this;
    }
    /**
     * Get EXTRA_INFORMATIONS value
     * @return \StructType\EXTRA_INFORMATIONS
     */
    public function getEXTRA_INFORMATIONS()
    {
        return $this->{'EXTRA-INFORMATIONS'};
    }
    /**
     * Set EXTRA_INFORMATIONS value
     * @param \StructType\EXTRA_INFORMATIONS $eXTRA_INFORMATIONS
     * @return \StructType\GUEST
     */
    public function setEXTRA_INFORMATIONS(\StructType\EXTRA_INFORMATIONS $eXTRA_INFORMATIONS = null)
    {
        $this->EXTRA_INFORMATIONS = $this->{'EXTRA-INFORMATIONS'} = $eXTRA_INFORMATIONS;
        return $this;
    }
    /**
     * Get LOYALTY value
     * @return \StructType\LOYALTY
     */
    public function getLOYALTY()
    {
        return $this->LOYALTY;
    }
    /**
     * Set LOYALTY value
     * @param \StructType\LOYALTY $lOYALTY
     * @return \StructType\GUEST
     */
    public function setLOYALTY(\StructType\LOYALTY $lOYALTY = null)
    {
        $this->LOYALTY = $lOYALTY;
        return $this;
    }
    /**
     * Get GUEST_IDENTIFICATIONS value
     * @return \StructType\GUEST_IDENTIFICATIONS
     */
    public function getGUEST_IDENTIFICATIONS()
    {
        return $this->{'GUEST-IDENTIFICATIONS'};
    }
    /**
     * Set GUEST_IDENTIFICATIONS value
     * @param \StructType\GUEST_IDENTIFICATIONS $gUEST_IDENTIFICATIONS
     * @return \StructType\GUEST
     */
    public function setGUEST_IDENTIFICATIONS(\StructType\GUEST_IDENTIFICATIONS $gUEST_IDENTIFICATIONS = null)
    {
        $this->GUEST_IDENTIFICATIONS = $this->{'GUEST-IDENTIFICATIONS'} = $gUEST_IDENTIFICATIONS;
        return $this;
    }
    /**
     * Get COMMENTS value
     * @return \StructType\COMMENTS_1
     */
    public function getCOMMENTS()
    {
        return $this->COMMENTS;
    }
    /**
     * Set COMMENTS value
     * @param \StructType\COMMENTS_1 $cOMMENTS
     * @return \StructType\GUEST
     */
    public function setCOMMENTS(\StructType\COMMENTS_1 $cOMMENTS = null)
    {
        $this->COMMENTS = $cOMMENTS;
        return $this;
    }
    /**
     * Get LOYALTY_CARD value
     * @return \StructType\LOYALTY_CARD
     */
    public function getLOYALTY_CARD()
    {
        return $this->{'LOYALTY-CARD'};
    }
    /**
     * Set LOYALTY_CARD value
     * @param \StructType\LOYALTY_CARD $lOYALTY_CARD
     * @return \StructType\GUEST
     */
    public function setLOYALTY_CARD(\StructType\LOYALTY_CARD $lOYALTY_CARD = null)
    {
        $this->LOYALTY_CARD = $this->{'LOYALTY-CARD'} = $lOYALTY_CARD;
        return $this;
    }
    /**
     * Get LOYALTY_CARD_OBJID value
     * @return string
     */
    public function getLOYALTY_CARD_OBJID()
    {
        return $this->{'LOYALTY-CARD-OBJID'};
    }
    /**
     * Set LOYALTY_CARD_OBJID value
     * @param string $lOYALTY_CARD_OBJID
     * @return \StructType\GUEST
     */
    public function setLOYALTY_CARD_OBJID($lOYALTY_CARD_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($lOYALTY_CARD_OBJID) && !is_string($lOYALTY_CARD_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lOYALTY_CARD_OBJID, true), gettype($lOYALTY_CARD_OBJID)), __LINE__);
        }
        $this->LOYALTY_CARD_OBJID = $this->{'LOYALTY-CARD-OBJID'} = $lOYALTY_CARD_OBJID;
        return $this;
    }
    /**
     * Get CARD value
     * @return \StructType\CARD
     */
    public function getCARD()
    {
        return $this->CARD;
    }
    /**
     * Set CARD value
     * @param \StructType\CARD $cARD
     * @return \StructType\GUEST
     */
    public function setCARD(\StructType\CARD $cARD = null)
    {
        $this->CARD = $cARD;
        return $this;
    }
    /**
     * Get location2 value
     * @return string
     */
    public function getLocation2()
    {
        return $this->location2;
    }
    /**
     * Set location2 value
     * @param string $location2
     * @return \StructType\GUEST
     */
    public function setLocation2($location2 = null)
    {
        // validation for constraint: string
        if (!is_null($location2) && !is_string($location2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location2, true), gettype($location2)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($location2) && mb_strlen($location2) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($location2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($location2) && mb_strlen($location2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($location2)), __LINE__);
        }
        $this->location2 = $location2;
        return $this;
    }
    /**
     * Get savecontactdata value
     * @return string
     */
    public function getSavecontactdata()
    {
        return $this->savecontactdata;
    }
    /**
     * Set savecontactdata value
     * @param string $savecontactdata
     * @return \StructType\GUEST
     */
    public function setSavecontactdata($savecontactdata = null)
    {
        // validation for constraint: string
        if (!is_null($savecontactdata) && !is_string($savecontactdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($savecontactdata, true), gettype($savecontactdata)), __LINE__);
        }
        $this->savecontactdata = $savecontactdata;
        return $this;
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\GUEST
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\GUEST
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER value
     * @return \StructType\INVOICE_HOLDER
     */
    public function getINVOICE_HOLDER()
    {
        return $this->{'INVOICE-HOLDER'};
    }
    /**
     * Set INVOICE_HOLDER value
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @return \StructType\GUEST
     */
    public function setINVOICE_HOLDER(\StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null)
    {
        $this->INVOICE_HOLDER = $this->{'INVOICE-HOLDER'} = $iNVOICE_HOLDER;
        return $this;
    }
    /**
     * Get INVOICE_ADDRESS value
     * @return \StructType\INVOICE_ADDRESS
     */
    public function getINVOICE_ADDRESS()
    {
        return $this->{'INVOICE-ADDRESS'};
    }
    /**
     * Set INVOICE_ADDRESS value
     * @param \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS
     * @return \StructType\GUEST
     */
    public function setINVOICE_ADDRESS(\StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS = null)
    {
        $this->INVOICE_ADDRESS = $this->{'INVOICE-ADDRESS'} = $iNVOICE_ADDRESS;
        return $this;
    }
    /**
     * Get general value
     * @return string|null
     */
    public function getGeneral()
    {
        return $this->general;
    }
    /**
     * Set general value
     * @param string $general
     * @return \StructType\GUEST
     */
    public function setGeneral($general = null)
    {
        // validation for constraint: string
        if (!is_null($general) && !is_string($general)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($general, true), gettype($general)), __LINE__);
        }
        $this->general = $general;
        return $this;
    }
    /**
     * Get housekeeping value
     * @return string|null
     */
    public function getHousekeeping()
    {
        return $this->housekeeping;
    }
    /**
     * Set housekeeping value
     * @param string $housekeeping
     * @return \StructType\GUEST
     */
    public function setHousekeeping($housekeeping = null)
    {
        // validation for constraint: string
        if (!is_null($housekeeping) && !is_string($housekeeping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($housekeeping, true), gettype($housekeeping)), __LINE__);
        }
        $this->housekeeping = $housekeeping;
        return $this;
    }
    /**
     * Get kitchen value
     * @return string|null
     */
    public function getKitchen()
    {
        return $this->kitchen;
    }
    /**
     * Set kitchen value
     * @param string $kitchen
     * @return \StructType\GUEST
     */
    public function setKitchen($kitchen = null)
    {
        // validation for constraint: string
        if (!is_null($kitchen) && !is_string($kitchen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kitchen, true), gettype($kitchen)), __LINE__);
        }
        $this->kitchen = $kitchen;
        return $this;
    }
    /**
     * Get frontoffice value
     * @return string|null
     */
    public function getFrontoffice()
    {
        return $this->frontoffice;
    }
    /**
     * Set frontoffice value
     * @param string $frontoffice
     * @return \StructType\GUEST
     */
    public function setFrontoffice($frontoffice = null)
    {
        // validation for constraint: string
        if (!is_null($frontoffice) && !is_string($frontoffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frontoffice, true), gettype($frontoffice)), __LINE__);
        }
        $this->frontoffice = $frontoffice;
        return $this;
    }
    /**
     * Get sales value
     * @return string|null
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * Set sales value
     * @param string $sales
     * @return \StructType\GUEST
     */
    public function setSales($sales = null)
    {
        // validation for constraint: string
        if (!is_null($sales) && !is_string($sales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sales, true), gettype($sales)), __LINE__);
        }
        $this->sales = $sales;
        return $this;
    }
    /**
     * Get event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @param string $event
     * @return \StructType\GUEST
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Get debitor value
     * @return string|null
     */
    public function getDebitor()
    {
        return $this->debitor;
    }
    /**
     * Set debitor value
     * @param string $debitor
     * @return \StructType\GUEST
     */
    public function setDebitor($debitor = null)
    {
        // validation for constraint: string
        if (!is_null($debitor) && !is_string($debitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($debitor, true), gettype($debitor)), __LINE__);
        }
        $this->debitor = $debitor;
        return $this;
    }
    /**
     * Get restaurant value
     * @return string|null
     */
    public function getRestaurant()
    {
        return $this->restaurant;
    }
    /**
     * Set restaurant value
     * @param string $restaurant
     * @return \StructType\GUEST
     */
    public function setRestaurant($restaurant = null)
    {
        // validation for constraint: string
        if (!is_null($restaurant) && !is_string($restaurant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restaurant, true), gettype($restaurant)), __LINE__);
        }
        $this->restaurant = $restaurant;
        return $this;
    }
    /**
     * Get checkin value
     * @return string|null
     */
    public function getCheckin()
    {
        return $this->checkin;
    }
    /**
     * Set checkin value
     * @param string $checkin
     * @return \StructType\GUEST
     */
    public function setCheckin($checkin = null)
    {
        // validation for constraint: string
        if (!is_null($checkin) && !is_string($checkin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkin, true), gettype($checkin)), __LINE__);
        }
        $this->checkin = $checkin;
        return $this;
    }
    /**
     * Get checkout value
     * @return string|null
     */
    public function getCheckout()
    {
        return $this->checkout;
    }
    /**
     * Set checkout value
     * @param string $checkout
     * @return \StructType\GUEST
     */
    public function setCheckout($checkout = null)
    {
        // validation for constraint: string
        if (!is_null($checkout) && !is_string($checkout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkout, true), gettype($checkout)), __LINE__);
        }
        $this->checkout = $checkout;
        return $this;
    }
    /**
     * Get interface value
     * @return string|null
     */
    public function getInterface()
    {
        return $this->interface;
    }
    /**
     * Set interface value
     * @param string $interface
     * @return \StructType\GUEST
     */
    public function setInterface($interface = null)
    {
        // validation for constraint: string
        if (!is_null($interface) && !is_string($interface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interface, true), gettype($interface)), __LINE__);
        }
        $this->interface = $interface;
        return $this;
    }
    /**
     * Get central value
     * @return string|null
     */
    public function getCentral()
    {
        return $this->central;
    }
    /**
     * Set central value
     * @param string $central
     * @return \StructType\GUEST
     */
    public function setCentral($central = null)
    {
        // validation for constraint: string
        if (!is_null($central) && !is_string($central)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($central, true), gettype($central)), __LINE__);
        }
        $this->central = $central;
        return $this;
    }
    /**
     * Get contact value
     * @return string|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param string $contact
     * @return \StructType\GUEST
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\GUEST
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($note) && mb_strlen($note) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($note)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($note) && mb_strlen($note) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get mobile2 value
     * @return string|null
     */
    public function getMobile2()
    {
        return $this->mobile2;
    }
    /**
     * Set mobile2 value
     * @param string $mobile2
     * @return \StructType\GUEST
     */
    public function setMobile2($mobile2 = null)
    {
        // validation for constraint: string
        if (!is_null($mobile2) && !is_string($mobile2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobile2, true), gettype($mobile2)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($mobile2) && mb_strlen($mobile2) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($mobile2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($mobile2) && mb_strlen($mobile2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($mobile2)), __LINE__);
        }
        $this->mobile2 = $mobile2;
        return $this;
    }
    /**
     * Get email2 value
     * @return string|null
     */
    public function getEmail2()
    {
        return $this->email2;
    }
    /**
     * Set email2 value
     * @param string $email2
     * @return \StructType\GUEST
     */
    public function setEmail2($email2 = null)
    {
        // validation for constraint: string
        if (!is_null($email2) && !is_string($email2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email2, true), gettype($email2)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($email2) && mb_strlen($email2) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($email2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($email2) && mb_strlen($email2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($email2)), __LINE__);
        }
        $this->email2 = $email2;
        return $this;
    }
    /**
     * Get keycardaccesscode value
     * @return string|null
     */
    public function getKeycardaccesscode()
    {
        return $this->keycardaccesscode;
    }
    /**
     * Set keycardaccesscode value
     * @param string $keycardaccesscode
     * @return \StructType\GUEST
     */
    public function setKeycardaccesscode($keycardaccesscode = null)
    {
        // validation for constraint: string
        if (!is_null($keycardaccesscode) && !is_string($keycardaccesscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keycardaccesscode, true), gettype($keycardaccesscode)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($keycardaccesscode) && mb_strlen($keycardaccesscode) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($keycardaccesscode)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($keycardaccesscode) && mb_strlen($keycardaccesscode) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($keycardaccesscode)), __LINE__);
        }
        $this->keycardaccesscode = $keycardaccesscode;
        return $this;
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\GUEST
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salutation, true), gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->profession;
    }
    /**
     * Set profession value
     * @param string $profession
     * @return \StructType\GUEST
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($profession) && mb_strlen($profession) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($profession)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($profession) && mb_strlen($profession) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($profession)), __LINE__);
        }
        $this->profession = $profession;
        return $this;
    }
    /**
     * Get delete value
     * @return string|null
     */
    public function getDelete()
    {
        return $this->delete;
    }
    /**
     * Set delete value
     * @param string $delete
     * @return \StructType\GUEST
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: string
        if (!is_null($delete) && !is_string($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->delete = $delete;
        return $this;
    }
    /**
     * Get industryfield value
     * @return string|null
     */
    public function getIndustryfield()
    {
        return $this->industryfield;
    }
    /**
     * Set industryfield value
     * @param string $industryfield
     * @return \StructType\GUEST
     */
    public function setIndustryfield($industryfield = null)
    {
        // validation for constraint: string
        if (!is_null($industryfield) && !is_string($industryfield)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industryfield, true), gettype($industryfield)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($industryfield) && mb_strlen($industryfield) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($industryfield)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($industryfield) && mb_strlen($industryfield) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($industryfield)), __LINE__);
        }
        $this->industryfield = $industryfield;
        return $this;
    }
    /**
     * Get salescategory value
     * @return string|null
     */
    public function getSalescategory()
    {
        return $this->salescategory;
    }
    /**
     * Set salescategory value
     * @param string $salescategory
     * @return \StructType\GUEST
     */
    public function setSalescategory($salescategory = null)
    {
        // validation for constraint: string
        if (!is_null($salescategory) && !is_string($salescategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salescategory, true), gettype($salescategory)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($salescategory) && mb_strlen($salescategory) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($salescategory)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($salescategory) && mb_strlen($salescategory) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($salescategory)), __LINE__);
        }
        $this->salescategory = $salescategory;
        return $this;
    }
    /**
     * Get GuestIdentifcation value
     * @return \StructType\GuestIdentifcation[]|null
     */
    public function getGuestIdentifcation()
    {
        return $this->GuestIdentifcation;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestIdentifcation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestIdentifcation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestIdentifcationForArrayConstraintsFromSetGuestIdentifcation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTGuestIdentifcationItem) {
            // validation for constraint: itemType
            if (!$gUESTGuestIdentifcationItem instanceof \StructType\GuestIdentifcation) {
                $invalidValues[] = is_object($gUESTGuestIdentifcationItem) ? get_class($gUESTGuestIdentifcationItem) : sprintf('%s(%s)', gettype($gUESTGuestIdentifcationItem), var_export($gUESTGuestIdentifcationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestIdentifcation property can only contain items of type \StructType\GuestIdentifcation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestIdentifcation value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestIdentifcation[] $guestIdentifcation
     * @return \StructType\GUEST
     */
    public function setGuestIdentifcation(array $guestIdentifcation = array())
    {
        // validation for constraint: array
        if ('' !== ($guestIdentifcationArrayErrorMessage = self::validateGuestIdentifcationForArrayConstraintsFromSetGuestIdentifcation($guestIdentifcation))) {
            throw new \InvalidArgumentException($guestIdentifcationArrayErrorMessage, __LINE__);
        }
        $this->GuestIdentifcation = $guestIdentifcation;
        return $this;
    }
    /**
     * Add item to GuestIdentifcation value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestIdentifcation $item
     * @return \StructType\GUEST
     */
    public function addToGuestIdentifcation(\StructType\GuestIdentifcation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestIdentifcation) {
            throw new \InvalidArgumentException(sprintf('The GuestIdentifcation property can only contain items of type \StructType\GuestIdentifcation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestIdentifcation[] = $item;
        return $this;
    }
    /**
     * Get GuestAdditional value
     * @return \StructType\GuestAdditional|null
     */
    public function getGuestAdditional()
    {
        return $this->GuestAdditional;
    }
    /**
     * Set GuestAdditional value
     * @param \StructType\GuestAdditional $guestAdditional
     * @return \StructType\GUEST
     */
    public function setGuestAdditional(\StructType\GuestAdditional $guestAdditional = null)
    {
        $this->GuestAdditional = $guestAdditional;
        return $this;
    }
    /**
     * Get discountgroup value
     * @return string|null
     */
    public function getDiscountgroup()
    {
        return $this->discountgroup;
    }
    /**
     * Set discountgroup value
     * @param string $discountgroup
     * @return \StructType\GUEST
     */
    public function setDiscountgroup($discountgroup = null)
    {
        // validation for constraint: string
        if (!is_null($discountgroup) && !is_string($discountgroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discountgroup, true), gettype($discountgroup)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($discountgroup) && mb_strlen($discountgroup) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($discountgroup)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($discountgroup) && mb_strlen($discountgroup) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($discountgroup)), __LINE__);
        }
        $this->discountgroup = $discountgroup;
        return $this;
    }
    /**
     * Get emailfilter value
     * @return string|null
     */
    public function getEmailfilter()
    {
        return $this->emailfilter;
    }
    /**
     * Set emailfilter value
     * @param string $emailfilter
     * @return \StructType\GUEST
     */
    public function setEmailfilter($emailfilter = null)
    {
        // validation for constraint: string
        if (!is_null($emailfilter) && !is_string($emailfilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailfilter, true), gettype($emailfilter)), __LINE__);
        }
        // validation for constraint: maxLength(18)
        if (!is_null($emailfilter) && mb_strlen($emailfilter) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 18', mb_strlen($emailfilter)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($emailfilter) && mb_strlen($emailfilter) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($emailfilter)), __LINE__);
        }
        $this->emailfilter = $emailfilter;
        return $this;
    }
    /**
     * Get emailsubscriptionhotel value
     * @return string|null
     */
    public function getEmailsubscriptionhotel()
    {
        return $this->emailsubscriptionhotel;
    }
    /**
     * Set emailsubscriptionhotel value
     * @param string $emailsubscriptionhotel
     * @return \StructType\GUEST
     */
    public function setEmailsubscriptionhotel($emailsubscriptionhotel = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptionhotel) && !is_string($emailsubscriptionhotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptionhotel, true), gettype($emailsubscriptionhotel)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($emailsubscriptionhotel) && !preg_match('/([-+]){0,1}([0-9])*/', $emailsubscriptionhotel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($emailsubscriptionhotel, true)), __LINE__);
        }
        $this->emailsubscriptionhotel = $emailsubscriptionhotel;
        return $this;
    }
    /**
     * Get emailsubscriptionpartner value
     * @return string|null
     */
    public function getEmailsubscriptionpartner()
    {
        return $this->emailsubscriptionpartner;
    }
    /**
     * Set emailsubscriptionpartner value
     * @param string $emailsubscriptionpartner
     * @return \StructType\GUEST
     */
    public function setEmailsubscriptionpartner($emailsubscriptionpartner = null)
    {
        // validation for constraint: string
        if (!is_null($emailsubscriptionpartner) && !is_string($emailsubscriptionpartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailsubscriptionpartner, true), gettype($emailsubscriptionpartner)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($emailsubscriptionpartner) && !preg_match('/([-+]){0,1}([0-9])*/', $emailsubscriptionpartner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($emailsubscriptionpartner, true)), __LINE__);
        }
        $this->emailsubscriptionpartner = $emailsubscriptionpartner;
        return $this;
    }
    /**
     * Get GuestIdentification value
     * @return \StructType\GuestIdentification[]|null
     */
    public function getGuestIdentification()
    {
        return $this->GuestIdentification;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestIdentification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestIdentification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestIdentificationForArrayConstraintsFromSetGuestIdentification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTGuestIdentificationItem) {
            // validation for constraint: itemType
            if (!$gUESTGuestIdentificationItem instanceof \StructType\GuestIdentification) {
                $invalidValues[] = is_object($gUESTGuestIdentificationItem) ? get_class($gUESTGuestIdentificationItem) : sprintf('%s(%s)', gettype($gUESTGuestIdentificationItem), var_export($gUESTGuestIdentificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestIdentification property can only contain items of type \StructType\GuestIdentification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestIdentification[] $guestIdentification
     * @return \StructType\GUEST
     */
    public function setGuestIdentification(array $guestIdentification = array())
    {
        // validation for constraint: array
        if ('' !== ($guestIdentificationArrayErrorMessage = self::validateGuestIdentificationForArrayConstraintsFromSetGuestIdentification($guestIdentification))) {
            throw new \InvalidArgumentException($guestIdentificationArrayErrorMessage, __LINE__);
        }
        $this->GuestIdentification = $guestIdentification;
        return $this;
    }
    /**
     * Add item to GuestIdentification value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestIdentification $item
     * @return \StructType\GUEST
     */
    public function addToGuestIdentification(\StructType\GuestIdentification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestIdentification) {
            throw new \InvalidArgumentException(sprintf('The GuestIdentification property can only contain items of type \StructType\GuestIdentification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestIdentification[] = $item;
        return $this;
    }
    /**
     * Get EXTRA_INFORMATION value
     * @return \StructType\EXTRA_INFORMATION[]|null
     */
    public function getEXTRA_INFORMATION()
    {
        return $this->{'EXTRA-INFORMATION'};
    }
    /**
     * This method is responsible for validating the values passed to the setEXTRA_INFORMATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEXTRA_INFORMATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEXTRA_INFORMATIONForArrayConstraintsFromSetEXTRA_INFORMATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTEXTRA_INFORMATIONItem) {
            // validation for constraint: itemType
            if (!$gUESTEXTRA_INFORMATIONItem instanceof \StructType\EXTRA_INFORMATION) {
                $invalidValues[] = is_object($gUESTEXTRA_INFORMATIONItem) ? get_class($gUESTEXTRA_INFORMATIONItem) : sprintf('%s(%s)', gettype($gUESTEXTRA_INFORMATIONItem), var_export($gUESTEXTRA_INFORMATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EXTRA_INFORMATION property can only contain items of type \StructType\EXTRA_INFORMATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EXTRA_INFORMATION value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTRA_INFORMATION[] $eXTRA_INFORMATION
     * @return \StructType\GUEST
     */
    public function setEXTRA_INFORMATION(array $eXTRA_INFORMATION = array())
    {
        // validation for constraint: array
        if ('' !== ($eXTRA_INFORMATIONArrayErrorMessage = self::validateEXTRA_INFORMATIONForArrayConstraintsFromSetEXTRA_INFORMATION($eXTRA_INFORMATION))) {
            throw new \InvalidArgumentException($eXTRA_INFORMATIONArrayErrorMessage, __LINE__);
        }
        $this->EXTRA_INFORMATION = $this->{'EXTRA-INFORMATION'} = $eXTRA_INFORMATION;
        return $this;
    }
    /**
     * Add item to EXTRA_INFORMATION value
     * @throws \InvalidArgumentException
     * @param \StructType\EXTRA_INFORMATION $item
     * @return \StructType\GUEST
     */
    public function addToEXTRA_INFORMATION(\StructType\EXTRA_INFORMATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EXTRA_INFORMATION) {
            throw new \InvalidArgumentException(sprintf('The EXTRA_INFORMATION property can only contain items of type \StructType\EXTRA_INFORMATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EXTRA_INFORMATION[] = $this->{'EXTRA-INFORMATION'}[] = $item;
        return $this;
    }
    /**
     * Get region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param string $region
     * @return \StructType\GUEST
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($region) && mb_strlen($region) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($region)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($region) && mb_strlen($region) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($region)), __LINE__);
        }
        $this->region = $region;
        return $this;
    }
    /**
     * Get nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->nationality;
    }
    /**
     * Set nationality value
     * @param string $nationality
     * @return \StructType\GUEST
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($nationality) && mb_strlen($nationality) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($nationality)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($nationality) && mb_strlen($nationality) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($nationality)), __LINE__);
        }
        $this->nationality = $nationality;
        return $this;
    }
    /**
     * Get placeofbirth value
     * @return string|null
     */
    public function getPlaceofbirth()
    {
        return $this->placeofbirth;
    }
    /**
     * Set placeofbirth value
     * @param string $placeofbirth
     * @return \StructType\GUEST
     */
    public function setPlaceofbirth($placeofbirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeofbirth) && !is_string($placeofbirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($placeofbirth, true), gettype($placeofbirth)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($placeofbirth)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($placeofbirth) && mb_strlen($placeofbirth) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($placeofbirth)), __LINE__);
        }
        $this->placeofbirth = $placeofbirth;
        return $this;
    }
    /**
     * Get birthcountry value
     * @return string|null
     */
    public function getBirthcountry()
    {
        return $this->birthcountry;
    }
    /**
     * Set birthcountry value
     * @param string $birthcountry
     * @return \StructType\GUEST
     */
    public function setBirthcountry($birthcountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthcountry) && !is_string($birthcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthcountry, true), gettype($birthcountry)), __LINE__);
        }
        // validation for constraint: maxLength(9)
        if (!is_null($birthcountry) && mb_strlen($birthcountry) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 9', mb_strlen($birthcountry)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($birthcountry) && mb_strlen($birthcountry) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($birthcountry)), __LINE__);
        }
        $this->birthcountry = $birthcountry;
        return $this;
    }
    /**
     * Get licenceplatenumber value
     * @return string|null
     */
    public function getLicenceplatenumber()
    {
        return $this->licenceplatenumber;
    }
    /**
     * Set licenceplatenumber value
     * @param string $licenceplatenumber
     * @return \StructType\GUEST
     */
    public function setLicenceplatenumber($licenceplatenumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenceplatenumber) && !is_string($licenceplatenumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenceplatenumber, true), gettype($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($licenceplatenumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($licenceplatenumber) && mb_strlen($licenceplatenumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($licenceplatenumber)), __LINE__);
        }
        $this->licenceplatenumber = $licenceplatenumber;
        return $this;
    }
    /**
     * Get documentdate value
     * @return string|null
     */
    public function getDocumentdate()
    {
        return $this->documentdate;
    }
    /**
     * Set documentdate value
     * @param string $documentdate
     * @return \StructType\GUEST
     */
    public function setDocumentdate($documentdate = null)
    {
        // validation for constraint: string
        if (!is_null($documentdate) && !is_string($documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentdate, true), gettype($documentdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($documentdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $documentdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($documentdate, true)), __LINE__);
        }
        $this->documentdate = $documentdate;
        return $this;
    }
    /**
     * Get docissuingcountry value
     * @return string|null
     */
    public function getDocissuingcountry()
    {
        return $this->docissuingcountry;
    }
    /**
     * Set docissuingcountry value
     * @param string $docissuingcountry
     * @return \StructType\GUEST
     */
    public function setDocissuingcountry($docissuingcountry = null)
    {
        // validation for constraint: string
        if (!is_null($docissuingcountry) && !is_string($docissuingcountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuingcountry, true), gettype($docissuingcountry)), __LINE__);
        }
        $this->docissuingcountry = $docissuingcountry;
        return $this;
    }
    /**
     * Get docissuedat value
     * @return string|null
     */
    public function getDocissuedat()
    {
        return $this->docissuedat;
    }
    /**
     * Set docissuedat value
     * @param string $docissuedat
     * @return \StructType\GUEST
     */
    public function setDocissuedat($docissuedat = null)
    {
        // validation for constraint: string
        if (!is_null($docissuedat) && !is_string($docissuedat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docissuedat, true), gettype($docissuedat)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($docissuedat) && mb_strlen($docissuedat) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($docissuedat)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($docissuedat) && mb_strlen($docissuedat) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($docissuedat)), __LINE__);
        }
        $this->docissuedat = $docissuedat;
        return $this;
    }
    /**
     * Get docexpirydate value
     * @return string|null
     */
    public function getDocexpirydate()
    {
        return $this->docexpirydate;
    }
    /**
     * Set docexpirydate value
     * @param string $docexpirydate
     * @return \StructType\GUEST
     */
    public function setDocexpirydate($docexpirydate = null)
    {
        // validation for constraint: string
        if (!is_null($docexpirydate) && !is_string($docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docexpirydate, true), gettype($docexpirydate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($docexpirydate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $docexpirydate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($docexpirydate, true)), __LINE__);
        }
        $this->docexpirydate = $docexpirydate;
        return $this;
    }
    /**
     * Get taxnumber value
     * @return string|null
     */
    public function getTaxnumber()
    {
        return $this->taxnumber;
    }
    /**
     * Set taxnumber value
     * @param string $taxnumber
     * @return \StructType\GUEST
     */
    public function setTaxnumber($taxnumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber) && !is_string($taxnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber, true), gettype($taxnumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($taxnumber) && mb_strlen($taxnumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($taxnumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($taxnumber) && mb_strlen($taxnumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($taxnumber)), __LINE__);
        }
        $this->taxnumber = $taxnumber;
        return $this;
    }
    /**
     * Get taxnumber2 value
     * @return string|null
     */
    public function getTaxnumber2()
    {
        return $this->taxnumber2;
    }
    /**
     * Set taxnumber2 value
     * @param string $taxnumber2
     * @return \StructType\GUEST
     */
    public function setTaxnumber2($taxnumber2 = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber2) && !is_string($taxnumber2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber2, true), gettype($taxnumber2)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($taxnumber2) && mb_strlen($taxnumber2) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($taxnumber2)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($taxnumber2) && mb_strlen($taxnumber2) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($taxnumber2)), __LINE__);
        }
        $this->taxnumber2 = $taxnumber2;
        return $this;
    }
    /**
     * Get taxnumber3 value
     * @return string|null
     */
    public function getTaxnumber3()
    {
        return $this->taxnumber3;
    }
    /**
     * Set taxnumber3 value
     * @param string $taxnumber3
     * @return \StructType\GUEST
     */
    public function setTaxnumber3($taxnumber3 = null)
    {
        // validation for constraint: string
        if (!is_null($taxnumber3) && !is_string($taxnumber3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxnumber3, true), gettype($taxnumber3)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($taxnumber3) && mb_strlen($taxnumber3) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($taxnumber3)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($taxnumber3) && mb_strlen($taxnumber3) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($taxnumber3)), __LINE__);
        }
        $this->taxnumber3 = $taxnumber3;
        return $this;
    }
    /**
     * Get subjecttotax value
     * @return string|null
     */
    public function getSubjecttotax()
    {
        return $this->subjecttotax;
    }
    /**
     * Set subjecttotax value
     * @param string $subjecttotax
     * @return \StructType\GUEST
     */
    public function setSubjecttotax($subjecttotax = null)
    {
        // validation for constraint: string
        if (!is_null($subjecttotax) && !is_string($subjecttotax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subjecttotax, true), gettype($subjecttotax)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($subjecttotax) && !preg_match('/([-+]){0,1}([0-9])*/', $subjecttotax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($subjecttotax, true)), __LINE__);
        }
        $this->subjecttotax = $subjecttotax;
        return $this;
    }
    /**
     * Get GUEST_IDENTIFICATION value
     * @return \StructType\GUEST_IDENTIFICATION[]|null
     */
    public function getGUEST_IDENTIFICATION()
    {
        return $this->{'GUEST-IDENTIFICATION'};
    }
    /**
     * This method is responsible for validating the values passed to the setGUEST_IDENTIFICATION method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGUEST_IDENTIFICATION method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGUEST_IDENTIFICATIONForArrayConstraintsFromSetGUEST_IDENTIFICATION(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTGUEST_IDENTIFICATIONItem) {
            // validation for constraint: itemType
            if (!$gUESTGUEST_IDENTIFICATIONItem instanceof \StructType\GUEST_IDENTIFICATION) {
                $invalidValues[] = is_object($gUESTGUEST_IDENTIFICATIONItem) ? get_class($gUESTGUEST_IDENTIFICATIONItem) : sprintf('%s(%s)', gettype($gUESTGUEST_IDENTIFICATIONItem), var_export($gUESTGUEST_IDENTIFICATIONItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GUEST_IDENTIFICATION property can only contain items of type \StructType\GUEST_IDENTIFICATION, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GUEST_IDENTIFICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST_IDENTIFICATION[] $gUEST_IDENTIFICATION
     * @return \StructType\GUEST
     */
    public function setGUEST_IDENTIFICATION(array $gUEST_IDENTIFICATION = array())
    {
        // validation for constraint: array
        if ('' !== ($gUEST_IDENTIFICATIONArrayErrorMessage = self::validateGUEST_IDENTIFICATIONForArrayConstraintsFromSetGUEST_IDENTIFICATION($gUEST_IDENTIFICATION))) {
            throw new \InvalidArgumentException($gUEST_IDENTIFICATIONArrayErrorMessage, __LINE__);
        }
        $this->GUEST_IDENTIFICATION = $this->{'GUEST-IDENTIFICATION'} = $gUEST_IDENTIFICATION;
        return $this;
    }
    /**
     * Add item to GUEST_IDENTIFICATION value
     * @throws \InvalidArgumentException
     * @param \StructType\GUEST_IDENTIFICATION $item
     * @return \StructType\GUEST
     */
    public function addToGUEST_IDENTIFICATION(\StructType\GUEST_IDENTIFICATION $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GUEST_IDENTIFICATION) {
            throw new \InvalidArgumentException(sprintf('The GUEST_IDENTIFICATION property can only contain items of type \StructType\GUEST_IDENTIFICATION, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GUEST_IDENTIFICATION[] = $this->{'GUEST-IDENTIFICATION'}[] = $item;
        return $this;
    }
    /**
     * Get MOTHER_COMPANY value
     * @return \StructType\MOTHER_COMPANY[]|null
     */
    public function getMOTHER_COMPANY()
    {
        return $this->{'MOTHER-COMPANY'};
    }
    /**
     * This method is responsible for validating the values passed to the setMOTHER_COMPANY method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMOTHER_COMPANY method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMOTHER_COMPANYForArrayConstraintsFromSetMOTHER_COMPANY(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gUESTMOTHER_COMPANYItem) {
            // validation for constraint: itemType
            if (!$gUESTMOTHER_COMPANYItem instanceof \StructType\MOTHER_COMPANY) {
                $invalidValues[] = is_object($gUESTMOTHER_COMPANYItem) ? get_class($gUESTMOTHER_COMPANYItem) : sprintf('%s(%s)', gettype($gUESTMOTHER_COMPANYItem), var_export($gUESTMOTHER_COMPANYItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MOTHER_COMPANY property can only contain items of type \StructType\MOTHER_COMPANY, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MOTHER_COMPANY value
     * @throws \InvalidArgumentException
     * @param \StructType\MOTHER_COMPANY[] $mOTHER_COMPANY
     * @return \StructType\GUEST
     */
    public function setMOTHER_COMPANY(array $mOTHER_COMPANY = array())
    {
        // validation for constraint: array
        if ('' !== ($mOTHER_COMPANYArrayErrorMessage = self::validateMOTHER_COMPANYForArrayConstraintsFromSetMOTHER_COMPANY($mOTHER_COMPANY))) {
            throw new \InvalidArgumentException($mOTHER_COMPANYArrayErrorMessage, __LINE__);
        }
        $this->MOTHER_COMPANY = $this->{'MOTHER-COMPANY'} = $mOTHER_COMPANY;
        return $this;
    }
    /**
     * Add item to MOTHER_COMPANY value
     * @throws \InvalidArgumentException
     * @param \StructType\MOTHER_COMPANY $item
     * @return \StructType\GUEST
     */
    public function addToMOTHER_COMPANY(\StructType\MOTHER_COMPANY $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MOTHER_COMPANY) {
            throw new \InvalidArgumentException(sprintf('The MOTHER_COMPANY property can only contain items of type \StructType\MOTHER_COMPANY, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MOTHER_COMPANY[] = $this->{'MOTHER-COMPANY'}[] = $item;
        return $this;
    }
}
