<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GROUP-ACCOUNT StructType
 * @subpackage Structs
 */
class GROUP_ACCOUNT extends AbstractStructBase
{
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $servicetype;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $service;
    /**
     * The INVOICE_HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\INVOICE_HOLDER
     */
    public $INVOICE_HOLDER;
    /**
     * The DELIVERY_ADDRESS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DELIVERY_ADDRESS
     */
    public $DELIVERY_ADDRESS;
    /**
     * The INVOICE_HOLDER_CONTACT_PERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $INVOICE_HOLDER_CONTACT_PERSON_OBJID;
    /**
     * The DELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DELIVERY_ADDRESS_CONTACT_PERSON_OBJID;
    /**
     * Constructor method for GROUP-ACCOUNT
     * @uses GROUP_ACCOUNT::setServicetype()
     * @uses GROUP_ACCOUNT::setService()
     * @uses GROUP_ACCOUNT::setINVOICE_HOLDER()
     * @uses GROUP_ACCOUNT::setDELIVERY_ADDRESS()
     * @uses GROUP_ACCOUNT::setINVOICE_HOLDER_CONTACT_PERSON_OBJID()
     * @uses GROUP_ACCOUNT::setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID()
     * @param string $servicetype
     * @param string $service
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @param \StructType\DELIVERY_ADDRESS $dELIVERY_ADDRESS
     * @param string $iNVOICE_HOLDER_CONTACT_PERSON_OBJID
     * @param string $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     */
    public function __construct($servicetype = null, $service = null, \StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null, \StructType\DELIVERY_ADDRESS $dELIVERY_ADDRESS = null, $iNVOICE_HOLDER_CONTACT_PERSON_OBJID = null, $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID = null)
    {
        $this
            ->setServicetype($servicetype)
            ->setService($service)
            ->setINVOICE_HOLDER($iNVOICE_HOLDER)
            ->setDELIVERY_ADDRESS($dELIVERY_ADDRESS)
            ->setINVOICE_HOLDER_CONTACT_PERSON_OBJID($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)
            ->setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID);
    }
    /**
     * Get servicetype value
     * @return string|null
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER value
     * @return \StructType\INVOICE_HOLDER|null
     */
    public function getINVOICE_HOLDER()
    {
        return $this->{'INVOICE-HOLDER'};
    }
    /**
     * Set INVOICE_HOLDER value
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setINVOICE_HOLDER(\StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null)
    {
        $this->INVOICE_HOLDER = $this->{'INVOICE-HOLDER'} = $iNVOICE_HOLDER;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS value
     * @return \StructType\DELIVERY_ADDRESS|null
     */
    public function getDELIVERY_ADDRESS()
    {
        return $this->{'DELIVERY-ADDRESS'};
    }
    /**
     * Set DELIVERY_ADDRESS value
     * @param \StructType\DELIVERY_ADDRESS $dELIVERY_ADDRESS
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setDELIVERY_ADDRESS(\StructType\DELIVERY_ADDRESS $dELIVERY_ADDRESS = null)
    {
        $this->DELIVERY_ADDRESS = $this->{'DELIVERY-ADDRESS'} = $dELIVERY_ADDRESS;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER_CONTACT_PERSON_OBJID value
     * @return string|null
     */
    public function getINVOICE_HOLDER_CONTACT_PERSON_OBJID()
    {
        return $this->{'INVOICE-HOLDER-CONTACT-PERSON-OBJID'};
    }
    /**
     * Set INVOICE_HOLDER_CONTACT_PERSON_OBJID value
     * @param string $iNVOICE_HOLDER_CONTACT_PERSON_OBJID
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setINVOICE_HOLDER_CONTACT_PERSON_OBJID($iNVOICE_HOLDER_CONTACT_PERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($iNVOICE_HOLDER_CONTACT_PERSON_OBJID) && !is_string($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iNVOICE_HOLDER_CONTACT_PERSON_OBJID, true), gettype($iNVOICE_HOLDER_CONTACT_PERSON_OBJID)), __LINE__);
        }
        $this->INVOICE_HOLDER_CONTACT_PERSON_OBJID = $this->{'INVOICE-HOLDER-CONTACT-PERSON-OBJID'} = $iNVOICE_HOLDER_CONTACT_PERSON_OBJID;
        return $this;
    }
    /**
     * Get DELIVERY_ADDRESS_CONTACT_PERSON_OBJID value
     * @return string|null
     */
    public function getDELIVERY_ADDRESS_CONTACT_PERSON_OBJID()
    {
        return $this->{'DELIVERY-ADDRESS-CONTACT-PERSON-OBJID'};
    }
    /**
     * Set DELIVERY_ADDRESS_CONTACT_PERSON_OBJID value
     * @param string $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID
     * @return \StructType\GROUP_ACCOUNT
     */
    public function setDELIVERY_ADDRESS_CONTACT_PERSON_OBJID($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID) && !is_string($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID, true), gettype($dELIVERY_ADDRESS_CONTACT_PERSON_OBJID)), __LINE__);
        }
        $this->DELIVERY_ADDRESS_CONTACT_PERSON_OBJID = $this->{'DELIVERY-ADDRESS-CONTACT-PERSON-OBJID'} = $dELIVERY_ADDRESS_CONTACT_PERSON_OBJID;
        return $this;
    }
}
