<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GROUP StructType
 * @subpackage Structs
 */
class GROUP extends AbstractStructBase
{
    /**
     * The servicetype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $servicetype;
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $service;
    /**
     * The INVOICE_HOLDER
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INVOICE_HOLDER
     */
    public $INVOICE_HOLDER;
    /**
     * The INVOICE_ADDRESS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\INVOICE_ADDRESS
     */
    public $INVOICE_ADDRESS;
    /**
     * Constructor method for GROUP
     * @uses GROUP::setServicetype()
     * @uses GROUP::setService()
     * @uses GROUP::setINVOICE_HOLDER()
     * @uses GROUP::setINVOICE_ADDRESS()
     * @param string $servicetype
     * @param string $service
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @param \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS
     */
    public function __construct($servicetype = null, $service = null, \StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null, \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS = null)
    {
        $this
            ->setServicetype($servicetype)
            ->setService($service)
            ->setINVOICE_HOLDER($iNVOICE_HOLDER)
            ->setINVOICE_ADDRESS($iNVOICE_ADDRESS);
    }
    /**
     * Get servicetype value
     * @return string
     */
    public function getServicetype()
    {
        return $this->servicetype;
    }
    /**
     * Set servicetype value
     * @param string $servicetype
     * @return \StructType\GROUP
     */
    public function setServicetype($servicetype = null)
    {
        // validation for constraint: string
        if (!is_null($servicetype) && !is_string($servicetype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($servicetype, true), gettype($servicetype)), __LINE__);
        }
        $this->servicetype = $servicetype;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\GROUP
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get INVOICE_HOLDER value
     * @return \StructType\INVOICE_HOLDER
     */
    public function getINVOICE_HOLDER()
    {
        return $this->{'INVOICE-HOLDER'};
    }
    /**
     * Set INVOICE_HOLDER value
     * @param \StructType\INVOICE_HOLDER $iNVOICE_HOLDER
     * @return \StructType\GROUP
     */
    public function setINVOICE_HOLDER(\StructType\INVOICE_HOLDER $iNVOICE_HOLDER = null)
    {
        $this->INVOICE_HOLDER = $this->{'INVOICE-HOLDER'} = $iNVOICE_HOLDER;
        return $this;
    }
    /**
     * Get INVOICE_ADDRESS value
     * @return \StructType\INVOICE_ADDRESS
     */
    public function getINVOICE_ADDRESS()
    {
        return $this->{'INVOICE-ADDRESS'};
    }
    /**
     * Set INVOICE_ADDRESS value
     * @param \StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS
     * @return \StructType\GROUP
     */
    public function setINVOICE_ADDRESS(\StructType\INVOICE_ADDRESS $iNVOICE_ADDRESS = null)
    {
        $this->INVOICE_ADDRESS = $this->{'INVOICE-ADDRESS'} = $iNVOICE_ADDRESS;
        return $this;
    }
}
