<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeRoomSearch StructType
 * @subpackage Structs
 */
class FreeRoomSearch extends AbstractStructBase
{
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $category;
    /**
     * The roomfrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomfrom;
    /**
     * The roomto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roomto;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Room[]
     */
    public $Room;
    /**
     * Constructor method for FreeRoomSearch
     * @uses FreeRoomSearch::setDatefrom()
     * @uses FreeRoomSearch::setDateto()
     * @uses FreeRoomSearch::setCategory()
     * @uses FreeRoomSearch::setRoomfrom()
     * @uses FreeRoomSearch::setRoomto()
     * @uses FreeRoomSearch::setRoom()
     * @param string $datefrom
     * @param string $dateto
     * @param string $category
     * @param string $roomfrom
     * @param string $roomto
     * @param \StructType\Room[] $room
     */
    public function __construct($datefrom = null, $dateto = null, $category = null, $roomfrom = null, $roomto = null, array $room = array())
    {
        $this
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setCategory($category)
            ->setRoomfrom($roomfrom)
            ->setRoomto($roomto)
            ->setRoom($room);
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\FreeRoomSearch
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\FreeRoomSearch
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param string $category
     * @return \StructType\FreeRoomSearch
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->category = $category;
        return $this;
    }
    /**
     * Get roomfrom value
     * @return string|null
     */
    public function getRoomfrom()
    {
        return $this->roomfrom;
    }
    /**
     * Set roomfrom value
     * @param string $roomfrom
     * @return \StructType\FreeRoomSearch
     */
    public function setRoomfrom($roomfrom = null)
    {
        // validation for constraint: string
        if (!is_null($roomfrom) && !is_string($roomfrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomfrom, true), gettype($roomfrom)), __LINE__);
        }
        $this->roomfrom = $roomfrom;
        return $this;
    }
    /**
     * Get roomto value
     * @return string|null
     */
    public function getRoomto()
    {
        return $this->roomto;
    }
    /**
     * Set roomto value
     * @param string $roomto
     * @return \StructType\FreeRoomSearch
     */
    public function setRoomto($roomto = null)
    {
        // validation for constraint: string
        if (!is_null($roomto) && !is_string($roomto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomto, true), gettype($roomto)), __LINE__);
        }
        $this->roomto = $roomto;
        return $this;
    }
    /**
     * Get Room value
     * @return \StructType\Room[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $freeRoomSearchRoomItem) {
            // validation for constraint: itemType
            if (!$freeRoomSearchRoomItem instanceof \StructType\Room) {
                $invalidValues[] = is_object($freeRoomSearchRoomItem) ? get_class($freeRoomSearchRoomItem) : sprintf('%s(%s)', gettype($freeRoomSearchRoomItem), var_export($freeRoomSearchRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room[] $room
     * @return \StructType\FreeRoomSearch
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \StructType\Room $item
     * @return \StructType\FreeRoomSearch
     */
    public function addToRoom(\StructType\Room $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Room) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \StructType\Room, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
}
