<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedbackEntry StructType
 * @subpackage Structs
 */
class FeedbackEntry extends AbstractStructBase
{
    /**
     * The location
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $location;
    /**
     * The sleepquality
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $sleepquality;
    /**
     * The feedbackservice
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $feedbackservice;
    /**
     * The cleanliness
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $cleanliness;
    /**
     * The rooms
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $rooms;
    /**
     * The priceperformance
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $priceperformance;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * Constructor method for FeedbackEntry
     * @uses FeedbackEntry::setLocation()
     * @uses FeedbackEntry::setSleepquality()
     * @uses FeedbackEntry::setFeedbackservice()
     * @uses FeedbackEntry::setCleanliness()
     * @uses FeedbackEntry::setRooms()
     * @uses FeedbackEntry::setPriceperformance()
     * @uses FeedbackEntry::setText()
     * @param string $location
     * @param string $sleepquality
     * @param string $feedbackservice
     * @param string $cleanliness
     * @param string $rooms
     * @param string $priceperformance
     * @param string $text
     */
    public function __construct($location = null, $sleepquality = null, $feedbackservice = null, $cleanliness = null, $rooms = null, $priceperformance = null, $text = null)
    {
        $this
            ->setLocation($location)
            ->setSleepquality($sleepquality)
            ->setFeedbackservice($feedbackservice)
            ->setCleanliness($cleanliness)
            ->setRooms($rooms)
            ->setPriceperformance($priceperformance)
            ->setText($text);
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\FeedbackEntry
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($location, true), gettype($location)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($location) && !preg_match('/([-+]){0,1}([0-9])*/', $location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($location, true)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get sleepquality value
     * @return string|null
     */
    public function getSleepquality()
    {
        return $this->sleepquality;
    }
    /**
     * Set sleepquality value
     * @param string $sleepquality
     * @return \StructType\FeedbackEntry
     */
    public function setSleepquality($sleepquality = null)
    {
        // validation for constraint: string
        if (!is_null($sleepquality) && !is_string($sleepquality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sleepquality, true), gettype($sleepquality)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($sleepquality) && !preg_match('/([-+]){0,1}([0-9])*/', $sleepquality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($sleepquality, true)), __LINE__);
        }
        $this->sleepquality = $sleepquality;
        return $this;
    }
    /**
     * Get feedbackservice value
     * @return string|null
     */
    public function getFeedbackservice()
    {
        return $this->feedbackservice;
    }
    /**
     * Set feedbackservice value
     * @param string $feedbackservice
     * @return \StructType\FeedbackEntry
     */
    public function setFeedbackservice($feedbackservice = null)
    {
        // validation for constraint: string
        if (!is_null($feedbackservice) && !is_string($feedbackservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedbackservice, true), gettype($feedbackservice)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($feedbackservice) && !preg_match('/([-+]){0,1}([0-9])*/', $feedbackservice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($feedbackservice, true)), __LINE__);
        }
        $this->feedbackservice = $feedbackservice;
        return $this;
    }
    /**
     * Get cleanliness value
     * @return string|null
     */
    public function getCleanliness()
    {
        return $this->cleanliness;
    }
    /**
     * Set cleanliness value
     * @param string $cleanliness
     * @return \StructType\FeedbackEntry
     */
    public function setCleanliness($cleanliness = null)
    {
        // validation for constraint: string
        if (!is_null($cleanliness) && !is_string($cleanliness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cleanliness, true), gettype($cleanliness)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($cleanliness) && !preg_match('/([-+]){0,1}([0-9])*/', $cleanliness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($cleanliness, true)), __LINE__);
        }
        $this->cleanliness = $cleanliness;
        return $this;
    }
    /**
     * Get rooms value
     * @return string|null
     */
    public function getRooms()
    {
        return $this->rooms;
    }
    /**
     * Set rooms value
     * @param string $rooms
     * @return \StructType\FeedbackEntry
     */
    public function setRooms($rooms = null)
    {
        // validation for constraint: string
        if (!is_null($rooms) && !is_string($rooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rooms, true), gettype($rooms)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($rooms) && !preg_match('/([-+]){0,1}([0-9])*/', $rooms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($rooms, true)), __LINE__);
        }
        $this->rooms = $rooms;
        return $this;
    }
    /**
     * Get priceperformance value
     * @return string|null
     */
    public function getPriceperformance()
    {
        return $this->priceperformance;
    }
    /**
     * Set priceperformance value
     * @param string $priceperformance
     * @return \StructType\FeedbackEntry
     */
    public function setPriceperformance($priceperformance = null)
    {
        // validation for constraint: string
        if (!is_null($priceperformance) && !is_string($priceperformance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceperformance, true), gettype($priceperformance)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($priceperformance) && !preg_match('/([-+]){0,1}([0-9])*/', $priceperformance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($priceperformance, true)), __LINE__);
        }
        $this->priceperformance = $priceperformance;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\FeedbackEntry
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
}
