<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FORECAST StructType
 * @subpackage Structs
 */
class FORECAST extends AbstractStructBase
{
    /**
     * The forecast
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $forecast;
    /**
     * The delta
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $delta;
    /**
     * Constructor method for FORECAST
     * @uses FORECAST::setForecast()
     * @uses FORECAST::setDelta()
     * @param string $forecast
     * @param string $delta
     */
    public function __construct($forecast = null, $delta = null)
    {
        $this
            ->setForecast($forecast)
            ->setDelta($delta);
    }
    /**
     * Get forecast value
     * @return string
     */
    public function getForecast()
    {
        return $this->forecast;
    }
    /**
     * Set forecast value
     * @param string $forecast
     * @return \StructType\FORECAST
     */
    public function setForecast($forecast = null)
    {
        // validation for constraint: string
        if (!is_null($forecast) && !is_string($forecast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forecast, true), gettype($forecast)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($forecast) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $forecast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($forecast, true)), __LINE__);
        }
        $this->forecast = $forecast;
        return $this;
    }
    /**
     * Get delta value
     * @return string
     */
    public function getDelta()
    {
        return $this->delta;
    }
    /**
     * Set delta value
     * @param string $delta
     * @return \StructType\FORECAST
     */
    public function setDelta($delta = null)
    {
        // validation for constraint: string
        if (!is_null($delta) && !is_string($delta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delta, true), gettype($delta)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($delta) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $delta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($delta, true)), __LINE__);
        }
        $this->delta = $delta;
        return $this;
    }
}
