<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventReservation StructType
 * @subpackage Structs
 */
class EventReservation extends AbstractStructBase
{
    /**
     * The EVENT_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_RESERVATION_OBJID;
    /**
     * The ServiceReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ServiceReservations
     */
    public $ServiceReservations;
    /**
     * The PackageReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PackageReservations
     */
    public $PackageReservations;
    /**
     * The RoomReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RoomReservations
     */
    public $RoomReservations;
    /**
     * The ModuleReservations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ModuleReservations
     */
    public $ModuleReservations;
    /**
     * Constructor method for EventReservation
     * @uses EventReservation::setEVENT_RESERVATION_OBJID()
     * @uses EventReservation::setServiceReservations()
     * @uses EventReservation::setPackageReservations()
     * @uses EventReservation::setRoomReservations()
     * @uses EventReservation::setModuleReservations()
     * @param string $eVENT_RESERVATION_OBJID
     * @param \StructType\ServiceReservations $serviceReservations
     * @param \StructType\PackageReservations $packageReservations
     * @param \StructType\RoomReservations $roomReservations
     * @param \StructType\ModuleReservations $moduleReservations
     */
    public function __construct($eVENT_RESERVATION_OBJID = null, \StructType\ServiceReservations $serviceReservations = null, \StructType\PackageReservations $packageReservations = null, \StructType\RoomReservations $roomReservations = null, \StructType\ModuleReservations $moduleReservations = null)
    {
        $this
            ->setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID)
            ->setServiceReservations($serviceReservations)
            ->setPackageReservations($packageReservations)
            ->setRoomReservations($roomReservations)
            ->setModuleReservations($moduleReservations);
    }
    /**
     * Get EVENT_RESERVATION_OBJID value
     * @return string
     */
    public function getEVENT_RESERVATION_OBJID()
    {
        return $this->{'EVENT-RESERVATION-OBJID'};
    }
    /**
     * Set EVENT_RESERVATION_OBJID value
     * @param string $eVENT_RESERVATION_OBJID
     * @return \StructType\EventReservation
     */
    public function setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_RESERVATION_OBJID) && !is_string($eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_RESERVATION_OBJID, true), gettype($eVENT_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->EVENT_RESERVATION_OBJID = $this->{'EVENT-RESERVATION-OBJID'} = $eVENT_RESERVATION_OBJID;
        return $this;
    }
    /**
     * Get ServiceReservations value
     * @return \StructType\ServiceReservations
     */
    public function getServiceReservations()
    {
        return $this->ServiceReservations;
    }
    /**
     * Set ServiceReservations value
     * @param \StructType\ServiceReservations $serviceReservations
     * @return \StructType\EventReservation
     */
    public function setServiceReservations(\StructType\ServiceReservations $serviceReservations = null)
    {
        $this->ServiceReservations = $serviceReservations;
        return $this;
    }
    /**
     * Get PackageReservations value
     * @return \StructType\PackageReservations
     */
    public function getPackageReservations()
    {
        return $this->PackageReservations;
    }
    /**
     * Set PackageReservations value
     * @param \StructType\PackageReservations $packageReservations
     * @return \StructType\EventReservation
     */
    public function setPackageReservations(\StructType\PackageReservations $packageReservations = null)
    {
        $this->PackageReservations = $packageReservations;
        return $this;
    }
    /**
     * Get RoomReservations value
     * @return \StructType\RoomReservations
     */
    public function getRoomReservations()
    {
        return $this->RoomReservations;
    }
    /**
     * Set RoomReservations value
     * @param \StructType\RoomReservations $roomReservations
     * @return \StructType\EventReservation
     */
    public function setRoomReservations(\StructType\RoomReservations $roomReservations = null)
    {
        $this->RoomReservations = $roomReservations;
        return $this;
    }
    /**
     * Get ModuleReservations value
     * @return \StructType\ModuleReservations
     */
    public function getModuleReservations()
    {
        return $this->ModuleReservations;
    }
    /**
     * Set ModuleReservations value
     * @param \StructType\ModuleReservations $moduleReservations
     * @return \StructType\EventReservation
     */
    public function setModuleReservations(\StructType\ModuleReservations $moduleReservations = null)
    {
        $this->ModuleReservations = $moduleReservations;
        return $this;
    }
}
