<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRes StructType
 * @subpackage Structs
 */
class EventRes extends AbstractStructBase
{
    /**
     * The EVENT_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_RESERVATION_OBJID;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $date;
    /**
     * The datefrom
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $datefrom;
    /**
     * The dateto
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $dateto;
    /**
     * The EventServiceRes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\EventServiceRes[]
     */
    public $EventServiceRes;
    /**
     * The RoomRes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoomRes[]
     */
    public $RoomRes;
    /**
     * The ModuleRes
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ModuleRes[]
     */
    public $ModuleRes;
    /**
     * The transferreservations
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([-+]){0,1}([0-9])*
     * @var string
     */
    public $transferreservations;
    /**
     * Constructor method for EventRes
     * @uses EventRes::setEVENT_RESERVATION_OBJID()
     * @uses EventRes::setDate()
     * @uses EventRes::setDatefrom()
     * @uses EventRes::setDateto()
     * @uses EventRes::setEventServiceRes()
     * @uses EventRes::setRoomRes()
     * @uses EventRes::setModuleRes()
     * @uses EventRes::setTransferreservations()
     * @param string $eVENT_RESERVATION_OBJID
     * @param string $date
     * @param string $datefrom
     * @param string $dateto
     * @param \StructType\EventServiceRes[] $eventServiceRes
     * @param \StructType\RoomRes[] $roomRes
     * @param \StructType\ModuleRes[] $moduleRes
     * @param string $transferreservations
     */
    public function __construct($eVENT_RESERVATION_OBJID = null, $date = null, $datefrom = null, $dateto = null, array $eventServiceRes = array(), array $roomRes = array(), array $moduleRes = array(), $transferreservations = null)
    {
        $this
            ->setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID)
            ->setDate($date)
            ->setDatefrom($datefrom)
            ->setDateto($dateto)
            ->setEventServiceRes($eventServiceRes)
            ->setRoomRes($roomRes)
            ->setModuleRes($moduleRes)
            ->setTransferreservations($transferreservations);
    }
    /**
     * Get EVENT_RESERVATION_OBJID value
     * @return string
     */
    public function getEVENT_RESERVATION_OBJID()
    {
        return $this->{'EVENT-RESERVATION-OBJID'};
    }
    /**
     * Set EVENT_RESERVATION_OBJID value
     * @param string $eVENT_RESERVATION_OBJID
     * @return \StructType\EventRes
     */
    public function setEVENT_RESERVATION_OBJID($eVENT_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_RESERVATION_OBJID) && !is_string($eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_RESERVATION_OBJID, true), gettype($eVENT_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $eVENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->EVENT_RESERVATION_OBJID = $this->{'EVENT-RESERVATION-OBJID'} = $eVENT_RESERVATION_OBJID;
        return $this;
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\EventRes
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($date) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($date, true)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get datefrom value
     * @return string
     */
    public function getDatefrom()
    {
        return $this->datefrom;
    }
    /**
     * Set datefrom value
     * @param string $datefrom
     * @return \StructType\EventRes
     */
    public function setDatefrom($datefrom = null)
    {
        // validation for constraint: string
        if (!is_null($datefrom) && !is_string($datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datefrom, true), gettype($datefrom)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($datefrom) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $datefrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($datefrom, true)), __LINE__);
        }
        $this->datefrom = $datefrom;
        return $this;
    }
    /**
     * Get dateto value
     * @return string
     */
    public function getDateto()
    {
        return $this->dateto;
    }
    /**
     * Set dateto value
     * @param string $dateto
     * @return \StructType\EventRes
     */
    public function setDateto($dateto = null)
    {
        // validation for constraint: string
        if (!is_null($dateto) && !is_string($dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateto, true), gettype($dateto)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($dateto) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $dateto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($dateto, true)), __LINE__);
        }
        $this->dateto = $dateto;
        return $this;
    }
    /**
     * Get EventServiceRes value
     * @return \StructType\EventServiceRes[]|null
     */
    public function getEventServiceRes()
    {
        return $this->EventServiceRes;
    }
    /**
     * This method is responsible for validating the values passed to the setEventServiceRes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventServiceRes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventServiceResForArrayConstraintsFromSetEventServiceRes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventResEventServiceResItem) {
            // validation for constraint: itemType
            if (!$eventResEventServiceResItem instanceof \StructType\EventServiceRes) {
                $invalidValues[] = is_object($eventResEventServiceResItem) ? get_class($eventResEventServiceResItem) : sprintf('%s(%s)', gettype($eventResEventServiceResItem), var_export($eventResEventServiceResItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventServiceRes property can only contain items of type \StructType\EventServiceRes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventServiceRes value
     * @throws \InvalidArgumentException
     * @param \StructType\EventServiceRes[] $eventServiceRes
     * @return \StructType\EventRes
     */
    public function setEventServiceRes(array $eventServiceRes = array())
    {
        // validation for constraint: array
        if ('' !== ($eventServiceResArrayErrorMessage = self::validateEventServiceResForArrayConstraintsFromSetEventServiceRes($eventServiceRes))) {
            throw new \InvalidArgumentException($eventServiceResArrayErrorMessage, __LINE__);
        }
        $this->EventServiceRes = $eventServiceRes;
        return $this;
    }
    /**
     * Add item to EventServiceRes value
     * @throws \InvalidArgumentException
     * @param \StructType\EventServiceRes $item
     * @return \StructType\EventRes
     */
    public function addToEventServiceRes(\StructType\EventServiceRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EventServiceRes) {
            throw new \InvalidArgumentException(sprintf('The EventServiceRes property can only contain items of type \StructType\EventServiceRes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventServiceRes[] = $item;
        return $this;
    }
    /**
     * Get RoomRes value
     * @return \StructType\RoomRes[]|null
     */
    public function getRoomRes()
    {
        return $this->RoomRes;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomRes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomRes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomResForArrayConstraintsFromSetRoomRes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventResRoomResItem) {
            // validation for constraint: itemType
            if (!$eventResRoomResItem instanceof \StructType\RoomRes) {
                $invalidValues[] = is_object($eventResRoomResItem) ? get_class($eventResRoomResItem) : sprintf('%s(%s)', gettype($eventResRoomResItem), var_export($eventResRoomResItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomRes property can only contain items of type \StructType\RoomRes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomRes value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomRes[] $roomRes
     * @return \StructType\EventRes
     */
    public function setRoomRes(array $roomRes = array())
    {
        // validation for constraint: array
        if ('' !== ($roomResArrayErrorMessage = self::validateRoomResForArrayConstraintsFromSetRoomRes($roomRes))) {
            throw new \InvalidArgumentException($roomResArrayErrorMessage, __LINE__);
        }
        $this->RoomRes = $roomRes;
        return $this;
    }
    /**
     * Add item to RoomRes value
     * @throws \InvalidArgumentException
     * @param \StructType\RoomRes $item
     * @return \StructType\EventRes
     */
    public function addToRoomRes(\StructType\RoomRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoomRes) {
            throw new \InvalidArgumentException(sprintf('The RoomRes property can only contain items of type \StructType\RoomRes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoomRes[] = $item;
        return $this;
    }
    /**
     * Get ModuleRes value
     * @return \StructType\ModuleRes[]|null
     */
    public function getModuleRes()
    {
        return $this->ModuleRes;
    }
    /**
     * This method is responsible for validating the values passed to the setModuleRes method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModuleRes method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModuleResForArrayConstraintsFromSetModuleRes(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventResModuleResItem) {
            // validation for constraint: itemType
            if (!$eventResModuleResItem instanceof \StructType\ModuleRes) {
                $invalidValues[] = is_object($eventResModuleResItem) ? get_class($eventResModuleResItem) : sprintf('%s(%s)', gettype($eventResModuleResItem), var_export($eventResModuleResItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ModuleRes property can only contain items of type \StructType\ModuleRes, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ModuleRes value
     * @throws \InvalidArgumentException
     * @param \StructType\ModuleRes[] $moduleRes
     * @return \StructType\EventRes
     */
    public function setModuleRes(array $moduleRes = array())
    {
        // validation for constraint: array
        if ('' !== ($moduleResArrayErrorMessage = self::validateModuleResForArrayConstraintsFromSetModuleRes($moduleRes))) {
            throw new \InvalidArgumentException($moduleResArrayErrorMessage, __LINE__);
        }
        $this->ModuleRes = $moduleRes;
        return $this;
    }
    /**
     * Add item to ModuleRes value
     * @throws \InvalidArgumentException
     * @param \StructType\ModuleRes $item
     * @return \StructType\EventRes
     */
    public function addToModuleRes(\StructType\ModuleRes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ModuleRes) {
            throw new \InvalidArgumentException(sprintf('The ModuleRes property can only contain items of type \StructType\ModuleRes, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ModuleRes[] = $item;
        return $this;
    }
    /**
     * Get transferreservations value
     * @return string|null
     */
    public function getTransferreservations()
    {
        return $this->transferreservations;
    }
    /**
     * Set transferreservations value
     * @param string $transferreservations
     * @return \StructType\EventRes
     */
    public function setTransferreservations($transferreservations = null)
    {
        // validation for constraint: string
        if (!is_null($transferreservations) && !is_string($transferreservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transferreservations, true), gettype($transferreservations)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*)
        if (!is_null($transferreservations) && !preg_match('/([-+]){0,1}([0-9])*/', $transferreservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*', var_export($transferreservations, true)), __LINE__);
        }
        $this->transferreservations = $transferreservations;
        return $this;
    }
}
