<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventEquipmentMasterFile StructType
 * @subpackage Structs
 */
class EventEquipmentMasterFile extends AbstractStructBase
{
    /**
     * The EVENT_EQUIPMENT_MASTER_FILE_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EVENT_EQUIPMENT_MASTER_FILE_OBJID;
    /**
     * The equipmentno
     * Meta information extracted from the WSDL
     * - base: string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 0
     * - minOccurs: 1
     * @var string
     */
    public $equipmentno;
    /**
     * The MultiLangDescriptions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangDescriptions[]
     */
    public $MultiLangDescriptions;
    /**
     * The MultiLangComments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MultiLangComments[]
     */
    public $MultiLangComments;
    /**
     * Constructor method for EventEquipmentMasterFile
     * @uses EventEquipmentMasterFile::setEVENT_EQUIPMENT_MASTER_FILE_OBJID()
     * @uses EventEquipmentMasterFile::setEquipmentno()
     * @uses EventEquipmentMasterFile::setMultiLangDescriptions()
     * @uses EventEquipmentMasterFile::setMultiLangComments()
     * @param string $eVENT_EQUIPMENT_MASTER_FILE_OBJID
     * @param string $equipmentno
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @param \StructType\MultiLangComments[] $multiLangComments
     */
    public function __construct($eVENT_EQUIPMENT_MASTER_FILE_OBJID = null, $equipmentno = null, array $multiLangDescriptions = array(), array $multiLangComments = array())
    {
        $this
            ->setEVENT_EQUIPMENT_MASTER_FILE_OBJID($eVENT_EQUIPMENT_MASTER_FILE_OBJID)
            ->setEquipmentno($equipmentno)
            ->setMultiLangDescriptions($multiLangDescriptions)
            ->setMultiLangComments($multiLangComments);
    }
    /**
     * Get EVENT_EQUIPMENT_MASTER_FILE_OBJID value
     * @return string
     */
    public function getEVENT_EQUIPMENT_MASTER_FILE_OBJID()
    {
        return $this->{'EVENT-EQUIPMENT-MASTER-FILE-OBJID'};
    }
    /**
     * Set EVENT_EQUIPMENT_MASTER_FILE_OBJID value
     * @param string $eVENT_EQUIPMENT_MASTER_FILE_OBJID
     * @return \StructType\EventEquipmentMasterFile
     */
    public function setEVENT_EQUIPMENT_MASTER_FILE_OBJID($eVENT_EQUIPMENT_MASTER_FILE_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eVENT_EQUIPMENT_MASTER_FILE_OBJID) && !is_string($eVENT_EQUIPMENT_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eVENT_EQUIPMENT_MASTER_FILE_OBJID, true), gettype($eVENT_EQUIPMENT_MASTER_FILE_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eVENT_EQUIPMENT_MASTER_FILE_OBJID) && !preg_match('/([0-9])*/', $eVENT_EQUIPMENT_MASTER_FILE_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eVENT_EQUIPMENT_MASTER_FILE_OBJID, true)), __LINE__);
        }
        $this->EVENT_EQUIPMENT_MASTER_FILE_OBJID = $this->{'EVENT-EQUIPMENT-MASTER-FILE-OBJID'} = $eVENT_EQUIPMENT_MASTER_FILE_OBJID;
        return $this;
    }
    /**
     * Get equipmentno value
     * @return string
     */
    public function getEquipmentno()
    {
        return $this->equipmentno;
    }
    /**
     * Set equipmentno value
     * @param string $equipmentno
     * @return \StructType\EventEquipmentMasterFile
     */
    public function setEquipmentno($equipmentno = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentno) && !is_string($equipmentno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equipmentno, true), gettype($equipmentno)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($equipmentno) && mb_strlen($equipmentno) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($equipmentno)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($equipmentno) && mb_strlen($equipmentno) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($equipmentno)), __LINE__);
        }
        $this->equipmentno = $equipmentno;
        return $this;
    }
    /**
     * Get MultiLangDescriptions value
     * @return \StructType\MultiLangDescriptions[]|null
     */
    public function getMultiLangDescriptions()
    {
        return $this->MultiLangDescriptions;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangDescriptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangDescriptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventEquipmentMasterFileMultiLangDescriptionsItem) {
            // validation for constraint: itemType
            if (!$eventEquipmentMasterFileMultiLangDescriptionsItem instanceof \StructType\MultiLangDescriptions) {
                $invalidValues[] = is_object($eventEquipmentMasterFileMultiLangDescriptionsItem) ? get_class($eventEquipmentMasterFileMultiLangDescriptionsItem) : sprintf('%s(%s)', gettype($eventEquipmentMasterFileMultiLangDescriptionsItem), var_export($eventEquipmentMasterFileMultiLangDescriptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions[] $multiLangDescriptions
     * @return \StructType\EventEquipmentMasterFile
     */
    public function setMultiLangDescriptions(array $multiLangDescriptions = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangDescriptionsArrayErrorMessage = self::validateMultiLangDescriptionsForArrayConstraintsFromSetMultiLangDescriptions($multiLangDescriptions))) {
            throw new \InvalidArgumentException($multiLangDescriptionsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangDescriptions = $multiLangDescriptions;
        return $this;
    }
    /**
     * Add item to MultiLangDescriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangDescriptions $item
     * @return \StructType\EventEquipmentMasterFile
     */
    public function addToMultiLangDescriptions(\StructType\MultiLangDescriptions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangDescriptions) {
            throw new \InvalidArgumentException(sprintf('The MultiLangDescriptions property can only contain items of type \StructType\MultiLangDescriptions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangDescriptions[] = $item;
        return $this;
    }
    /**
     * Get MultiLangComments value
     * @return \StructType\MultiLangComments[]|null
     */
    public function getMultiLangComments()
    {
        return $this->MultiLangComments;
    }
    /**
     * This method is responsible for validating the values passed to the setMultiLangComments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMultiLangComments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eventEquipmentMasterFileMultiLangCommentsItem) {
            // validation for constraint: itemType
            if (!$eventEquipmentMasterFileMultiLangCommentsItem instanceof \StructType\MultiLangComments) {
                $invalidValues[] = is_object($eventEquipmentMasterFileMultiLangCommentsItem) ? get_class($eventEquipmentMasterFileMultiLangCommentsItem) : sprintf('%s(%s)', gettype($eventEquipmentMasterFileMultiLangCommentsItem), var_export($eventEquipmentMasterFileMultiLangCommentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments[] $multiLangComments
     * @return \StructType\EventEquipmentMasterFile
     */
    public function setMultiLangComments(array $multiLangComments = array())
    {
        // validation for constraint: array
        if ('' !== ($multiLangCommentsArrayErrorMessage = self::validateMultiLangCommentsForArrayConstraintsFromSetMultiLangComments($multiLangComments))) {
            throw new \InvalidArgumentException($multiLangCommentsArrayErrorMessage, __LINE__);
        }
        $this->MultiLangComments = $multiLangComments;
        return $this;
    }
    /**
     * Add item to MultiLangComments value
     * @throws \InvalidArgumentException
     * @param \StructType\MultiLangComments $item
     * @return \StructType\EventEquipmentMasterFile
     */
    public function addToMultiLangComments(\StructType\MultiLangComments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultiLangComments) {
            throw new \InvalidArgumentException(sprintf('The MultiLangComments property can only contain items of type \StructType\MultiLangComments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MultiLangComments[] = $item;
        return $this;
    }
}
