<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EquipmentReservation StructType
 * @subpackage Structs
 */
class EquipmentReservation extends AbstractStructBase
{
    /**
     * The EQUIPMENT_RESERVATION_OBJID
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9])*
     * @var string
     */
    public $EQUIPMENT_RESERVATION_OBJID;
    /**
     * Constructor method for EquipmentReservation
     * @uses EquipmentReservation::setEQUIPMENT_RESERVATION_OBJID()
     * @param string $eQUIPMENT_RESERVATION_OBJID
     */
    public function __construct($eQUIPMENT_RESERVATION_OBJID = null)
    {
        $this
            ->setEQUIPMENT_RESERVATION_OBJID($eQUIPMENT_RESERVATION_OBJID);
    }
    /**
     * Get EQUIPMENT_RESERVATION_OBJID value
     * @return string
     */
    public function getEQUIPMENT_RESERVATION_OBJID()
    {
        return $this->{'EQUIPMENT-RESERVATION-OBJID'};
    }
    /**
     * Set EQUIPMENT_RESERVATION_OBJID value
     * @param string $eQUIPMENT_RESERVATION_OBJID
     * @return \StructType\EquipmentReservation
     */
    public function setEQUIPMENT_RESERVATION_OBJID($eQUIPMENT_RESERVATION_OBJID = null)
    {
        // validation for constraint: string
        if (!is_null($eQUIPMENT_RESERVATION_OBJID) && !is_string($eQUIPMENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eQUIPMENT_RESERVATION_OBJID, true), gettype($eQUIPMENT_RESERVATION_OBJID)), __LINE__);
        }
        // validation for constraint: pattern(([0-9])*)
        if (!is_null($eQUIPMENT_RESERVATION_OBJID) && !preg_match('/([0-9])*/', $eQUIPMENT_RESERVATION_OBJID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9])*', var_export($eQUIPMENT_RESERVATION_OBJID, true)), __LINE__);
        }
        $this->EQUIPMENT_RESERVATION_OBJID = $this->{'EQUIPMENT-RESERVATION-OBJID'} = $eQUIPMENT_RESERVATION_OBJID;
        return $this;
    }
}
