<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositInWithPayment StructType
 * @subpackage Structs
 */
class DepositInWithPayment extends AbstractStructBase
{
    /**
     * The transactionid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transactionid;
    /**
     * The typeofpayment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $typeofpayment;
    /**
     * The paymentamount
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([-+]){0,1}([0-9])*\.{0,1}([0-9])*
     * @var string
     */
    public $paymentamount;
    /**
     * The approvalnumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $approvalnumber;
    /**
     * The processingdate
     * Meta information extracted from the WSDL
     * - base: string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([0-9]{4})-([0-9]{2})-([0-9]{2})|
     * @var string
     */
    public $processingdate;
    /**
     * The serviceprovider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceprovider;
    /**
     * The paymentdescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentdescription;
    /**
     * Constructor method for DepositInWithPayment
     * @uses DepositInWithPayment::setTransactionid()
     * @uses DepositInWithPayment::setTypeofpayment()
     * @uses DepositInWithPayment::setPaymentamount()
     * @uses DepositInWithPayment::setApprovalnumber()
     * @uses DepositInWithPayment::setProcessingdate()
     * @uses DepositInWithPayment::setServiceprovider()
     * @uses DepositInWithPayment::setPaymentdescription()
     * @param string $transactionid
     * @param string $typeofpayment
     * @param string $paymentamount
     * @param string $approvalnumber
     * @param string $processingdate
     * @param string $serviceprovider
     * @param string $paymentdescription
     */
    public function __construct($transactionid = null, $typeofpayment = null, $paymentamount = null, $approvalnumber = null, $processingdate = null, $serviceprovider = null, $paymentdescription = null)
    {
        $this
            ->setTransactionid($transactionid)
            ->setTypeofpayment($typeofpayment)
            ->setPaymentamount($paymentamount)
            ->setApprovalnumber($approvalnumber)
            ->setProcessingdate($processingdate)
            ->setServiceprovider($serviceprovider)
            ->setPaymentdescription($paymentdescription);
    }
    /**
     * Get transactionid value
     * @return string
     */
    public function getTransactionid()
    {
        return $this->transactionid;
    }
    /**
     * Set transactionid value
     * @param string $transactionid
     * @return \StructType\DepositInWithPayment
     */
    public function setTransactionid($transactionid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionid) && !is_string($transactionid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionid, true), gettype($transactionid)), __LINE__);
        }
        $this->transactionid = $transactionid;
        return $this;
    }
    /**
     * Get typeofpayment value
     * @return string
     */
    public function getTypeofpayment()
    {
        return $this->typeofpayment;
    }
    /**
     * Set typeofpayment value
     * @param string $typeofpayment
     * @return \StructType\DepositInWithPayment
     */
    public function setTypeofpayment($typeofpayment = null)
    {
        // validation for constraint: string
        if (!is_null($typeofpayment) && !is_string($typeofpayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeofpayment, true), gettype($typeofpayment)), __LINE__);
        }
        $this->typeofpayment = $typeofpayment;
        return $this;
    }
    /**
     * Get paymentamount value
     * @return string
     */
    public function getPaymentamount()
    {
        return $this->paymentamount;
    }
    /**
     * Set paymentamount value
     * @param string $paymentamount
     * @return \StructType\DepositInWithPayment
     */
    public function setPaymentamount($paymentamount = null)
    {
        // validation for constraint: string
        if (!is_null($paymentamount) && !is_string($paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentamount, true), gettype($paymentamount)), __LINE__);
        }
        // validation for constraint: pattern(([-+]){0,1}([0-9])*\.{0,1}([0-9])*)
        if (!is_null($paymentamount) && !preg_match('/([-+]){0,1}([0-9])*\\.{0,1}([0-9])*/', $paymentamount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([-+]){0,1}([0-9])*\.{0,1}([0-9])*', var_export($paymentamount, true)), __LINE__);
        }
        $this->paymentamount = $paymentamount;
        return $this;
    }
    /**
     * Get approvalnumber value
     * @return string
     */
    public function getApprovalnumber()
    {
        return $this->approvalnumber;
    }
    /**
     * Set approvalnumber value
     * @param string $approvalnumber
     * @return \StructType\DepositInWithPayment
     */
    public function setApprovalnumber($approvalnumber = null)
    {
        // validation for constraint: string
        if (!is_null($approvalnumber) && !is_string($approvalnumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalnumber, true), gettype($approvalnumber)), __LINE__);
        }
        $this->approvalnumber = $approvalnumber;
        return $this;
    }
    /**
     * Get processingdate value
     * @return string
     */
    public function getProcessingdate()
    {
        return $this->processingdate;
    }
    /**
     * Set processingdate value
     * @param string $processingdate
     * @return \StructType\DepositInWithPayment
     */
    public function setProcessingdate($processingdate = null)
    {
        // validation for constraint: string
        if (!is_null($processingdate) && !is_string($processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processingdate, true), gettype($processingdate)), __LINE__);
        }
        // validation for constraint: pattern(([0-9]{4})-([0-9]{2})-([0-9]{2})|)
        if (!is_null($processingdate) && !preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})|/', $processingdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([0-9]{4})-([0-9]{2})-([0-9]{2})|', var_export($processingdate, true)), __LINE__);
        }
        $this->processingdate = $processingdate;
        return $this;
    }
    /**
     * Get serviceprovider value
     * @return string|null
     */
    public function getServiceprovider()
    {
        return $this->serviceprovider;
    }
    /**
     * Set serviceprovider value
     * @param string $serviceprovider
     * @return \StructType\DepositInWithPayment
     */
    public function setServiceprovider($serviceprovider = null)
    {
        // validation for constraint: string
        if (!is_null($serviceprovider) && !is_string($serviceprovider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceprovider, true), gettype($serviceprovider)), __LINE__);
        }
        $this->serviceprovider = $serviceprovider;
        return $this;
    }
    /**
     * Get paymentdescription value
     * @return string|null
     */
    public function getPaymentdescription()
    {
        return $this->paymentdescription;
    }
    /**
     * Set paymentdescription value
     * @param string $paymentdescription
     * @return \StructType\DepositInWithPayment
     */
    public function setPaymentdescription($paymentdescription = null)
    {
        // validation for constraint: string
        if (!is_null($paymentdescription) && !is_string($paymentdescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentdescription, true), gettype($paymentdescription)), __LINE__);
        }
        $this->paymentdescription = $paymentdescription;
        return $this;
    }
}
